/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.walkingpapers;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.walkingpapers.WalkingPapersLayer;
import org.openstreetmap.josm.tools.I18n;

public class WalkingPapersAddLayerAction
extends JosmAction {
    public WalkingPapersAddLayerAction() {
        super(I18n.tr((String)"Scanned Map...", (Object[])new Object[0]), "walkingpapers", I18n.tr((String)"Display a map that was previously scanned and uploaded to walking-papers.org", (Object[])new Object[0]), null, false);
    }

    public void actionPerformed(ActionEvent e) {
        String wpid = JOptionPane.showInputDialog(Main.parent, I18n.tr((String)"Enter a walking-papers.org URL or ID (the bit after the ?id= in the URL)", (Object[])new Object[0]), Main.pref.get("walkingpapers.last-used-id"));
        if (wpid == null || wpid.equals("")) {
            return;
        }
        String mungedWpId = WalkingPapersAddLayerAction.getWalkingPapersId(wpid);
        if (mungedWpId == null || mungedWpId.equals("")) {
            return;
        }
        String wpUrl = Main.pref.get("walkingpapers.base-url", "http://walking-papers.org/") + "scan.php?id=" + mungedWpId;
        Pattern spanPattern = Pattern.compile("<span class=\"(\\S+)\">(\\S+)</span>");
        double north = 0.0;
        double south = 0.0;
        double east = 0.0;
        double west = 0.0;
        int minz = -1;
        int maxz = -1;
        String tile = null;
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(new URL(wpUrl).openStream(), "utf-8"));
            String line = r.readLine();
            while (line != null) {
                Matcher m = spanPattern.matcher(line);
                if (m.find()) {
                    if ("tile".equals(m.group(1))) {
                        tile = m.group(2);
                    } else if ("north".equals(m.group(1))) {
                        north = Double.parseDouble(m.group(2));
                    } else if ("south".equals(m.group(1))) {
                        south = Double.parseDouble(m.group(2));
                    } else if ("east".equals(m.group(1))) {
                        east = Double.parseDouble(m.group(2));
                    } else if ("west".equals(m.group(1))) {
                        west = Double.parseDouble(m.group(2));
                    } else if ("minzoom".equals(m.group(1))) {
                        minz = Integer.parseInt(m.group(2));
                    } else if ("maxzoom".equals(m.group(1))) {
                        maxz = Integer.parseInt(m.group(2));
                    }
                }
                line = r.readLine();
            }
            r.close();
            if (tile == null || north == 0.0 && south == 0.0 || east == 0.0 && west == 0.0) {
                throw new Exception();
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Could not read information from walking-papers.org the id \"{0}\"", (Object[])new Object[]{mungedWpId}));
            return;
        }
        tile = tile.replaceFirst(mungedWpId + "/" + mungedWpId, mungedWpId);
        Main.pref.put("walkingpapers.last-used-id", mungedWpId);
        Bounds b = new Bounds(new LatLon(south, west), new LatLon(north, east));
        WalkingPapersLayer wpl = new WalkingPapersLayer(mungedWpId, tile, b, minz, maxz);
        Main.main.addLayer((Layer)wpl);
    }

    private static String getWalkingPapersId(String wpid) {
        if (!wpid.contains("id=")) {
            return wpid;
        }
        Pattern pattern = Pattern.compile("\\?id=(\\S+)");
        Matcher matcher = pattern.matcher(wpid);
        boolean found = matcher.find();
        if (found) {
            return matcher.group(1);
        }
        return null;
    }
}

