/*
 * Decompiled with CFR 0.152.
 */
package utilsplugin2;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UtilsPluginPreferences
implements PreferenceSetting {
    private final String defaultURL = "http://ru.wikipedia.org/w/index.php?search={name}&fulltext=Search";
    HistoryComboBox combo1 = new HistoryComboBox();
    JTable table;
    JButton resetButton;
    JButton loadButton;
    JButton saveButton;

    public void addGui(PreferenceTabbedPane gui) {
        JPanel pp = gui.createPreferenceTab("utils", I18n.tr((String)"Utilsplugin2 settings [TESTING]", (Object[])new Object[0]), I18n.tr((String)"Here you can change some preferences of Utilsplugin2 functions", (Object[])new Object[0]));
        JPanel all = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        all.setLayout(layout);
        List<String> items = (List<String>)Main.pref.getCollection("utilsplugin2.urlHistory");
        if (items == null) {
            items = this.resetURLList();
            this.fillRows(items);
        }
        String addr = Main.pref.get("utilsplugin2.customurl", "http://ru.wikipedia.org/w/index.php?search={name}&fulltext=Search");
        this.resetButton = new JButton(I18n.tr((String)"Reset", (Object[])new Object[0]));
        this.resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UtilsPluginPreferences.this.fillRows(UtilsPluginPreferences.this.resetURLList());
            }
        });
        this.saveButton = new JButton(I18n.tr((String)"Save to file", (Object[])new Object[0]));
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UtilsPluginPreferences.this.saveURLList();
            }
        });
        this.loadButton = new JButton(I18n.tr((String)"Load from file", (Object[])new Object[0]));
        this.loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UtilsPluginPreferences.this.fillRows(UtilsPluginPreferences.this.loadURLList());
            }
        });
        this.table = new JTable(new DefaultTableModel((Object[][])null, new String[]{"Title", "URL"}));
        this.fillRows(items);
        HtmlPanel help = new HtmlPanel(I18n.tr((String)"Please edit custom URLs and select one row to use with the tool<br/> <b>&#123;key&#125;</b> is replaced with the tag value<br/> <b>&#123;#id&#125;</b> is replaced with the element ID<br/> <b>&#123;#type&#125;</b> is replaced with \"node\",\"way\" or \"relation\" <br/> <b>&#123;#lat&#125; , &#123;#lon&#125;</b> is replaced with map center latitude/longitude <br/> Your can manually load settings from file <b>customurl.txt</b> in JOSM folder", (Object[])new Object[0]));
        all.add((Component)new JLabel(I18n.tr((String)"Custom URL configuration", (Object[])new Object[0])), GBC.std().insets(5, 10, 0, 0));
        all.add((Component)this.resetButton, GBC.std().insets(25, 10, 0, 0));
        all.add((Component)this.loadButton, GBC.std().insets(25, 10, 0, 0));
        all.add((Component)this.saveButton, GBC.eol().insets(25, 10, 0, 0));
        all.add((Component)help, GBC.eop().insets(5, 10, 0, 0));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(0).setMaxWidth(300);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.table.setSelectionMode(0);
        this.table.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                int row = e.getFirstRow();
                int column = e.getColumn();
                DefaultTableModel model = (DefaultTableModel)e.getSource();
                if (row < 0 || column < 0) {
                    return;
                }
                String data = (String)model.getValueAt(row, column);
                if (data != null && data.length() > 0 && row == model.getRowCount() - 1) {
                    model.addRow(new String[]{"", ""});
                }
            }
        });
        all.add((Component)this.table, GBC.eop().fill());
        pp.add((Component)all, GBC.eol().fill(1));
    }

    private void fillRows(List<String> items) {
        if (items == null) {
            return;
        }
        int p = 0;
        int row = 0;
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        model.setRowCount(0);
        int n = items.size();
        while (p < n) {
            String name = items.get(p);
            if (++p >= n) break;
            String url = items.get(p);
            ++p;
            model.addRow(new String[]{name, url});
            ++row;
        }
        model.addRow(new String[]{"", ""});
    }

    public boolean ok() {
        String addr = this.combo1.getText();
        List<String> lst = this.readItemsFromTable();
        Main.pref.putCollection("utilsplugin2.urlHistory", lst);
        try {
            Main.pref.save();
        }
        catch (IOException ex) {
            Logger.getLogger(UtilsPluginPreferences.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    private List<String> resetURLList() {
        ArrayList<String> items = new ArrayList<String>();
        items = new ArrayList();
        items.add("Wikipedia");
        items.add("http://en.wikipedia.org/w/index.php?search={name}&fulltext=Search");
        items.add("Wikipedia RU");
        items.add("http://ru.wikipedia.org/w/index.php?search={name}&fulltext=Search");
        items.add("LatLon buildings");
        items.add("http://latlon.org/buildings?zoom=17&lat={#lat}&lon={#lon}&layers=B");
        items.add("AMDMi3 Russian streets");
        items.add("http://addresses.amdmi3.ru/?zoom=11&lat={#lat}&lon={#lon}&layers=B00");
        items.add("Element history [demo, =Ctrl-Shift-H]");
        items.add("http://www.openstreetmap.org/browse/{#type}/{#id}/history");
        items.add("Browse element [demo, =Ctrl-Shift-I]");
        items.add("http://www.openstreetmap.org/browse/{#type}/{#id}");
        Main.pref.putCollection("utilsplugin2.urlHistory", items);
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> loadURLList() {
        ArrayList<String> items = new ArrayList<String>();
        BufferedReader fr = null;
        try {
            String s;
            File f = new File(Main.pref.getPreferencesDir(), "customurl.txt");
            fr = new BufferedReader(new FileReader(f));
            while ((s = fr.readLine()) != null) {
                items.add(s);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fr != null) {
                    fr.close();
                }
            }
            catch (Exception exception) {}
        }
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveURLList() {
        List<String> items = this.readItemsFromTable();
        File f = new File(Main.pref.getPreferencesDir(), "customurl.txt");
        PrintWriter fw = null;
        try {
            fw = new PrintWriter(f);
            for (String s : items) {
                fw.println(s);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private List<String> readItemsFromTable() {
        String v;
        TableModel model = this.table.getModel();
        ArrayList<String> lst = new ArrayList<String>();
        int n = model.getRowCount();
        for (int i = 0; i < n; ++i) {
            v = (String)model.getValueAt(i, 0);
            if (v.length() == 0) continue;
            lst.add(v);
            v = (String)model.getValueAt(i, 1);
            lst.add(v);
        }
        int row = this.table.getSelectedRow();
        if (row != -1) {
            v = (String)model.getValueAt(row, 1);
            Main.pref.put("utilsplugin2.customurl", v);
        }
        return lst;
    }
}

