/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.qa;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.Issue;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ImageProvider;

public class IssueView
extends JPanel {
    private HtmlPanel pnlMessage;
    private JPanel pnlActions;
    private Issue issue;
    private JLabel lblIcon;
    private StyleSheet styleSheet;

    protected void initStyleSheet(HtmlPanel view) {
        StyleSheet ss = ((HTMLEditorKit)view.getEditorPane().getEditorKit()).getStyleSheet();
        ss.addRule("em {font-style: italic}");
        ss.addRule("tt {font-family: Courier New}");
        ss.addRule(".object-name {background-color:rgb(240,240,240); color: blue;}");
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY, 1));
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 3;
        gc.gridheight = 2;
        gc.weightx = 0.0;
        gc.weighty = 1.0;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.insets = new Insets(2, 2, 2, 2);
        this.lblIcon = new JLabel();
        this.add((Component)this.lblIcon, gc);
        this.lblIcon.setVerticalAlignment(1);
        this.lblIcon.setHorizontalAlignment(0);
        this.lblIcon.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        gc.insets = new Insets(0, 0, 0, 0);
        gc.anchor = 18;
        gc.fill = 1;
        gc.gridx = 1;
        gc.gridy = 0;
        gc.gridheight = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        this.pnlMessage = new HtmlPanel();
        this.add((Component)this.pnlMessage, gc);
        this.initStyleSheet(this.pnlMessage);
        this.pnlMessage.setBackground(Color.white);
        this.pnlMessage.setText("<html><body>" + this.issue.getText() + "</html></bod>");
        if (!this.issue.getActions().isEmpty()) {
            this.pnlActions = new JPanel(new FlowLayout(0));
            this.pnlActions.setBackground(Color.WHITE);
            for (Action action : this.issue.getActions()) {
                JButton btn = new JButton(action);
                this.pnlActions.add(btn);
            }
            gc.gridx = 1;
            gc.gridy = 1;
            gc.fill = 2;
            gc.weighty = 0.0;
            this.add((Component)this.pnlActions, gc);
        }
        switch (this.issue.getSeverity()) {
            case WARNING: {
                this.lblIcon.setIcon(ImageProvider.get((String)"warning-small"));
                break;
            }
            case ERROR: {
                this.lblIcon.setIcon(ImageProvider.get((String)"error"));
            }
        }
    }

    public IssueView(Issue issue) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)issue, (String)"issue");
        this.issue = issue;
        this.build();
    }

    @Override
    public Dimension getMinimumSize() {
        return super.getPreferredSize();
    }
}

