/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.embedded;

import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import uk.co.caprica.vlcj.log.Logger;
import uk.co.caprica.vlcj.player.embedded.FullScreenStrategy;

public class DefaultFullScreenStrategy
implements FullScreenStrategy {
    private final Window window;

    public DefaultFullScreenStrategy(Window window) {
        Logger.debug("DefaultFullScreenStrategy(window={})", window);
        if (window == null) {
            throw new IllegalArgumentException("Window must not be null");
        }
        this.window = window;
    }

    public void enterFullScreenMode() {
        Logger.debug("enterFullScreenMode()", new Object[0]);
        GraphicsDevice graphicsDevice = this.getScreenDevice();
        graphicsDevice.setFullScreenWindow(this.window);
        DisplayMode displayMode = this.getDisplayMode(graphicsDevice.getDisplayModes());
        if (displayMode != null) {
            graphicsDevice.setDisplayMode(displayMode);
        }
    }

    public void exitFullScreenMode() {
        Logger.debug("exitFullScreenMode()", new Object[0]);
        this.getScreenDevice().setFullScreenWindow(null);
    }

    public boolean isFullScreenMode() {
        Logger.debug("isFullScreenMode()", new Object[0]);
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getFullScreenWindow() != null;
    }

    protected GraphicsDevice getScreenDevice() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    }

    protected DisplayMode getDisplayMode(DisplayMode[] displayModes) {
        return null;
    }
}

