/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.plugins.piclayer.PicLayerAbstract;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ShearPictureAction
extends MapMode
implements MouseListener,
MouseMotionListener {
    private boolean mb_dragging = false;
    private EastNorth m_prevEastNorth;
    private PicLayerAbstract m_currentLayer = null;

    public ShearPictureAction(MapFrame frame) {
        super(I18n.tr((String)"PicLayer shear", (Object[])new Object[0]), "shear", I18n.tr((String)"Drag to shear the picture", (Object[])new Object[0]), frame, ImageProvider.getCursor((String)"crosshair", null));
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener((MouseListener)this);
        Main.map.mapView.addMouseMotionListener((MouseMotionListener)this);
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)this);
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)this);
    }

    public void mousePressed(MouseEvent e) {
        if (Main.map.mapView.getActiveLayer() instanceof PicLayerAbstract) {
            this.m_currentLayer = (PicLayerAbstract)Main.map.mapView.getActiveLayer();
            if (this.m_currentLayer != null && e.getButton() == 1) {
                this.mb_dragging = true;
                this.m_prevEastNorth = Main.map.mapView.getEastNorth(e.getX(), e.getY());
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.mb_dragging) {
            EastNorth eastNorth = Main.map.mapView.getEastNorth(e.getX(), e.getY());
            this.m_currentLayer.shearPictureBy(1000.0 * (eastNorth.east() - this.m_prevEastNorth.east()), 1000.0 * (eastNorth.north() - this.m_prevEastNorth.north()));
            this.m_prevEastNorth = eastNorth;
            Main.map.mapView.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.mb_dragging = false;
    }
}

