/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pbf.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.io.OsmImporter;
import org.openstreetmap.josm.plugins.pbf.PbfConstants;
import org.openstreetmap.josm.plugins.pbf.io.PbfReader;
import org.xml.sax.SAXException;

public class PbfImporter
extends OsmImporter
implements PbfConstants {
    public PbfImporter() {
        super(FILE_FILTER);
    }

    protected void importData(InputStream in, File associatedFile) throws IllegalDataException {
        DataSet dataSet = PbfReader.parseDataSet(in, NullProgressMonitor.INSTANCE);
        OsmDataLayer layer = new OsmDataLayer(dataSet, associatedFile.getName(), associatedFile);
        this.addDataLayer(dataSet, layer, associatedFile.getPath());
    }

    protected DataSet parseDataSet(String source) throws IOException, SAXException, IllegalDataException {
        return PbfReader.parseDataSet((InputStream)new MirroredInputStream(source), NullProgressMonitor.INSTANCE);
    }
}

