/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j;

public class ProjCoordinate {
    public double x;
    public double y;
    public double z;

    public ProjCoordinate() {
        this(0.0, 0.0);
    }

    public ProjCoordinate(double argX, double argY, double argZ) {
        this.x = argX;
        this.y = argY;
        this.z = argZ;
    }

    public ProjCoordinate(double argX, double argY) {
        this.x = argX;
        this.y = argY;
        this.z = Double.NaN;
    }

    public ProjCoordinate(String argToParse) {
        int length;
        int positionOfCharBeforeLast;
        boolean startsWith = argToParse.startsWith("ProjCoordinate: ");
        if (!startsWith) {
            IllegalArgumentException toThrow = new IllegalArgumentException("The input string was not in the proper format.");
            throw toThrow;
        }
        String chomped = argToParse.substring(16);
        String withoutFrontBracket = chomped.substring(1);
        String withoutBackBracket = withoutFrontBracket.substring(0, positionOfCharBeforeLast = (length = withoutFrontBracket.length()) - 2);
        String[] parts = withoutBackBracket.split(" ");
        if (parts.length != 2 && parts.length != 3) {
            IllegalArgumentException toThrow = new IllegalArgumentException("The input string was not in the proper format.");
            throw toThrow;
        }
        this.x = Double.parseDouble(parts[0]);
        this.y = Double.parseDouble(parts[0]);
        if (parts.length == 3) {
            this.z = Double.parseDouble(parts[0]);
        }
    }

    public void setValue(ProjCoordinate p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
    }

    public boolean areXOrdinatesEqual(ProjCoordinate argToCompare, double argTolerance) {
        double difference = argToCompare.x - this.x;
        return !(difference > argTolerance);
    }

    public boolean areYOrdinatesEqual(ProjCoordinate argToCompare, double argTolerance) {
        double difference = argToCompare.y - this.y;
        return !(difference > argTolerance);
    }

    public boolean areZOrdinatesEqual(ProjCoordinate argToCompare, double argTolerance) {
        if (Double.isNaN(this.z)) {
            return Double.isNaN(argToCompare.z);
        }
        if (Double.isNaN(argToCompare.z)) {
            return false;
        }
        double difference = argToCompare.z - this.z;
        return !(difference > argTolerance);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ProjCoordinate[");
        builder.append(this.x);
        builder.append(" ");
        builder.append(this.y);
        builder.append(" ");
        builder.append(this.z);
        builder.append("]");
        return builder.toString();
    }

    public String toShortString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.x);
        builder.append(", ");
        builder.append(this.y);
        if (!Double.isNaN(this.z)) {
            builder.append(", ");
            builder.append(this.z);
        }
        builder.append("]");
        return builder.toString();
    }

    public boolean hasValidZOrdinate() {
        return !Double.isNaN(this.z);
    }

    public boolean hasValidXandYOrdinates() {
        if (Double.isNaN(this.x)) {
            return false;
        }
        if (Double.isInfinite(this.x)) {
            return false;
        }
        if (Double.isNaN(this.y)) {
            return false;
        }
        return !Double.isInfinite(this.y);
    }
}

