/*
 * Decompiled with CFR 0.152.
 */
package imageryadjust;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageryAdjustMapMode
extends MapMode
implements MouseListener,
MouseMotionListener {
    boolean mouseDown;
    EastNorth prevEastNorth;
    private ImageryLayer adjustingLayer;

    public ImageryAdjustMapMode(MapFrame mapFrame) {
        super(I18n.tr((String)"Adjust imagery", (Object[])new Object[0]), "adjustimg", I18n.tr((String)"Adjust the position of the selected imagery layer", (Object[])new Object[0]), mapFrame, ImageProvider.getCursor((String)"normal", (String)"move"));
    }

    public void enterMode() {
        super.enterMode();
        if (!this.hasImageryLayersToAdjust()) {
            this.warnNoImageryLayers();
            return;
        }
        List layers = Main.map.mapView.getLayersOfType(ImageryLayer.class);
        this.adjustingLayer = layers.size() == 1 ? (ImageryLayer)layers.get(0) : (ImageryLayer)this.askAdjustLayer(Main.map.mapView.getLayersOfType(ImageryLayer.class));
        if (this.adjustingLayer == null) {
            return;
        }
        if (!this.adjustingLayer.isVisible()) {
            this.adjustingLayer.setVisible(true);
        }
        Main.map.mapView.addMouseListener((MouseListener)this);
        Main.map.mapView.addMouseMotionListener((MouseMotionListener)this);
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)this);
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)this);
        this.adjustingLayer = null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        if (this.adjustingLayer.isVisible()) {
            this.prevEastNorth = Main.map.mapView.getEastNorth(e.getX(), e.getY());
            Main.map.mapView.setCursor(Cursor.getPredefinedCursor(13));
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.adjustingLayer == null || this.prevEastNorth == null) {
            return;
        }
        EastNorth eastNorth = Main.map.mapView.getEastNorth(e.getX(), e.getY());
        this.adjustingLayer.displace(eastNorth.east() - this.prevEastNorth.east(), eastNorth.north() - this.prevEastNorth.north());
        this.prevEastNorth = eastNorth;
        Main.map.mapView.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Main.map.mapView.repaint();
        Main.map.mapView.setCursor(Cursor.getDefaultCursor());
        this.prevEastNorth = null;
    }

    public boolean layerIsSupported(Layer l) {
        return this.hasImageryLayersToAdjust();
    }

    protected Layer askAdjustLayer(List<? extends Layer> adjustableLayers) {
        JComboBox<Object> layerList = new JComboBox<Object>();
        layerList.setRenderer(new LayerListCellRenderer());
        layerList.setModel(new DefaultComboBoxModel<Object>(adjustableLayers.toArray()));
        layerList.setSelectedIndex(0);
        JPanel pnl = new JPanel();
        pnl.setLayout(new GridBagLayout());
        pnl.add((Component)new JLabel(I18n.tr((String)"Please select the imagery layer to adjust.", (Object[])new Object[0])), GBC.eol());
        pnl.add(layerList, GBC.eol());
        ExtendedDialog diag = new ExtendedDialog(Main.parent, I18n.tr((String)"Select imagery layer", (Object[])new Object[0]), new String[]{I18n.tr((String)"Start adjusting", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])});
        diag.setContent((Component)pnl);
        diag.setButtonIcons(new String[]{"mapmode/adjustimg", "cancel"});
        diag.showDialog();
        int decision = diag.getValue();
        if (decision != 1) {
            return null;
        }
        Layer adjustLayer = (Layer)layerList.getSelectedItem();
        return adjustLayer;
    }

    protected void warnNoImageryLayers() {
        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"There are currently no imagery layer to adjust.", (Object[])new Object[0]), I18n.tr((String)"No layers to adjust", (Object[])new Object[0]), 2);
    }

    protected boolean hasImageryLayersToAdjust() {
        if (Main.map == null) {
            return false;
        }
        if (Main.map.mapView == null) {
            return false;
        }
        return !Main.map.mapView.getLayersOfType(ImageryLayer.class).isEmpty();
    }

    protected void updateEnabledState() {
        this.setEnabled(this.hasImageryLayersToAdjust());
    }

    public static class LayerListCellRenderer
    extends DefaultListCellRenderer {
        protected boolean isActiveLayer(Layer layer) {
            if (Main.map == null) {
                return false;
            }
            if (Main.map.mapView == null) {
                return false;
            }
            return Main.map.mapView.getActiveLayer() == layer;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Layer layer = (Layer)value;
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, layer.getName(), index, isSelected, cellHasFocus);
            Icon icon = layer.getIcon();
            label.setIcon(icon);
            label.setToolTipText(layer.getToolTipText());
            return label;
        }
    }
}

