/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugin.download_along;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Future;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTaskList;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class DownloadAlong
extends Plugin {
    private static final String PREF_DOWNLOAD_ALONG_TRACK_DISTANCE = "downloadAlong.downloadAlongTrack.distance";
    private static final String PREF_DOWNLOAD_ALONG_TRACK_AREA = "downloadAlong.downloadAlongTrack.area";
    JMenuItem DownloadAlong;

    public DownloadAlong(PluginInformation info) {
        super(info);
        this.DownloadAlong = MainMenu.add((JMenu)Main.main.menu.toolsMenu, (JosmAction)new DownloadAlongAction());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DownloadAlongAction
    extends JosmAction {
        private static final long serialVersionUID = 1L;

        public DownloadAlongAction() {
            super(I18n.tr((String)"Download along...", (Object[])new Object[0]), "download_along", I18n.tr((String)"Download OSM data along the selected ways.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:download_along", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Download Along", (Object[])new Object[0])}), (int)68, (int)3, (int)576), true);
        }

        public void actionPerformed(ActionEvent e) {
            Collection selection = Main.main.getCurrentDataSet().getSelected();
            int ways = 0;
            for (OsmPrimitive prim : selection) {
                if (!(prim instanceof Way)) continue;
                ++ways;
            }
            if (ways < 1) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select 1 or more ways to download along", (Object[])new Object[0]));
                return;
            }
            JPanel msg = new JPanel(new GridBagLayout());
            Integer[] dist = new Integer[]{5000, 500, 50};
            Integer[] area = new Integer[]{20, 10, 5, 1};
            msg.add((Component)new JLabel(I18n.tr((String)"Download everything within:", (Object[])new Object[0])), GBC.eol());
            String[] s = new String[dist.length];
            for (int i = 0; i < dist.length; ++i) {
                s[i] = I18n.tr((String)"{0} meters", (Object[])new Object[]{dist[i]});
            }
            JList<String> buffer = new JList<String>(s);
            buffer.setSelectedIndex(Main.pref.getInteger(org.openstreetmap.josm.plugin.download_along.DownloadAlong.PREF_DOWNLOAD_ALONG_TRACK_DISTANCE, 0));
            msg.add(buffer, GBC.eol());
            msg.add((Component)new JLabel(I18n.tr((String)"Maximum area per request:", (Object[])new Object[0])), GBC.eol());
            s = new String[area.length];
            for (int i = 0; i < area.length; ++i) {
                s[i] = I18n.tr((String)"{0} sq km", (Object[])new Object[]{area[i]});
            }
            JList<String> maxRect = new JList<String>(s);
            maxRect.setSelectedIndex(Main.pref.getInteger(org.openstreetmap.josm.plugin.download_along.DownloadAlong.PREF_DOWNLOAD_ALONG_TRACK_AREA, 0));
            msg.add(maxRect, GBC.eol());
            int ret = JOptionPane.showConfirmDialog(Main.parent, msg, I18n.tr((String)"Download from OSM along this track", (Object[])new Object[0]), 2, 3);
            switch (ret) {
                case -1: 
                case 2: {
                    return;
                }
            }
            Main.pref.putInteger(org.openstreetmap.josm.plugin.download_along.DownloadAlong.PREF_DOWNLOAD_ALONG_TRACK_DISTANCE, Integer.valueOf(buffer.getSelectedIndex()));
            Main.pref.putInteger(org.openstreetmap.josm.plugin.download_along.DownloadAlong.PREF_DOWNLOAD_ALONG_TRACK_AREA, Integer.valueOf(maxRect.getSelectedIndex()));
            double latsum = 0.0;
            int latcnt = 0;
            for (OsmPrimitive prim : selection) {
                Way way = (Way)prim;
                for (Node n : way.getNodes()) {
                    latsum += n.getCoor().lat();
                    ++latcnt;
                }
            }
            double avglat = latsum / (double)latcnt;
            double scale = Math.cos(Math.toRadians(avglat));
            Integer i = buffer.getSelectedIndex();
            int buffer_dist = dist[i < 0 ? 0 : i];
            double buffer_y = (double)buffer_dist / 100000.0;
            double buffer_x = buffer_y / scale;
            i = maxRect.getSelectedIndex();
            double max_area = (double)area[i < 0 ? 0 : i].intValue() / 10000.0 / scale;
            Area a = new Area();
            Rectangle2D.Double r = new Rectangle2D.Double();
            LatLon previous = null;
            for (OsmPrimitive prim : selection) {
                Way way = (Way)prim;
                for (Node p : way.getNodes()) {
                    LatLon c = p.getCoor();
                    ArrayList<LatLon> intermediateNodes = new ArrayList<LatLon>();
                    if (previous != null && c.greatCircleDistance(previous) > (double)buffer_dist) {
                        Double d = c.greatCircleDistance(previous) / (double)buffer_dist;
                        int nbNodes = d.intValue();
                        System.out.println(I18n.tr((String)"{0} intermediate nodes to download.", (Object[])new Object[]{nbNodes}));
                        System.out.println(I18n.tr((String)"between {0} {1} and {2} {3}", (Object[])new Object[]{c.lat(), c.lon(), previous.lat(), previous.lon()}));
                        i = 1;
                        while (i < nbNodes) {
                            intermediateNodes.add(new LatLon(previous.lat() + (double)i.intValue() * (c.lat() - previous.lat()) / (double)(nbNodes + 1), previous.lon() + (double)i.intValue() * (c.lon() - previous.lon()) / (double)(nbNodes + 1)));
                            System.out.println(I18n.tr((String)"  adding {0} {1}", (Object[])new Object[]{previous.lat() + (double)i.intValue() * (c.lat() - previous.lat()) / (double)(nbNodes + 1), previous.lon() + (double)i.intValue() * (c.lon() - previous.lon()) / (double)(nbNodes + 1)}));
                            Integer n = i;
                            Integer n2 = i = Integer.valueOf(i + 1);
                        }
                    }
                    intermediateNodes.add(c);
                    for (LatLon d : intermediateNodes) {
                        if (previous != null && !(d.greatCircleDistance(previous) > (double)buffer_dist)) continue;
                        ((Rectangle2D)r).setRect(d.lon() - buffer_x, d.lat() - buffer_y, 2.0 * buffer_x, 2.0 * buffer_y);
                        a.add(new Area(r));
                        previous = d;
                    }
                    previous = c;
                }
            }
            ArrayList<Rectangle2D> toDownload = new ArrayList<Rectangle2D>();
            DownloadAlongAction.addToDownload(a, a.getBounds(), toDownload, max_area);
            msg = new JPanel(new GridBagLayout());
            msg.add((Component)new JLabel(I18n.tr((String)"<html>This action will require {0} individual<br>download requests. Do you wish<br>to continue?</html>", (Object[])new Object[]{toDownload.size()})), GBC.eol());
            if (toDownload.size() > 1) {
                ret = JOptionPane.showConfirmDialog(Main.parent, msg, I18n.tr((String)"Download from OSM along this track", (Object[])new Object[0]), 2, -1);
                switch (ret) {
                    case -1: 
                    case 2: {
                        return;
                    }
                }
            }
            final PleaseWaitProgressMonitor monitor = new PleaseWaitProgressMonitor(I18n.tr((String)"Download data", (Object[])new Object[0]));
            final Future future = new DownloadOsmTaskList().download(false, toDownload, (ProgressMonitor)monitor);
            Main.worker.submit(new Runnable(){

                public void run() {
                    try {
                        future.get();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                    monitor.close();
                }
            });
        }

        private static void addToDownload(Area a, Rectangle2D r, Collection<Rectangle2D> results, double max_area) {
            Area tmp = new Area(r);
            tmp.intersect(a);
            if (tmp.isEmpty()) {
                return;
            }
            Rectangle2D bounds = tmp.getBounds2D();
            if (bounds.getWidth() * bounds.getHeight() > max_area) {
                Rectangle2D.Double r2;
                Rectangle2D.Double r1;
                if (bounds.getWidth() > bounds.getHeight()) {
                    r1 = new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth() / 2.0, bounds.getHeight());
                    r2 = new Rectangle2D.Double(bounds.getX() + bounds.getWidth() / 2.0, bounds.getY(), bounds.getWidth() / 2.0, bounds.getHeight());
                } else {
                    r1 = new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight() / 2.0);
                    r2 = new Rectangle2D.Double(bounds.getX(), bounds.getY() + bounds.getHeight() / 2.0, bounds.getWidth(), bounds.getHeight() / 2.0);
                }
                DownloadAlongAction.addToDownload(a, r1, results, max_area);
                DownloadAlongAction.addToDownload(a, r2, results, max_area);
            } else {
                results.add(bounds);
            }
        }

        protected void updateEnabledState() {
            this.setEnabled(DownloadAlongAction.getEditLayer() != null);
        }

        protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        }
    }
}

