/*
 * Copyright (c) 2008-2010 Institut Geographique National France, released
 * under the
 * BSD license.
 */
// ==========================================================================================================
// Configuration par territoire :
// ==========================================================================================================
var TERRITORIES_INFO= {
  'france':{
    territory:'FXX',
    projection:'IGNF:GEOPORTALFXX',
    allowedDisplayProjections:['IGNF:LAMB93', 'IGNF:RGF93G'],
    minZoomLevel:5,
    maxZoomLevel:15,
    restrictedExtent:[-5.50,40,11,52],
    center:[2.563017, 46.313031],
    zoom:5,
    // allow different layers/territory :
    layers: [
    {
      name:"Réseau GNSS Permanent",
      params:{
        layers:'rgp'
      },
      options:{
        minZoomLevel:5,
        maxZoomLevel:15,
        opacity:1.0
      }
    },
    {
      name:"Sites de base",
      params:{
        layers:'sit_rbf'
      },
      options:{
        minZoomLevel:8,
        maxZoomLevel:15,
        opacity:1.0
      }
    },
    {
      name:"Sites de détail",
      params:{
        layers:'sit_rdf'
      },
      options:{
        minZoomLevel:10,
        maxZoomLevel:15,
        opacity:1.0
      }
    },
    {
      name:"Emprise de triplet",
      params:{
        layers:'triplet'
      },
      options:{
        minZoomLevel:12,
        maxZoomLevel:15,
        opacity:0.6
      }
    },
    {
      name:"Limite des cartes (1/50000)",
      params:{
        layers:'limite_carte'
      },
      options:{
        minZoomLevel:6,
        maxZoomLevel:15,
        opacity:1.0
      }
    },
    {
      name:"Repères de Nivellement",
      params:{
        layers:'rn'
      },
      options:{
        minZoomLevel:12,
        maxZoomLevel:15,
        opacity:1.0
      }
    }
    ],
    wxsUrl:'http://'+getServiceBaseUrl()+'/cgi-bin/mapserv?map=/var/webapp/lib/visugeod/mapfile_metro.map',
    // tests localhost avec Mapserver 5.2:
    //wfsUrl:'http://localhost/cgi-bin/mapserver/mapserv?MAP=maps/geodesie_fxx.map',
    // tests locahost avec Geoserver 2.0.2:
    //wfsUrl:'http://localhost:8080/geoserver2/wfs',
    wxsSrs:'EPSG:4326'
  },
  'martinique':{
    territory:'MTQ',
    projection:'IGNF:GEOPORTALANF',
    allowedDisplayProjections:['IGNF:UTM20W84MART', 'IGNF:WGS84RRAFGEO'],
    minZoomLevel:9,
    maxZoomLevel:15,
    restrictedExtent:[-61.25,14.30,-60.75,14.95],
    center:[-60.50, 14.67],
    zoom:9,
    // allow different layers/territory :
    layers: [
    {
      name:"Réseau GNSS Permanent",
      params:{
        layers:'rgp'
      },
      options:{
        minZoomLevel:9,
        maxZoomLevel:15,
        opacity:1.0
      }
    },
    {
      name:"Sites de détail",
      params:{
        layers:'sit_rdf'
      },
      options:{
        minZoomLevel:9,
        maxZoomLevel:15,
        opacity:1.0
      }
    },
    {
      name:"Sites de base",
      params:{
        layers:'sit_rbf'
      },
      options:{
        minZoomLevel:9,
        maxZoomLevel:15,
        opacity:1.0
      }
    },
    {
      name:"Repères de Nivellement",
      params:{
        layers:'rn'
      },
      options:{
        minZoomLevel:11,
        maxZoomLevel:15,
        opacity:1.0
      }
    }
    ],
    wxsUrl:'http://'+getServiceBaseUrl()+'/cgi-bin/mapserv?map=/var/webapp/lib/visugeod/mapfile_martinique.map',
    wxsSrs:'EPSG:4326'
  },
  'guadeloupe':{
    territory:'GLP',
    projection:'IGNF:GEOPORTALANF',
    allowedDisplayProjections:['IGNF:UTM20W84GUAD', 'IGNF:WGS84RRAFGEO'],
    minZoomLevel:8,
    maxZoomLevel:15,
    restrictedExtent:[-61.93,15.6,-60.75,16.6],
    center:[-61.24, 16.05],
    zoom:8,
    // allow different layers/territory :
    layers: [
    {
      name:"Réseau GNSS Permanent",
      params:{
        layers:'rgp'
      },
      options:{
        minZoomLevel:8,
        maxZoomLevel:15,
        opacity:1.0
      }
    },

    {
      name:"Sites de détail",
      params:{
        layers:'sit_rdf'
      },
      options:{
        minZoomLevel:8,
        maxZoomLevel:15,
        opacity:1.0
      }
    },
    {
      name:"Sites de base",
      params:{
        layers:'sit_rbf'
      },
      options:{
        minZoomLevel:8,
        maxZoomLevel:15,
        opacity:1.0
      }
    },
    {
      name:"Repères de Nivellement",
      params:{
        layers:'rn'
      },
      options:{
        minZoomLevel:11,
        maxZoomLevel:15,
        opacity:1.0
      }
    }
    ],
    wxsUrl:'http://'+getServiceBaseUrl()+'/cgi-bin/mapserv?map=/var/webapp/lib/visugeod/mapfile_guadeloupe.map',
    wxsSrs:'EPSG:4326'
  },
  'reunion':{
    territory:'REU',
    projection:'IGNF:GEOPORTALREU',
    allowedDisplayProjections:['IGNF:RGR92UTM40S', 'IGNF:RGR92GEO'],
    minZoomLevel:9,
    maxZoomLevel:15,
    restrictedExtent:[55,-21.5,56,-20.8],
    center:[55.53, -21.13],
    zoom:9,
    // allow different layers/territory :
    layers: [
    {
      name:"Réseau GNSS Permanent",
      params:{
        layers:'rgp'
      },
      options:{
        minZoomLevel:9,
        maxZoomLevel:15,
        opacity:1.0
      }
    },
    {
      name:"Sites de détail",
      params:{
        layers:'sit_rdf'
      },
      options:{
        minZoomLevel:9,
        maxZoomLevel:15,
        opacity:1.0
      }
    },
    {
      name:"Sites de base",
      params:{
        layers:'sit_rbf'
      },
      options:{
        minZoomLevel:9,
        maxZoomLevel:15,
        opacity:1.0
      }
    },
    {
      name:"Repères de Nivellement",
      params:{
        layers:'rn'
      },
      options:{
        minZoomLevel:11,
        maxZoomLevel:15,
        opacity:1.0
      }
    }
    ],
    wxsUrl:'http://'+getServiceBaseUrl()+'/cgi-bin/mapserv?map=/var/webapp/lib/visugeod/mapfile_reunion.map',
    wxsSrs:'EPSG:4326'
  },
  'guyane':{
    territory:'GUF',
    projection:'IGNF:GEOPORTALGUF',
    allowedDisplayProjections:['IGNF:UTM22RGFG95', 'IGNF:RGFG95GEO'],
    minZoomLevel:7,
    maxZoomLevel:15,
    restrictedExtent:[-54.633333333 ,2.066666667 ,-51.566666667 ,5.833333333],
    center:[-53.1, 4.68],
    zoom:7,
    // allow different layers/territory :
    layers: [
    {
      name:"Réseau GNSS Permanent",
      params:{
        layers:'rgp'
      },
      options:{
        minZoomLevel:7,
        maxZoomLevel:15,
        opacity:1.0
      }
    },
    {
      name:"Sites de détail",
      params:{
        layers:'sit_rdf'
      },
      options:{
        minZoomLevel:8,
        maxZoomLevel:15,
        opacity:1.0
      }
    },
    {
      name:"Sites de base",
      params:{
        layers:'sit_rbf'
      },
      options:{
        minZoomLevel:8,
        maxZoomLevel:15,
        opacity:1.0
      }
    },
    {
      name:"Repères de Nivellement",
      params:{
        layers:'rn'
      },
      options:{
        minZoomLevel:11,
        maxZoomLevel:15,
        opacity:1.0
      }
    }
    ],
    wxsUrl:'http://'+getServiceBaseUrl()+'/cgi-bin/mapserv?map=/var/webapp/lib/visugeod/mapfile_guyane.map',
    wxsSrs:'EPSG:4326'
  },
  'mayotte':{
    territory:'MYT',
    projection:'IGNF:GEOPORTALMYT',
    allowedDisplayProjections:['IGNF:RGM04UTM38S', 'IGNF:RGM04GEO'],
    minZoomLevel:9,
    maxZoomLevel:15,
    restrictedExtent:[44.8 ,-13.24 , 45.6, -12.44],
    center:[45.16, -12.8],
    zoom:9,
    // allow different layers/territory :
    layers: [
    //FIXME
    //            {
    //                name:"Réseau GNSS Permanent",
    //                params:{
    //                    layers:'rgp'
    //                },
    //                options:{
    //                    minZoomLevel:9,
    //                    maxZoomLevel:15,
    //                    opacity:1.0
    //                }
    //            },
    {
      name:"Sites de détail",
      params:{
        layers:'sit_rdf'
      },
      options:{
        minZoomLevel:9,
        maxZoomLevel:15,
        opacity:1.0
      }
    },
    {
      name:"Sites de base",
      params:{
        layers:'sit_rbf'
      },
      options:{
        minZoomLevel:9,
        maxZoomLevel:15,
        opacity:1.0
      }
    },
    {
      name:"Repères de Nivellement",
      params:{
        layers:'rn'
      },
      options:{
        minZoomLevel:11,
        maxZoomLevel:15,
        opacity:1.0
      }
    }
    ],
    wxsUrl:'http://'+getServiceBaseUrl()+'/cgi-bin/mapserv?map=/var/webapp/lib/visugeod/mapfile_mayotte.map',
    wxsSrs:'EPSG:4326'
  },
  'pierre':{
    territory:'SPM',
    projection:'IGNF:GEOPORTALSPM',
    allowedDisplayProjections:['IGNF:RGSPM06U21', 'IGNF:RGSPM06GEO'],
    minZoomLevel:9,
    maxZoomLevel:15,
    restrictedExtent:[-56.83,46.42,-55.78,47.47],
    center:[-56.205, 46.945],
    zoom:9,
    // allow different layers/territory :
    layers: [
    //FIXME
    //            {
    //                name:"Réseau GNSS Permanent",
    //                params:{
    //                    layers:'rgp'
    //                },
    //                options:{
    //                    minZoomLevel:9,
    //                    maxZoomLevel:15,
    //                    opacity:1.0
    //                }
    //            },
    {
      name:"Sites de détail",
      params:{
        layers:'sit_rdf'
      },
      options:{
        minZoomLevel:9,
        maxZoomLevel:15,
        opacity:1.0
      }
    },
    {
      name:"Sites de base",
      params:{
        layers:'sit_rbf'
      },
      options:{
        minZoomLevel:9,
        maxZoomLevel:15,
        opacity:1.0
      }
    },
    //FIXME
    {
      name:"Repères de Nivellement",
      params:{
        layers:'rn'
      },
      options:{
        minZoomLevel:9,
        maxZoomLevel:15,
        opacity:1.0
      }
    }
    ],
    wxsUrl:'http://'+getServiceBaseUrl()+'/cgi-bin/mapserv?map=/var/webapp/lib/visugeod/mapfile_pierre.map',
    wxsSrs:'EPSG:4326'
  },
  'bart':{
    territory:'SBA',
    projection:'IGNF:GEOPORTALANF',
    allowedDisplayProjections:['IGNF:UTM20W84GUAD', 'IGNF:WGS84RRAFGEO'],
    minZoomLevel:12,
    maxZoomLevel:15,
    restrictedExtent:[-63,17.75,-62.7,17.99],
    center:[-62.83, 17.90],
    zoom:12,
    // allow different layers/territory :
    layers: [
    //FIXME
    //            {
    //                name:"Réseau GNSS Permanent",
    //                params:{
    //                    layers:'rgp'
    //                },
    //                options:{
    //                    minZoomLevel:12,
    //                    maxZoomLevel:15,
    //                    opacity:1.0
    //                }
    //            },
    {
      name:"Sites de détail",
      params:{
        layers:'sit_rdf'
      },
      options:{
        minZoomLevel:12,
        maxZoomLevel:15,
        opacity:1.0
      }
    },
    {
      name:"Sites de base",
      params:{
        layers:'sit_rbf'
      },
      options:{
        minZoomLevel:12,
        maxZoomLevel:15,
        opacity:1.0
      }
    },
    {
      name:"Repères de Nivellement",
      params:{
        layers:'rn'
      },
      options:{
        minZoomLevel:12,
        maxZoomLevel:15,
        opacity:1.0
      }
    }
    ],
    wxsUrl:'http://'+getServiceBaseUrl()+'/cgi-bin/mapserv?map=/var/webapp/lib/visugeod/mapfile_bart.map',
    wxsSrs:'EPSG:4326'
  },
  'martin':{
    territory:'SMA',
    projection:'IGNF:GEOPORTALANF',
    allowedDisplayProjections:['IGNF:UTM20W84GUAD', 'IGNF:WGS84RRAFGEO'],
    minZoomLevel:11,
    maxZoomLevel:15,
    restrictedExtent:[-63.19, 17.87, -62.9, 18.18],
    center:[-63.07, 18.07],
    zoom:11,
    // allow different layers/territory :
    layers: [
    //FIXME
    //            {
    //                name:"Réseau GNSS Permanent",
    //                params:{
    //                    layers:'rgp'
    //                },
    //                options:{
    //                    minZoomLevel:11,
    //                    maxZoomLevel:15,
    //                    opacity:1.0
    //                }
    //            },
    {
      name:"Sites de détail",
      params:{
        layers:'sit_rdf'
      },
      options:{
        minZoomLevel:11,
        maxZoomLevel:15,
        opacity:1.0
      }
    },
    {
      name:"Sites de base",
      params:{
        layers:'sit_rbf'
      },
      options:{
        minZoomLevel:11,
        maxZoomLevel:15,
        opacity:1.0
      }
    },
    {
      name:"Repères de Nivellement",
      params:{
        layers:'rn'
      },
      options:{
        minZoomLevel:11,
        maxZoomLevel:15,
        opacity:1.0
      }
    }
    ],
    wxsUrl:'http://'+getServiceBaseUrl()+'/cgi-bin/mapserv?map=/var/webapp/lib/visugeod/mapfile_martin.map',
    wxsSrs:'EPSG:4326'
  },
  'kerg':{
    territory:'KER',
    projection:'IGNF:GEOPORTALKER',
    allowedDisplayProjections:['IGNF:UTM42SW84', 'IGNF:WGS84G'],
    minZoomLevel:9,
    maxZoomLevel:13,
    restrictedExtent:[68.63,-49.76,70.67,-48.6],
    center:[70.80, -49.38],
    zoom:9,
    // allow different layers/territory :
    layers: [
    //FIXME
    //            {
    //                name:"Réseau GNSS Permanent",
    //                params:{
    //                    layers:'rgp'
    //                },
    //                options:{
    //                    minZoomLevel:9,
    //                    maxZoomLevel:13,
    //                    opacity:1.0
    //                }
    //            },
    {
      name:"Sites de détail",
      params:{
        layers:'sit_rdf'
      },
      options:{
        minZoomLevel:9,
        maxZoomLevel:13,
        opacity:1.0
      }
    },
    {
      name:"Sites de base",
      params:{
        layers:'sit_rbf'
      },
      options:{
        minZoomLevel:9,
        maxZoomLevel:13,
        opacity:1.0
      }
    //            },
    //FIXME
    //            {
    //                name:"Repères de Nivellement",
    //                params:{
    //                    layers:'rn'
    //                },
    //                options:{
    //                    minZoomLevel:9,
    //                    maxZoomLevel:13,
    //                    opacity:1.0
    //                }
    }
    ],
    wxsUrl:'http://'+getServiceBaseUrl()+'/cgi-bin/mapserv?map=/var/webapp/lib/visugeod/mapfile_kerg.map',
    wxsSrs:'EPSG:4326'
  },
  'adelie':{
    territory:'ATF',
    projection:'IGNF:TERA50STEREO',
    allowedDisplayProjections:['IGNF:WGS84G'],
    minZoomLevel:10,
    maxZoomLevel:17,
    restrictedExtent:[139.55, -66.85,140.45, -66.49],
    // restrictedExtent:[139.84, -66.72,140.07, -66.63],
    center:[139.95861111, -66.67666666],
    zoom:10,
    // allow different layers/territory :
    layers: [
    //FIXME
    //            {
    //                name:"Réseau GNSS Permanent",
    //                params:{
    //                    layers:'rgp'
    //                },
    //                options:{
    //                    minZoomLevel:4,
    //                    maxZoomLevel:4,
    //                    opacity:1.0
    //                }
    //            },
    {
      name:"Sites de détail",
      params:{
        layers:'sit_rdf'
      },
      options:{
        minZoomLevel:10,
        maxZoomLevel:17,
        opacity:1.0
      }
    },
    {
      name:"Sites de base",
      params:{
        layers:'sit_rbf'
      },
      options:{
        minZoomLevel:10,
        maxZoomLevel:17,
        opacity:1.0
      }
    },
    {
      name:"Repères de Nivellement",
      params:{
        layers:'rn'
      },
      options:{
        minZoomLevel:12,
        maxZoomLevel:17,
        opacity:1.0
      }
    }
    ],
    wxsUrl:'http://'+getServiceBaseUrl()+'/cgi-bin/mapserv?map=/var/webapp/lib/visugeod/mapfile_adelie.map',
    wxsSrs:'EPSG:4326'
  },
  'amster':{
    territory:'ASP',
    projection:'IGNF:GEOPORTALASP',
    allowedDisplayProjections:['IGNF:UTM43SW84', 'IGNF:WGS84G'],
    minZoomLevel:11,
    maxZoomLevel:15,
    restrictedExtent:[77.49, -37.88, 77.6, -37.79],
    //restrictedExtent:[79.45, -40.77, 75.63, -35.75],
    center:[77.53, -37.83],
    zoom:12,
    // allow different layers/territory :
    layers: [
    //FIXME
    //            {
    //                name:"Réseau GNSS Permanent",
    //                params:{
    //                    layers:'rgp'
    //                },
    //                options:{
    //                    minZoomLevel:4,
    //                    maxZoomLevel:4,
    //                    opacity:1.0
    //                }
    //            },
    {
      name:"Sites de détail",
      params:{
        layers:'sit_rdf'
      },
      options:{
        minZoomLevel:11,
        maxZoomLevel:15,
        opacity:1.0
      }
    },
    {
      name:"Sites de base",
      params:{
        layers:'sit_rbf'
      },
      options:{
        minZoomLevel:11,
        maxZoomLevel:15,
        opacity:1.0
      }
    //            },
    //            {
    //                name:"Repères de Nivellement",
    //                params:{
    //                    layers:'rn'
    //                },
    //                options:{
    //                    minZoomLevel:4,
    //                    maxZoomLevel:4,
    //                    opacity:1.0
    //                }
    }
    ],
    wxsUrl:'http://'+getServiceBaseUrl()+'/cgi-bin/mapserv?map=/var/webapp/lib/visugeod/mapfile_amster.map',
    wxsSrs:'EPSG:4326'
  },
  'paul':{
    territory:'ASP',
    projection:'IGNF:GEOPORTALASP',
    allowedDisplayProjections:['IGNF:UTM43SW84', 'IGNF:WGS84G'],
    minZoomLevel:13,
    maxZoomLevel:15,
    restrictedExtent:[77.5, -38.74, 77.557, -38.697],
    center:[77.53, -38.72],
    zoom:13,
    // allow different layers/territory :
    layers: [
    //FIXME
    //            {
    //                name:"Réseau GNSS Permanent",
    //                params:{
    //                    layers:'rgp'
    //                },
    //                options:{
    //                    minZoomLevel:4,
    //                    maxZoomLevel:4,
    //                    opacity:1.0
    //                }
    //            },
    {
      name:"Sites de détail",
      params:{
        layers:'sit_rdf'
      },
      options:{
        minZoomLevel:13,
        maxZoomLevel:15,
        opacity:1.0
      }
    },
    {
      name:"Sites de base",
      params:{
        layers:'sit_rbf'
      },
      options:{
        minZoomLevel:13,
        maxZoomLevel:15,
        opacity:1.0
      }
    //            },
    //FIXME
    //            {
    //                name:"Repères de Nivellement",
    //                params:{
    //                    layers:'rn'
    //                },
    //                options:{
    //                    minZoomLevel:4,
    //                    maxZoomLevel:4,
    //                    opacity:1.0
    //                }
    }
    ],
    wxsUrl:'http://'+getServiceBaseUrl()+'/cgi-bin/mapserv?map=/var/webapp/lib/visugeod/mapfile_paul.map',
    wxsSrs:'EPSG:4326'
  },
  'crozet':{
    territory:'CRZ',
    projection:'IGNF:GEOPORTALCRZ',
    allowedDisplayProjections:['IGNF:UTM39SW84', 'IGNF:WGS84G'],
    minZoomLevel:9,
    maxZoomLevel:12,
    restrictedExtent:[51.50,-46.75,52.50,-46.25],
    center:[52.00, -46.50],
    zoom:9,
    // allow different layers/territory :
    layers: [
    //FIXME
    //            {
    //                name:"Réseau GNSS Permanent",
    //                params:{
    //                    layers:'rgp'
    //                },
    //                options:{
    //                    minZoomLevel:9,
    //                    maxZoomLevel:12,
    //                    opacity:1.0
    //                }
    //            },
    {
      name:"Sites de détail",
      params:{
        layers:'sit_rdf'
      },
      options:{
        minZoomLevel:9,
        maxZoomLevel:12,
        opacity:1.0
      }
    },
    {
      name:"Sites de base",
      params:{
        layers:'sit_rbf'
      },
      options:{
        minZoomLevel:9,
        maxZoomLevel:12,
        opacity:1.0
      }
    //            },
    //FIXME
    //            {
    //                name:"Repères de Nivellement",
    //                params:{
    //                    layers:'rn'
    //                },
    //                options:{
    //                    minZoomLevel:9,
    //                    maxZoomLevel:12,
    //                    opacity:1.0
    //                }
    }
    ],
    wxsUrl:'http://'+getServiceBaseUrl()+'/cgi-bin/mapserv?map=/var/webapp/lib/visugeod/mapfile_crozet.map',
    wxsSrs:'EPSG:4326'
  },
  'europa':{
    territory:'REU',
    projection:'IGNF:GEOPORTALREU',
    allowedDisplayProjections:['IGNF:UTM37SW84', 'IGNF:WGS84G'],
    minZoomLevel:4,
    maxZoomLevel:4,
    restrictedExtent:[40.2,-22.5,40.55,-22.3],
    center:[40.42, -22.42],
    zoom:4,
    // allow different layers/territory :
    layers: [
    //FIXME
    //            {
    //                name:"Réseau GNSS Permanent",
    //                params:{
    //                    layers:'rgp'
    //                },
    //                options:{
    //                    minZoomLevel:4,
    //                    maxZoomLevel:4,
    //                    opacity:1.0
    //                }
    //            },
    {
      name:"Sites de détail",
      params:{
        layers:'sit_rdf'
      },
      options:{
        minZoomLevel:4,
        maxZoomLevel:4,
        opacity:1.0
      }
    },
    {
      name:"Sites de base",
      params:{
        layers:'sit_rbf'
      },
      options:{
        minZoomLevel:4,
        maxZoomLevel:4,
        opacity:1.0
      }
    //            },
    //
    //            {
    //                name:"Repères de Nivellement",
    //                params:{
    //                    layers:'rn'
    //                },
    //                options:{
    //                    minZoomLevel:4,
    //                    maxZoomLevel:4,
    //                    opacity:1.0
    //                }
    }
    ],
    wxsUrl:'http://'+getServiceBaseUrl()+'/cgi-bin/mapserv?map=/var/webapp/lib/visugeod/mapfile_europa.map',
    wxsSrs:'EPSG:4326'
  }
};

// ==========================================================================================================
// Configuration des couches :
// ==========================================================================================================
var LAYER_NAMES= {
  'rgp':{
    themes:{
      'ALL_THEMES':true,
      'REP_THEME' :false,
      'SIT_THEME' :true
    },
    'WFS_QUERY' :false
  },
  'sit_rbf':{
    themes:{
      'ALL_THEMES':true,
      'REP_THEME' :false,
      'SIT_THEME' :true
    },
    'WFS_QUERY' :true
  },
  'sit_rdf':{
    themes:{
      'ALL_THEMES':true,
      'REP_THEME' :false,
      'SIT_THEME' :true
    },
    'WFS_QUERY' :true
  },
  'triplet':{
    themes:{
      'ALL_THEMES':true,
      'REP_THEME' :true,
      'SIT_THEME' :false
    },
    'WFS_QUERY' :false
  },
  'rn':{
    themes:{
      'ALL_THEMES':true,
      'REP_THEME' :true,
      'SIT_THEME' :false
    },
    'WFS_QUERY' :true
  },
  'limite_carte':{
    themes:{
      'ALL_THEMES':false,
      'REP_THEME' :false,
      'SIT_THEME' :false
    },
    'WFS_QUERY' :false
  }
};

// ==========================================================================================================
// Constantes :
// ==========================================================================================================
var gkMAP_MIN_WIDTH= 620;
var gkMAP_MAX_WIDTH= 820;
var gkMAP_MIN_HEIGHT= 620;
var gkMAP_MAX_HEIGHT= 620;
// Change it if necessary :
var gkPROXYURL="http://localhost/~aw/API-JAVASCRIPT/trunk/src/main/webapp/proxy/perl/proxy.pl?url=";

// ==========================================================================================================
var viewer= null;//the viewer instance

/**
 * Function: getGeodesyTerritory
 * Get territory name from Geoportal's territory code.
 */
function getGeodesyTerritory(t) {
  if (!t) {
    t= 'FXX';
  }
  for (var ti in TERRITORIES_INFO) {
    if (TERRITORIES_INFO[ti].territory===t) {
      return ti;
    }
  }
  return 'france';
}

/**
 * Function: getProxyUrl
 * Return the proxy Url when needed.
 *
 * Returns:
 * {String} the proxy url (ending with '?url=').
 */
function getProxyUrl() {
  if (document.location.hostname!='geodesie.ign.fr' &&
    document.location.hostname!='sgn.ign.fr') {//FIXME
    return gkPROXYURL;
  }
  return null;//No need for proxy
}

/**
 * Function: getBaseUrl
 * Compute the base url without the page and parameters.
 *
 * Returns:
 * {String} the base URL terminated with '/'.
 */
function getBaseUrl() {
  var base= document.location.pathname.split('?')[0];
  var parts= base.split('/');
  base= parts.pop();
  base= parts.join('/');
  var baseUrl=
  document.location.protocol+'//'+
  document.location.hostname+
  (document.location.port? ':'+document.location.port : '')+
  base+'/';
  return baseUrl;
}

/**
 * Function: getServiceBaseUrl
 * Compute the base url for WMSes, PDF printers, etc ...
 *
 * Returns:
 * {String} either 'geodesie.ign.fr' or 'sgn.ign.fr'
 */
function getServiceBaseUrl() {
    
  if (document.location.hostname == 'sgn.ign.fr' ||document.location.hostname == 'localhost'  ) {
    return document.location.hostname;
  }
  return 'geodesie.ign.fr';
}

/**
 * Function processParameters
 * Compute default/actual parameters
 *
 * Returns:
 * {Object} actual compiled arguments that contain the following fields :
 *      * Args - {Array({Object})} raw actual arguments;
 *      * nbArgs - {Integer} number of raw actual arguments;
 *      * T - {Object} the current territory configuration;
 *      * center - {Array({Float}) map's center in lon/lat;
 *      * zoom - {Integer} zoom level;
 *      * minMapSize - {Boolean} true if small map, false otherwise;
 *      * theme - {String} theme to apply;
 *      * layersViz - {Object} list of layers and their visibility
 */
function processParameters() {
  var Args= OpenLayers.Util.getParameters();
  var nbArgs= 0;
  var T= TERRITORIES_INFO['france'];
  var center= T.center.slice(0);
  var zoom= T.zoom;
  var minMapSize= true;
  var theme= 'ALL_THEMES';
  var layersViz= {};
  for (kArg in Args) if (Args.hasOwnProperty(kArg)) {
    nbArgs++;
  }
  if (nbArgs>0) {
    if (typeof(Args['t'])!='undefined') {
      T= TERRITORIES_INFO[Args['t']];
    }
    if (typeof(T)=='undefined') {
      T= TERRITORIES_INFO['france'];
    }
    center= T.center.slice(0);
    zoom= T.zoom;
    if (typeof(Args['c'])!='undefined' && Args['c'].length==2) {
      center[0]= parseFloat(Args['c'][0]);
      center[1]= parseFloat(Args['c'][1]);
      var bb= OpenLayers.Bounds.fromArray(T.restrictedExtent);
      if (!bb.containsLonLat({
        lon:center[0],
        lat:center[1]
        })) {
        // out of bbox !
        center= T.center.slice(0);
      }
    }
    if (typeof(Args['z'])!='undefined') {
      zoom= parseInt(Args['z']);
      if (!(T.minZoomLevel<=zoom && zoom<=T.maxZoomLevel)) {
        zoom= T.zoom;
      }
    }
    if (typeof(Args['s'])!='undefined') {
      minMapSize= Args['s']=='1';
    }
    if (typeof(Args['m'])!='undefined') {
      theme= Args['m'];
    }
    if (typeof(LAYER_NAMES['rgp'].themes[theme])=='undefined') {
      theme= 'ALL_THEMES';
    }
    if (typeof(Args['l'])!='undefined') {
      if (!(Args['l'] instanceof Array)) {
        Args['l']= [ Args['l'] ];
      }
      for (var i= 0, l= Args['l'].length; i<l; i++) {
        var lv= Args['l'][i].split('$');
        layersViz[lv[0]]= (lv[1]==='0'? false:true);
      }
    }
  }
  return {
    'Args': Args,
    'nbArgs':nbArgs,
    'territories':T,
    'center':center,
    'zoom':zoom,
    'isSmallMap':minMapSize,
    'theme':theme,
    'layersVisibility':layersViz
  };
}

