/**
 * Copyright (c) 2008-2010 Institut Geographique National France, released
 * under the BSD license.
 */

// PROJ4JS:
Proj4js.defs['IGNF:UTM37SW84']= "+title=World Geodetic System 1984 UTM fuseau 37 Sud +proj=tmerc +towgs84=0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.000000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=39.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=10000000.000 +units=m +no_defs";

OpenLayers.Control.MouseWheel= OpenLayers.Class(OpenLayers.Control, {
  /**
   * APIProperty: handleRightClicks
   * {Boolean} Whether or not to handle right clicks. Default is false.
   */
  handleRightClicks: false,

  /**
   * Constructor: OpenLayers.Control.MouseWheel
   * Create a new mouse wheel control
   *
   * Parameters:
   * options - {Object} An optional object whose properties will be set on
   *                    the control
   */
  initialize: function(options) {
    this.handlers = {};
    OpenLayers.Control.prototype.initialize.apply(this, arguments);
  },

  /**
   * Method: destroy
   * The destroy method is used to perform any clean up before the control
   * is dereferenced.  Typically this is where event listeners are removed
   * to prevent memory leaks.
   */
  destroy: function() {
    this.deactivate();
    OpenLayers.Control.prototype.destroy.apply(this,arguments);
  },

  /**
   * Method: activate
   */
  activate: function() {
    this.handlers.wheel.activate();
    this.handlers.click.activate();
    return OpenLayers.Control.prototype.activate.apply(this,arguments);
  },

  /**
   * Method: deactivate
   */
  deactivate: function() {
    this.handlers.click.deactivate();
    this.handlers.wheel.deactivate();
    return OpenLayers.Control.prototype.deactivate.apply(this,arguments);
  },

  /**
   * Method: draw
   */
  draw: function() {
    // disable right mouse context menu for support of right click events
    if (this.handleRightClicks) {
      this.map.viewPortDiv.oncontextmenu= function () {
        return false;
      };
    }

    var clickCallbacks= {};
    var clickOptions= {
      'double': false,
      'stopDouble': false
    };
    this.handlers.click= new OpenLayers.Handler.Click(
      this, clickCallbacks, clickOptions
      );
    this.handlers.wheel= new OpenLayers.Handler.MouseWheel(
      this, {
        "up"  : this.wheelUp,
        "down": this.wheelDown
      });
    this.activate();
  },

  /**
   * Method: wheelChange
   *
   * Parameters:
   * evt - {Event}
   * deltaZ - {Integer}
   */
  wheelChange: function(evt, deltaZ) {
    var newZoom= this.map.getZoom() + deltaZ;
    if (!this.map.isValidZoomLevel(newZoom)) {
      return;
    }
    var size= this.map.getSize();
    var deltaX= size.w/2 - evt.xy.x;
    var deltaY= evt.xy.y - size.h/2;
    var newRes= this.map.baseLayer.getResolutionForZoom(newZoom);
    var zoomPoint= this.map.getLonLatFromPixel(evt.xy);
    var newCenter= new OpenLayers.LonLat(
      zoomPoint.lon + deltaX * newRes,
      zoomPoint.lat + deltaY * newRes );
    this.map.setCenter( newCenter, newZoom );

    var SelectId = document.getElementById('echelle_selectionnable');
    if(newZoom<=this.map.baseLayer.maxZoomLevel && newZoom>=this.map.baseLayer.minZoomLevel)
    {
      SelectId.selectedIndex = newZoom-this.map.baseLayer.minZoomLevel;
    }

  },

  /**
   * Method: wheelUp
   * User spun scroll wheel up
   *
   * Parameters:
   * evt - {Event}
   */
  wheelUp: function(evt) {
    this.wheelChange(evt, 1);
  },

  /**
   * Method: wheelDown
   * User spun scroll wheel down
   *
   * Parameters:
   * evt - {Event}
   */
  wheelDown: function(evt) {
    this.wheelChange(evt, -1);
  },

  /**
   * Method: disableZoomWheel
   */
  disableZoomWheel: function() {
    this.zoomWheelEnabled= false;
    this.handlers.wheel.deactivate();
  },

  /**
   * Method: enableZoomWheel
   */
  enableZoomWheel: function() {
    this.zoomWheelEnabled= true;
    if (this.active) {
      this.handlers.wheel.activate();
    }
  },

  CLASS_NAME: "OpenLayers.Control.MouseWheel"
});

/**
 * method pour controler les layers visibles pour les info-bulle
 */
OpenLayers.Control.WMSGetFeatureInfo.prototype.layerQueryable=
  function(layer) {
    if (!layer.getVisibility()) {
      return false;
    }
    if (!layer.calculateInRange()) {
      return false;
    }
    if (layer.queryable===false) {
      return false;
    }
    if(layer.name == 'Emprise de triplet') {
      return false;
    }
    if(layer.name == 'Limite des cartes (1/50000)') {
      return false;
    }
    return true;
  };


// Choix echelles
Geoportal.Control.ChangeScale= OpenLayers.Class(Geoportal.Control, {
  /**
   * Property: zoomScalesMap
   * Mapping between analogic scales and zooms
   */
  zoomScalesMap:{
    '1/9783938':4,
    '1/8192000':5,
    '1/4096000':6,
    '1/2048000':7,
    '1/1024000':8,
    '1/512000':9,
    '1/256000':10,
    '1/128000':11,
    '1/64000':12,
    '1/32000':13,
    '1/16000':14,
    '1/8000':15,
    '1/4000':16,
    '1/2000':17,
    '1/1000':18
  },
  /**
   * APIMethod: destroy
   * Destroy this control
   */
  destroy:function() {
    this.div.innerHTML= '';
    Geoportal.Control.prototype.destroy.apply(this, arguments);
  },
  /**
   * APIMethod: draw
   * The draw method is called when the control is ready to be displayed
   * on the page.  If a div has not been created one is created.  Controls
   * with a visual component will almost always want to override this method
   * to customize the look of control.
   *
   * Parameters:
   * px - {<OpenLayers.Pixel>} The top-left pixel position of the control
   *      or null.
   *
   * Returns:
   * {DOMElement} A reference to the DIV DOMElement containing the control
   */
  draw:function(px) {
    this.div= Geoportal.Control.prototype.draw.apply(this, arguments);
    var s=
    '<h2>Echelles</h2>' +
    '<div class="editoBox editoBox2">' +
    '<center>' +
    '<form name="frm_echelle" id="frm_echelle" action="javascript:void(0);">' +
    '<select id="echelle_selectionnable" name="echelle_selectionnable" style="width:100%;">';
    var selectionne = 'selected="selected"';
    for (var ech in this.zoomScalesMap)
    {
      if(this.zoomScalesMap[ech]>=this.map.baseLayer.minZoomLevel && this.zoomScalesMap[ech]<=this.map.baseLayer.maxZoomLevel)
      {
        s+='<option value="'+ech+'" '+selectionne+'>&nbsp;&nbsp;'+ech+'</option>';
        selectionne = '';
      }
    }
    s+=
    '</select>' +
    '</form>' +
    '</center>' +
    '</div>';
    this.div.innerHTML= s;
    var selectScales= OpenLayers.Util.getElement('echelle_selectionnable');
    var context= {
      'selectScales':selectScales,
      'control':this
    };//change à la place de mouseup. modif Mathieu 16/07/2010
    OpenLayers.Event.observe(selectScales, "change",
      OpenLayers.Function.bindAsEventListener(this.onScaleChange, context)
      );

    return this.div;
  },
  /**
   * APIMethod: onScaleChange
   * Callback when an analogic scale has been chosen
   *
   * Parameters:
   * evt - {Event}
   */
  onScaleChange:function(evt) {//changement d'echelle
    var zoom= this.control.zoomScalesMap[this.selectScales.options[this.selectScales.selectedIndex].value];
    if (typeof(zoom)==='undefined') {
      zoom= 5;
    }
    if (zoom<this.control.map.baseLayer.minZoomLevel) {
      zoom= this.control.map.baseLayer.minZoomLevel;
    }
    if (zoom>this.control.map.baseLayer.maxZoomLevel) {
      zoom= this.control.map.baseLayer.maxZoomLevel;
    }
    this.control.map.zoomTo(zoom);
    this.selectScales.selectedIndex= zoom-this.control.map.baseLayer.minZoomLevel;
    this.selectScales.blur();
  },
  CLASS_NAME: 'Geoportal.Control.ChangeScale'
});

// Legende
Geoportal.Control.Legend= OpenLayers.Class(Geoportal.Control, {
  /**
   * APIProperty: overElement
   * {DOMElement} element that control the hovering.
   */
  overElement:null,
  initialize: function(e, o) {
    Geoportal.Control.prototype.initialize.apply(this,[o]);
    this.overElement= e;
  },
  activate: function() {
    Geoportal.Control.prototype.activate.apply(this,arguments);
    OpenLayers.Event.observe(this.div,'mouseover',OpenLayers.Function.bindAsEventListener(this.mouseover,this));
    OpenLayers.Event.observe(this.div,'mouseout',OpenLayers.Function.bindAsEventListener(this.mouseout,this));
  },
  deactivate: function() {
    OpenLayers.Event.stopObservingElement(this.div);
    Geoportal.Control.prototype.deactivate.apply(this,arguments);
  },
  mouseover: function(e) {
    if (this.overElement) {
      OpenLayers.Element.show(this.overElement);
      this.overElement.style.zIndex= "9999";
    }
  },
  mouseout: function(e) {
    if (this.overElement) {
      OpenLayers.Element.hide(this.overElement);
    }
  },
  destroy: function() {
    this.overElement= null;
    Geoportal.Control.prototype.destroy.apply(this,arguments);
  },
  CLASS_NAME: 'Geoportal.Control.Legend'
});

// Carte initiale
Geoportal.Control.DefaultMap= OpenLayers.Class(Geoportal.Control, {
  /**
   * APIProperty: url
   * {String} the url of the initial page
   * Must be given to the constructor.
   */
  url:null,
  initialize: function(u, o) {
    Geoportal.Control.prototype.initialize.apply(this,[o]);
    this.url= u;
  },
  activate: function() {
    Geoportal.Control.prototype.activate.apply(this,arguments);
    OpenLayers.Event.observe(this.div,'click',OpenLayers.Function.bindAsEventListener(this.click,this));
  },
  deactivate: function() {
    OpenLayers.Event.stopObservingElement(this.div);
    Geoportal.Control.prototype.deactivate.apply(this,arguments);
  },
  click: function(e) {
    if (this.url) {
      var cppCntrl= viewer.getVariable('cppCntrl')
      cppCntrl.activateControl(cppCntrl.defaultControl);
      this.map.zoomTo(1);
      var SelectId = document.getElementById('echelle_selectionnable');
      SelectId.selectedIndex = 0;
    //document.location= this.url; //Modif Mathieu 19/07/2010
    }
  },
  destroy: function() {
    this.url= null;
    Geoportal.Control.prototype.destroy.apply(this,arguments);
  },
  CLASS_NAME: 'Geoportal.Control.DefaultMap'
});

// Changer la taille de la carte
Geoportal.Control.ChangeMapSize= OpenLayers.Class(Geoportal.Control, {
  /**
   * APIProperty: elements
   * {Array({String|DOMElement})} elements controled by this controler.
   * Must be given to the constructor.
   */
  elements:null,
  /**
   * APIProperty: size
   * {<OpenLayers.Size>} the new size of the map.
   * Must be given to the constructor.
   */
  size:null,
  /**
   * APIProperty: visibilityStatus
   * {Boolean} visibility (shown/hidden) of controled elements.
   */
  visibilityStatus: false,
  initialize: function(e, s, o) {
    Geoportal.Control.prototype.initialize.apply(this,[o]);
    this.elements= e || [];
    this.size= s? s.clone() : null;
    for (var i= 0, l= this.elements.length; i<l; i++) {
      var el= this.elements[i];
      if (typeof(el)=='string') {
        this.elements[i]= OpenLayers.Util.getElement(el);
      }
    }
  },
  activate: function() {
    Geoportal.Control.prototype.activate.apply(this,arguments);
    OpenLayers.Event.observe(this.div,'click',OpenLayers.Function.bindAsEventListener(this.onClick,this));
  },
  deactivate: function() {
    OpenLayers.Event.stopObservingElement(this.div);
    Geoportal.Control.prototype.deactivate.apply(this,arguments);
  },
  onClick: function(e) { //click sur boutons extension carte
    var main_top = document.getElementById('mainTop');
    if(on_off_panier && on_off_panier == 'close'){
      for (var i= 0, l= this.elements.length; i<l; i++) {
        var el= this.elements[i];
        if (i==0) {
          if (OpenLayers.Element.visible(el)===this.visibilityStatus) {
            return false;
          }//clic sur bouton déjà sélectionné
        }
        if (this.visibilityStatus===true) {
          OpenLayers.Element.show(el);//reduire la carte
          etat_taille_carte = 'petite';
          main_top.style.width = '625px';
        } else {
          OpenLayers.Element.hide(el);//agrandir la carte
          etat_taille_carte = 'grande';
          main_top.style.width = '825px';
        }
      }
      if (this.size) {
        this.map.viewer.setSize(this.size.w,this.size.h);
      }
    }
  },
  destroy: function() {
    this.elements= null;
    this.size= null;
    Geoportal.Control.prototype.destroy.apply(this,arguments);
  },
  CLASS_NAME: 'Geoportal.Control.ChangeMapSize'
});

// Support des raccourcis :
OpenLayers.Control.Keyboard= OpenLayers.Class(OpenLayers.Control.KeyboardDefaults, {
  /**
   * APIProperty: keys
   * {Object} Map of code of key and keyCode to monitor
   */
  keys:null,
  defaultKeyPress: function(evt) {
    var handled= false;
    for (var key in this.keys) {
      var keyCode= this.keys[key].keyCode;
      if (keyCode==evt.keyCode) {
        this.keys[key].callback.apply(this,[evt]);
        handled= true;
        break;
      }
    }
    if (handled) {
      OpenLayers.Event.stop(evt);
      return;
    }
    /*+*//*-*/
    OpenLayers.Control.KeyboardDefaults.prototype.defaultKeyPress.apply(this,arguments);
    var SelectId = document.getElementById('echelle_selectionnable');
    SelectId.selectedIndex = this.map.getZoom()-this.map.baseLayer.minZoomLevel;
  },
  CLASS_NAME:"OpenLayers.Control.Keyboard"
});

// Affichage des couches:
Geoportal.Control.LayerSwitcherPanel= OpenLayers.Class(Geoportal.Control, {
  /**
             * APIProperty: defaultTheme
             * {String} Default theme for display. Possible values are :
             *      * ALL_THEMES
             *      * REP_THEME
             *      * SIT_THEME
             */
  defaultTheme: 'ALL_THEMES',

  /**
             * Property: currentTheme
             * {String} current theme for display.
             */
  currentTheme: null,

  /**
             * Property: availThemes
             * {Object} Available themes for display.
             *      Defaults to *{ALL_THEMES:0,REP_THEME:0,SIT_THEME:0}*
             */
  availThemes: {
    'ALL_THEMES':1,
    'REP_THEME':1,
    'SIT_THEME':1
  },

  /**
             * Property: layerStates
             * {Array(Object)} Basically a copy of the "state" of the map's layers
             *     the last time the control was drawn. We have this in order to avoid
             *     unnecessarily redrawing the control.
             */
  layerStates: null,

  /**
             * Property: layersLi
             * {DOMElement}
             */
  layersLi: null,

  /**
             * Property: dataLayersUl
             * {DOMElement}
             */
  dataLayersUl: null,

  /**
             * Property: dataLayers
             * {Array(<OpenLayers.Layer>)}
             */
  dataLayers: null,

  /**
             * Constructor: Geoportal.Control.LayerSwitcherPanel
             *
             * Parameters:
             * options - {Object}
             */
  initialize: function(options) {
    Geoportal.Control.prototype.initialize.apply(this, arguments);
    if (!this.defaultTheme || this.availThemes[this.defaultTheme]!==1) {
      this.defaultTheme= 'ALL_THEMES';
    }
    this.currentTheme= this.defaultTheme;
    this.layerStates= [];
    this.showOptions= false;
  },

  /**
             * APIMethod: destroy
             */
  destroy: function() {
    OpenLayers.Event.stopObservingElement(this.div);

    //clear out layers info and unregister their events
    this.clearLayersArray();

    this.map.events.un({
      "addlayer": this.redraw,
      "changelayer": this.redraw,
      scope: this
    });

    this.frmTheme= null;
    this.frmOpts= null;
    this.dataLayersUl= null;
    this.aToggleOptions= null;

    Geoportal.Control.prototype.destroy.apply(this, arguments);
  },

  /**
             * Method: clearLayersArray
             * We then clear all the corresponding listeners, the div, and reinitialize a new array.
             */
  clearLayersArray: function() {
    var layers= this["dataLayers"];
    if (layers) {
      for(var i=0, len=layers.length; i<len ; i++) {
        var layer= layers[i];
        OpenLayers.Event.stopObservingElement(layer.inputElem);
      }
    }
    this["dataLayersUl"].innerHTML = "";
    this["dataLayers"] = [];
  },

  /**
             * Method: setMap
             *
             * Properties:
             * map - {<OpenLayers.Map>}
             */
  setMap: function(map) {
    Geoportal.Control.prototype.setMap.apply(this, arguments);

    this.map.events.on({
      "addlayer": this.redraw,
      "changelayer": this.redraw,
      scope: this
    });
  },

  /**
             * Method: draw
             *
             * Returns:
             * {DOMElement} A reference to the DIV DOMElement containing the
             *     switcher tabs.
             */
  draw: function() {
    Geoportal.Control.prototype.draw.apply(this,arguments);

    // create layout divs
    this.loadContents();

    // populate div with current info
    this.redraw();

    // set mode to minimize
    this.minimizeControl();

    return this.div;
  },

  /**
             * APIMethod: loadContents
             * Set up the control's basic content.
             * DOM elements for the layers are not created here (See redraw()).
             */
  loadContents: function() {
    this.frmThemeId= 'frm_affichage';
    this.frmOptsId= 'frm_option_avancee';
    this.div.innerHTML= '';
    this.div.innerHTML=
    "<h2>Affichage</h2>" +
    "<div class='editoBox editoBox2'>" +
    "<center>" +
    "<form name='"+this.frmThemeId+"' id='"+this.frmThemeId+"' action='javascript:void(0);'>" +
    "<select id='THEMES_SELECTOR' name='THEMES_SELECT' style='width:100%;'>" +
    "<option value='ALL_THEMES'"+(this.defaultTheme=='ALL_THEMES'? "selected='selected'":"")+">Tout</option>" +
    "<option value='REP_THEME'"+(this.defaultTheme=='REP_THEME'? "selected='selected'":"")+">Nivellement</option>" +
    "<option value='SIT_THEME'"+(this.defaultTheme=='SIT_THEME'? "selected='selected'":"")+">Géodésie</option>" +
    "</select>" +
    "</form>" +
    "</center>" +
    "<form name='"+this.frmOptsId+"' id='"+this.frmOptsId+"' action='javascript:void(0);'>" +
    "<ul id='"+this.id+"LSPanel'></ul>" +
    "</form>" +
    "</div>";
    this.dataLayersUl= OpenLayers.Util.getElement(this.id+'LSPanel');
    var selectLayers= OpenLayers.Util.getElement('THEMES_SELECTOR');
    var context= {
      'selectLayers':selectLayers,
      'control':this
    };//change à la place de mouseup. modif Mathieu 16/07/2010
    OpenLayers.Event.observe(selectLayers, "change",
      OpenLayers.Function.bindAsEventListener(this.onThemeChange, context)
      );
    this.frmTheme= OpenLayers.Util.getElement(this.frmThemeId);
    this.frmOpts= OpenLayers.Util.getElement(this.frmOptsId);
  },

  /**
             * Method: checkRedraw
             * Checks if the layer state has changed since the last redraw() call.
             *
             * Returns:
             * {Boolean} The layer state changed since the last redraw() call.
             */
  checkRedraw: function()
  {
    var redraw= false;
    if ( !this.layerStates.length || (this.map.layers.length != this.layerStates.length) )
    {
      redraw= true;
    }
    else
    {
      for (var i=0, len=this.layerStates.length; i<len; i++)
      {
        var layerState= this.layerStates[i];
        var layer= this.map.layers[i];
        if ( (layerState.name != layer.name) ||
          (layerState.inRange != layer.inRange) ||
          (layerState.id != layer.id) ||
          (layerState.visibility != layer.visibility) )
          {
          redraw = true;
          break;
        }
      }
    }
    var SelectId = document.getElementById('echelle_selectionnable');
    if(this.map.getZoom())
    {
      if(SelectId.selectedIndex != this.map.getZoom()-this.map.baseLayer.minZoomLevel)
      {
        SelectId.selectedIndex = this.map.getZoom()-this.map.baseLayer.minZoomLevel;
      }
    }
    return redraw;
  },

  /**
             * APIMethod: redraw
             *  Goes through and takes the current state of the Map and rebuilds the
             *  control to display that state.  Lists each data layer with a checkbox.
             *
             * Returns:
             * {DOMElement} A reference to the DIV DOMElement containing the control
             */
  redraw: function() {
    //if the state hasn't changed since last redraw, no need
    // to do anything. Just return the existing div.
    if (!this.checkRedraw()) {
      return this.div;
    }

    var i, j, l= this.map.layers.length;
    var layer;
    var layers;
    // Save state -- for checking layer if the map state changed.
    // We save this before redrawing, because in the process of redrawing
    // we will trigger more visibility changes, and we want to not redraw
    // and enter an infinite loop. Same for opacity changes.
    this.layerStates= [];
    for (i= 0; i<l; i++) {
      layer= this.map.layers[i];
      this.layerStates[i]= {
        'displayInLayerSwitcher': layer.displayInLayerSwitcher,
        'name': layer.name,
        'visibility': layer.visibility,
        'opacity': layer.opacity,
        'inRange': layer.inRange,
        'id': layer.id
      };
    }

    //clear out previous layers
    this.clearLayersArray();

    layers= this.map.layers.slice();
    var groupUl= this.dataLayersUl;
    for (i= 0; i<l; i++) {
      layer= layers[i];
      var baseLayer= layer.isBaseLayer;
      var layerState= this.layerStates[i];

      // don't want baseLayers, Geoportal's layers ...
      if (layer.displayInLayerSwitcher && !baseLayer && !layer.GeoRM) {
        var layerLi= document.createElement("li");
        layerLi.id= this.id+"_"+layer.id;
        layerLi.style.display= this.showOptions?
        'block'
        :   'none';
        groupUl.appendChild(layerLi);
        /*if(this.map.layers[i].minZoomLevel<=this.map.getZoom()){
              checked= layer.getVisibility();
            }*/
        // check data layers if they are visible
        var checked= layer.getVisibility();
        var inputElem= document.createElement("input");
        inputElem.id= "id_" + layer.params.LAYERS;
        inputElem.name= inputElem.id;
        inputElem.type= "checkbox";
        inputElem.value= layer.params.LAYERS;
        inputElem.checked= checked;
        inputElem.defaultChecked= checked;
        inputElem.style.autocomplete= "off";
        if (!layer.inRange) {
          inputElem.disabled= true;
        }
        else {
          inputElem.disabled= false;
        }
        var context= {
          'inputElem': inputElem,
          'layer': layer,
          'layerSwitcher': this
        };
        OpenLayers.Event.observe(
          inputElem,
          "mouseup",
          OpenLayers.Function.bindAsEventListener(this.onInputClick,context));
        layerLi.appendChild(inputElem);

        // create span
        var labelSpan= document.createElement("span");
        labelSpan.id= 'font-style_' + layer.params.LAYERS;
        labelSpan.innerHTML= ' : ' +layer.name;
        labelSpan.title= layer.name;
        layerLi.appendChild(labelSpan);

        this.dataLayers.push({
          'layer': layer,
          'inputElem': inputElem,
          'labelSpan': labelSpan
        });
      }
    }

    // print and bookmark
    var li= document.createElement('li');
    li.style.display= (this.showOptions? 'block':'none');
    var input= document.createElement('input');
    input.type= 'image';
    input.alt= input.title= '';
    input.src= 'http://geodesie.ign.fr/fiches/src/images/bt_outils/imprimante.png';
    input.id= input.name= 'v_impriable';
    OpenLayers.Event.observe(input, "click",
      OpenLayers.Function.bindAsEventListener(this.onPrint, this));
    li.appendChild(input);
    input= document.createElement('input');
    input.type= 'image';
    input.alt= input.title= '';
    input.src= 'http://geodesie.ign.fr/fiches/src/images/bt_outils/favori.png';
    input.id= input.name= 'Favoris';
    OpenLayers.Event.observe(input, "click",
      OpenLayers.Function.bindAsEventListener(this.addBookMark, this));
    li.appendChild(input);
    groupUl.appendChild(li);
    li= document.createElement('li');
    li.className= 'toggleOptions';
    this.aToggleOptions= document.createElement('a');
    this.aToggleOptions.id= 'toggleAdvancedOptions';
    this.aToggleOptions.innerHTML= '';
    li.appendChild(this.aToggleOptions);
    groupUl.appendChild(li);
    this.showControl(this.showOptions);
    OpenLayers.Event.observe(
      this.aToggleOptions,
      "click",
      OpenLayers.Function.bindAsEventListener(this.aToggleOptionsOnClick,this)
      );

    return this.div;
  },

  /**
             * APIMethod: onInputClick
             * A checkbox has been clicked, check or uncheck its corresponding input.
             *
             * Parameters:
             * e - {Event}
             *
             * Context:
             * inputElem - {DOMElement}
             * layerSwitcher - {<Geoportal.Control.LayerSwitcherPanel>}
             * layer - {<OpenLayers.Layer>}
             */
  onInputClick: function(e) {
    if (e != null) {
      OpenLayers.Event.stop(e);
    }
    if (!this.inputElem.disabled) {
      this.inputElem.checked= !this.inputElem.checked;
      this.layerSwitcher.updateMap();
    }
  },

  /**
             * APIMethod: onPrint
             * Print the current map.
             *
             * Parameters:
             * e - {Event}
             */
  onPrint: function(e) {
    var printablemapurl= getBaseUrl()+'printableMap.html';
    printablemapurl+= '?';
    printablemapurl+= 't='+getGeodesyTerritory(viewer.getTerritory())+'&';
    var c= this.map.getCenter().transform(this.map.getProjection(), OpenLayers.Projection.CRS84);
    printablemapurl+= 'c='+c.lon+','+c.lat+'&';
    printablemapurl+= 'z='+this.map.getZoom()+'&';
    printablemapurl+= 's='+(viewer.div.offsetWidth==gkMAP_MIN_WIDTH && viewer.div.offsetHeight==gkMAP_MIN_HEIGHT? '1':'0')+'&';
    printablemapurl+= 'm='+this.currentTheme+'&';
    printablemapurl+= 'l=';
    for (var ln in LAYER_NAMES) {
      var lar= viewer.getVariable(ln);
      if (lar) {
        printablemapurl+= ln+'$'+(lar.getVisibility()? '100':'0')+',';
      }
    }
    printablemapurl= printablemapurl.replace(/,$/,'&');
    window.open(printablemapurl);
    return false;
  },

  /**
             * APIMethod: addBookMark
             * Print the current map.
             *
             * Parameters:
             * e - {Event}
             */
  addBookMark: function(e) {
    var bookmarkurl=
    document.location.protocol+'//'+
    document.location.hostname+
    (document.location.port? ':'+document.location.port : '')+
    document.location.pathname.split('?')[0];
    bookmarkurl+= '?module=e&action=visugeod&';
    bookmarkurl+= 't='+getGeodesyTerritory(viewer.getTerritory())+'&';
    var c= this.map.getCenter().transform(this.map.getProjection(), OpenLayers.Projection.CRS84);
    bookmarkurl+= 'c='+c.lon+','+c.lat+'&';
    bookmarkurl+= 'z='+this.map.getZoom()+'&';
    bookmarkurl+= 's='+(viewer.div.offsetWidth==gkMAP_MIN_WIDTH && viewer.div.offsetHeight==gkMAP_MIN_HEIGHT? '1':'0')+'&';
    bookmarkurl+= 'm='+this.currentTheme+'&';
    bookmarkurl+= 'l=';
    for (var ln in LAYER_NAMES) {
      var lar= viewer.getVariable(ln);
      if (lar) {
        bookmarkurl+= ln+'$'+(lar.getVisibility()? '100':'0')+',';
      }
    }
    bookmarkurl= bookmarkurl.replace(/,$/,'&');
    var bookmarktitle= 'Accès à '+getServiceBaseUrl()+'/geodesie/';
    if (document.all) {
      window.external.AddFavorite(bookmarkurl,bookmarktitle);
    } else {
      window.sidebar.addPanel(bookmarktitle,bookmarkurl,'');
    }
    return false;
  },

  /**
             * APIMethod: updateMap
             * Cycles through the loaded data and makes
             * the necessary calls to the Map object such that that the map's
             * visual state corresponds to what the user has selected in the control
             * Does not take into account base layers.
             */
  updateMap: function() {
    // set the correct visibilities for the overlays
    for (var i= 0, len= this.dataLayers.length; i<len; i++) {
      var layerEntry= this.dataLayers[i];
      layerEntry.layer.setVisibility(layerEntry.inputElem.checked);
    }
  },

  /**
             * Method: onThemeChange
             * Change visibility of layers.
             *
             * Parameters:
             * evt - {Event}
             *
             * Context:
             * selectLayers - {DOMElement}
             * control - {<Geoportal.Control.LayerSwitcherPanel>}
             */
  onThemeChange:function(evt) {
    this.control.currentTheme= this.selectLayers.options[this.selectLayers.selectedIndex].value;
    for (var ln in LAYER_NAMES) {//ln == nom du layer (ex : rgp)
      var lar= viewer.getVariable(ln);
      if (lar) {
        lar.setVisibility(LAYER_NAMES[ln].themes[this.control.currentTheme]);
      }
    }
    this.selectLayers.blur();
  },

  /**
             * Method: aToggleOptionsOnClick
             * Show/Hide layers' switcher content.
             *
             * Parameters:
             * evt - {Event}
             */
  aToggleOptionsOnClick: function(evt) {
    this.showOptions= !this.showOptions;
    var nodes= this.frmOpts.getElementsByTagName("li");
    for (var i= 0, l= nodes.length; i<l; i++) {
      var n= nodes[i];
      if (i==l-1) {
        this.showControl(this.showOptions);
        break;
      }
      if (this.showOptions) {
        OpenLayers.Element.show(n);
      } else {
        OpenLayers.Element.hide(n);
      }
    }
  },

  /**
             * APIMethod: maximizeControl
             * Show up the labels and divs for the control
             *
             * Parameters:
             * e - {Event} the browser event
             */
  maximizeControl: function(e) {
    this.showControl(true);
    if (e != null) {
      OpenLayers.Event.stop(e);
    }
  },

  /**
             * APIMethod: minimizeControl
             * Hide all the contents of the control, shrink the size,
             *     add the maximize icon
             *
             * Parameters:
             * e - {Event} the browser event
             */
  minimizeControl: function(e) {
    this.showControl(false);
    if (e != null) {
      OpenLayers.Event.stop(e);
    }
  },

  /**
             * APIMethod: showControl
             * Hide/Show all LayerSwitcher controls depending on whether we are
             *     minimized or not
             *
             * Parameters:
             * minimize - {Boolean}
             */
  showControl: function(minimize) {
    if(this.aToggleOptions)
    {
      this.aToggleOptions.innerHTML= minimize?
      '=&gt; Fermer Options &lt;='
      :   '=&gt; Options avancées &lt;=';
    }
  },

  CLASS_NAME: 'Geoportal.Control.LayerSwitcherPanel'
});

// Panier:
Geoportal.Control.GeodesyBasket= OpenLayers.Class( Geoportal.Control, {
  /**
             * Property: dataFeatures
             * {Array(Object)} hash with feature and selection status
             */
  dataFeatures: null,

  /**
             * Property: nbPoints
             * {Integer} total number of selected points.
             */
  nbPoints: 0,

  /**
             * Property: nbSites
             * {Integer} total number of selected geodesy sites
             */
  nbSites: 0,

  /**
      * APIProperty: pdfUrl
      * {String} Url of PDF printing service
      */
  pdfUrl: null,

  /**
      * Constructor: Geoportal.Control.GeodesyBasket
      *
      * Parameters:
      * layer - {<OpenLayers.Layer.Vector>} the layer that supports selected features
      * options - {Object}
      */
  initialize: function(layer, options) {
    Geoportal.Control.prototype.initialize.apply(this, [options]);
    this.layer= layer;
    this.dataFeatures= [];
    this.showOptions= false;
    this.elements= this.elements || [];
    for (var i= 0, l= this.elements.length; i<l; i++) {
      var el= this.elements[i];
      if (typeof(el)=='string') {
        this.elements[i]= OpenLayers.Util.getElement(el);
      }
    }
    if (!this.pdfUrl) {//Mathieu 26 07 2010
      this.pdfUrl= 'http://'+getServiceBaseUrl()+'/fiches/index.php?module=e&action=visugeod';
    }
  },

  /**
             * APIMethod: destroy
             */
  destroy: function() {
    this.layer= null;
    this.dataFeatures= null;
    OpenLayers.Event.stopObservingElement(this.div);
    Geoportal.Control.prototype.destroy.apply(this, arguments);
  },

  /**
             * Method: setMap
             *
             * Properties:
             * map - {<OpenLayers.Map>}
             */
  setMap: function(map) {
    Geoportal.Control.prototype.setMap.apply(this, arguments);
  },

  /**
             * Method: draw
             *
             * Returns:
             * {DOMElement} A reference to the DIV DOMElement containing the
             *     switcher tabs.
             */
  draw: function() {
    Geoportal.Control.prototype.draw.apply(this,arguments);

    // create layout divs
    this.loadContents();

    // populate div with current info
    this.redraw();

    // set mode to minimize
    this.minimizeControl();

    return this.div;
  },

  /**
             * APIMethod: loadContents
             * Set up the control's basic content.
             * DOM elements for the features are not created here (See redraw()).
             */
  loadContents: function() {
    this.ulBasketId= 'panierContent';
    this.liTotalId= 'liPanierTotal';
    this.totalFeaturesId= 'total_point_ouvert';
    this.detailedContentId= 'panierDetailedContent';
    this.totalRepNivId= 'total_rn_ouvert';
    this.totalSiteId= 'total_sit_ouvert';
    this.liBasketToggleId= 'toggleContainerPanier';
    this.aToggleBasketId= 'togglePanier';
    this.frmBasketId= 'frm_panier';
    this.featuresBasketId= 'ajax_panier';
    this.emptyBasketId= 'a_vidage_panier2';
    this.zoomToSelectedFeaturesId= 'goto';
    this.makePDFId= 'pdf';
    if(document.location.hostname == 'sgn.ign.fr') this.makePDFterrainId= 'pdf_terrain';
    this.delFeaturesId= 'retirer';
    this.acceptFeaturesId= 'accept';
    var t1= 'Zoomer sur les points s&eacute;lectionn&eacute;s';
    var t2= 'Voir les fiches signal&eacute;tiques des &eacute;l&eacute;ments s&eacute;lectionn&eacute;s';
    var t2_terrain= 'Voir les fiches terrain des &eacute;l&eacute;ments s&eacute;lectionn&eacute;s';
    var t3= 'Enlever les &eacute;l&eacute;ments s&eacute;lectionn&eacute;s du panier';
    var t4= 'S&eacute;lectionner/D&eacute;s&eacute;lectionner tous les points';
    var button_terrain = '';
    if(document.location.hostname == 'sgn.ign.fr')
      button_terrain = '<input type="image" id="'+this.makePDFterrainId+'" name="'+this.makePDFterrainId+'" src="http://geodesie.ign.fr/fiches/src/images/bt_outils/pdf_terrain.png" alt="'+t2_terrain+'" title="'+t2_terrain+'"/>'
    this.div.innerHTML=
    '<h2>Panier <a style="color:black;cursor:pointer;display:none;" id="'+this.emptyBasketId+'">(Vider le panier)</a></h2>' +
    '<div class="editoBox editoBox2">' +
    '<ul id="'+this.ulBasketId+'">' +
    '<li id="'+this.liTotalId+'">Vous avez <strong>(<span id="'+this.totalFeaturesId+'"></span>)</strong> point(s) dans votre panier</li>'+
    '<li>'+
    '<ul id="'+this.detailedContentId+'">'+
    '<li><strong>(<span id="'+this.totalRepNivId+'"></span>)</strong> rep&eacute;re(s) de nivellement</li>'+
    '<li><strong>(<span id="'+this.totalSiteId+'"></span>)</strong> site(s) g&eacute;od&eacute;sique(s)</li>'+
    '</ul>'+
    '</li>'+
    '<li id="'+this.liBasketToggleId+'">'+
    '<a id="'+this.aToggleBasketId+'"></a>'+
    '</li>'+
    '</ul>'+
    '<form id="'+this.frmBasketId+'" name="'+this.frmBasketId+'" action="javascript:void(0);" style="display:none;">'+
    '<table>'+
    '<tr>'+
    '<td style="width:34%;">'+
    '<center>'+
    '<input type="image" id="'+this.zoomToSelectedFeaturesId+'" name="'+this.zoomToSelectedFeaturesId+'" src="http://geodesie.ign.fr/fiches/src/images/bt_outils/goto.png" alt="'+t1+'" title="'+t1+'"/>'+
    '</center>'+
    '</td>'+
    '<td style="width:33%;">'+
    '<center>'+
    '<input type="image" id="'+this.makePDFId+'" name="'+this.makePDFId+'" src="http://geodesie.ign.fr/fiches/src/images/bt_outils/pdf.png" alt="'+t2+'" title="'+t2+'"/>'+button_terrain+
    '</center>'+
    '</td>'+
    '<td style="width:33%;">'+
    '<center>'+
    '<input type="image" id="'+this.delFeaturesId+'" name="'+this.delFeaturesId+'" src="http://geodesie.ign.fr/fiches/src/images/bt_outils/croix.png" alt="'+t3+'" title="'+t3+'"/>'+
    '</center>'+
    '</td>'+
    '</tr>'+
    '</table>'+
    '<table>'+
    '<tr>'+
    '<th style="width:24px;">'+
    '<center>'+
    '<input type="image" id="'+this.acceptFeaturesId+'" name="'+this.acceptFeaturesId+'" src="http://geodesie.ign.fr/fiches/src/images/bt_outils/accept.png" alt="'+t4+'" title="'+t4+'"/>'+
    '</center>'+
    '</th>'+
    '<th>Nom du point</th>'+
    '<th style="width:87px;">Outils individuels</th>'+
    '</tr>'+
    '</table>'+
    '<div id="'+this.featuresBasketId+'">'+
    '<table style="width:100%;">'+
    '<tbody></tbody>'+
    '</table>'+
    '</div>'+
    '</form>'+
    '</div>';
    this.ulBasket= OpenLayers.Util.getElement(this.ulBasketId);
    this.liTotal= OpenLayers.Util.getElement(this.liTotalId);
    this.totalFeatures= OpenLayers.Util.getElement(this.totalFeaturesId);
    this.detailedContent= OpenLayers.Util.getElement(this.detailedContentId);
    this.totalRepNiv= OpenLayers.Util.getElement(this.totalRepNivId);
    this.totalSite= OpenLayers.Util.getElement(this.totalSiteId);
    this.liBasketToggle= OpenLayers.Util.getElement(this.liBasketToggleId);
    this.aToggleBasket= OpenLayers.Util.getElement(this.aToggleBasketId);
    this.frmBasket= OpenLayers.Util.getElement(this.frmBasketId);
    this.featuresBasket= OpenLayers.Util.getElement(this.featuresBasketId);
    this.emptyBasket= OpenLayers.Util.getElement(this.emptyBasketId);
    this.zoomToSelectedFeatures= OpenLayers.Util.getElement(this.zoomToSelectedFeaturesId);
    this.makePDF= OpenLayers.Util.getElement(this.makePDFId);
    if(document.location.hostname == 'sgn.ign.fr') this.makePDFterrain= OpenLayers.Util.getElement(this.makePDFterrainId);
    this.delFeatures= OpenLayers.Util.getElement(this.delFeaturesId);
    this.acceptFeatures= OpenLayers.Util.getElement(this.acceptFeaturesId);

    OpenLayers.Event.observe(
      this.aToggleBasket,
      "click",
      OpenLayers.Function.bindAsEventListener(this.aToggleBasketOnClick,this)
      );
    OpenLayers.Event.observe(
      this.emptyBasket,
      "click",
      OpenLayers.Function.bindAsEventListener(this.empty,this)//vidage du panier?
      );
    OpenLayers.Event.observe(
      this.zoomToSelectedFeatures,
      "click",
      OpenLayers.Function.bindAsEventListener(this.zoomTo,this)
      );
    OpenLayers.Event.observe(
      this.makePDF,
      "click",
      OpenLayers.Function.bindAsEventListener(this.printToPDF,this)
      );
    if(document.location.hostname == 'sgn.ign.fr') {
      OpenLayers.Event.observe(
        this.makePDFterrain,
        "click",
        OpenLayers.Function.bindAsEventListener(this.printToPDFterrain,this)
        );
    }
    OpenLayers.Event.observe(
      this.delFeatures,
      "click",
      OpenLayers.Function.bindAsEventListener(this.removeFeatures,this)
      );
    OpenLayers.Event.observe(
      this.acceptFeatures,
      "click",
      OpenLayers.Function.bindAsEventListener(this.selectAllFeatures,this)
      );
  },

  /**
             * APIMethod: redraw
             *  Goes through and takes the current state of the Map and rebuilds the
             *  control to display that state.  Lists each data layer with a checkbox.
             *
             * Returns:
             * {DOMElement} A reference to the DIV DOMElement containing the control
             */
  redraw: function() {
    if (this.nbPoints>0) {
      OpenLayers.Element.show(this.emptyBasket);
    } else {
      OpenLayers.Element.hide(this.emptyBasket);
    }
    this.totalFeatures.innerHTML= ''+this.nbPoints;
    this.totalRepNiv.innerHTML= ''+(this.nbPoints - this.nbSites);
    this.totalSite.innerHTML= ''+this.nbSites;
    this.showControl(this.showOptions);

    return this.div;
  },

  /**
             * Method: aToggleBasketOnClick
             * Show/Hide basket's content.
             *
             * Parameters:
             * evt - {Event}
             */
  aToggleBasketOnClick: function(evt) {//click ouverture/fermeture panier
    if(change_order_bouton == 'change' && on_off_panier == 'close'){
      this.showOptions = true;
      change_order_bouton = '';
    }
    else{
      this.showOptions= !this.showOptions;
    }
    var e;
    for (var i= 0, l= (this.elements || []).length; i<l; i++) {
      if (this.showOptions) {
        OpenLayers.Element.hide(this.elements[i]);
        on_off_panier = 'open';
      } else {
        OpenLayers.Element.show(this.elements[i]);
        on_off_panier = 'close';
      }
    }//alert(this.showOptions);
    e= OpenLayers.Util.getElement('mainCt');
    if (this.showOptions) {
      e.style.width= '625px';
    } else {
      e.style.width= '825px';
    }
    e= OpenLayers.Util.getElement('mainTop');
    if(etat_taille_carte=='grande'){
      if (this.showOptions) {
        e.style.width= '625px';
      } else {
        e.style.width= '825px';
      }
    }
    e= OpenLayers.Util.getElement('navCt');
    if (this.showOptions) {
      e.style.width= '352px';
    } else {
      e.style.width= '150px';
    }
    var es= OpenLayers.Element.getElementsByClassName('editoBox2');
    for (var i= 0, l= es.length; i<l; i++) {
      if (this.showOptions) {
        es[i].style.width= '350px';
      } else {
        es[i].style.width= '148px';
      }
    }
    if (this.showOptions) {
      OpenLayers.Element.show(this.frmBasket);
    } else {
      OpenLayers.Element.hide(this.frmBasket);
    }
    this.showControl(this.showOptions);
    var g_1 = OpenLayers.Util.getElement('overview_map_panel');
    var h_1 = OpenLayers.Util.getElement('newnews_panel');
    //alert(etat_taille_carte+' '+on_off_panier);
    if(etat_taille_carte=='grande' && on_off_panier == 'close'){
      viewer.setSize(gkMAP_MAX_WIDTH,gkMAP_MAX_HEIGHT);
      g_1.style.display = 'none';
      h_1.style.display = 'none';
    }
    else {
      viewer.setSize(gkMAP_MIN_WIDTH,gkMAP_MIN_HEIGHT);
    }
  },

  /**
             * APIMethod: maximizeControl
             * Show up the labels and divs for the control
             *
             * Parameters:
             * e - {Event} the browser event
             */
  maximizeControl: function(e) {
    this.showControl(true);
    if (e != null) {
      OpenLayers.Event.stop(e);
    }
  },

  /**
             * APIMethod: minimizeControl
             * Hide all the contents of the control, shrink the size,
             *     add the maximize icon
             *
             * Parameters:
             * e - {Event} the browser event
             */
  minimizeControl: function(e) {
    this.showControl(false);
    if (e != null) {
      OpenLayers.Event.stop(e);
    }
  },

  /**
             * APIMethod: showControl
             * Hide/Show all LayerSwitcher controls depending on whether we are
             *     minimized or not
             *
             * Parameters:
             * minimize - {Boolean}
             */
  showControl: function(minimize) {
    this.aToggleBasket.innerHTML= minimize?
    '=&gt; Fermer le panier &lt;='
    :   '=&gt; Ouvrir le panier &lt;=';
  },

  /**
             * APIMethod: addFeatures
             * Add new features
             *
             * Parameters:
             * features - {Array(<OpenLayers.Feature.Vector>)}
             */
  addFeatures: function(features) {
    if (!(features && features.length>0)) {
      return;
    }
    for (var i= 0, l= features.length; i<l; i++) {
      var f= features[i];
      if (f.attributes['type'].match(/^(RRF|RBF|RBA|RDF|RD|NTF|RBG|RBM|RBR|)$/)) {
        this.nbSites++;
      }
      this.nbPoints++;
      this.layer.addFeatures([f]);
      var tr= document.createElement('tr');
      tr.setAttribute('id', f.fid);
      var pfx= '';
      switch (f.attributes['type']) {
        case 'RRF':
        case 'RBF':
        case 'RBG':
        case 'RBM':
        case 'RBR':
          pfx= 'rbf';
          break;
        case 'rn' :
          pfx= 'rn';
          break;
        case 'RBA':
        case 'RDF':
        case 'RD':
        case 'NTF':
        default   :
          pfx= 'rdf';
          break;
      }
      var eta= 'bon';
      if (pfx==='rn') {
        if (f.attributes['triplet_info']==='') {
          switch(f.attributes['etat']){
            case 'E':
              eta = 'bon';
              break;
            case 'D':
              eta = 'dead';
              break;
            default :
              eta = 'bad';
              break;
          }
        } else {
          eta= 'triplet';
        }
      } else {
        eta= f.attributes['etat']=='B'? 'bon' : 'bad';
      }
      var td= document.createElement('td');
      td.className= 'geod panierTd panierTdOne';
      td.innerHTML=
      '<center>' +
      '<input name="c_'+f.fid+'" id="c_'+f.fid+'" name="c_'+f.fid+'" type="checkbox"/>'+
      '</center>';
      tr.appendChild(td);
      td= document.createElement('td');
      td.className= 'geod panierTd panierTdThree';
      td.innerHTML=
      '<img alt="" title="" src="http://geodesie.ign.fr/fiches/src/symbol/'+pfx+'_'+eta+'_15.gif"/>' +
      f.attributes['nom'];
      tr.appendChild(td);
      td= document.createElement('td');
      td.className= 'geod panierTd panierTdFour';
      var t1= 'Aller sur le point '+f.attributes['nom'];
      var t2= 'Voir la fiche signalétique de '+f.attributes['nom'];
      var t3= 'Enlever le point '+f.attributes['nom']+' du panier';
      td.innerHTML=
      '<input type="image" class="icones16" src="http://geodesie.ign.fr/fiches/src/images/bt_outils/goto16.png" id="a_'+f.fid+'" name="a_'+f.fid+'" alt="'+t1+'" title="'+t1+'"/>' +
      '<input type="image" class="icones16" src="http://geodesie.ign.fr/fiches/src/images/bt_outils/pdf16.png" id="p_'+f.fid+'" name="p_'+f.fid+'" alt="'+t2+'" title="'+t2+'"/>' +
      '<input type="image" class="icones16" src="http://geodesie.ign.fr/fiches/src/images/bt_outils/croix16.png" id="d_'+f.fid+'" name="d_'+f.fid+'" alt="'+t3+'" title="'+t3+'"/>';
      tr.appendChild(td);

      // Pour affichage IE
      td= document.createElement('td');
      td.className = 'td_IE_hack';
      td.innerHTML = '';
      tr.appendChild(td);

      this.featuresBasket.getElementsByTagName('table')[0].tBodies[0].appendChild(tr);
      var df= {
        'feature':f,
        'selected':false,
        'tr':tr
      };
      var e1= OpenLayers.Util.getElement('c_'+f.fid);
      e1.value= f.fid;
      e1.disabled= e1.checked= e1.defaultChecked= false;
      e1.style.autocomplete= 'off';
      var c1= {
        'elem': e1,
        'data': df,
        'control': this
      };
      OpenLayers.Event.observe(
        e1,
        "mouseup",//FIXME click IE ne semble pas fonctionner?
        OpenLayers.Function.bindAsEventListener(this.clickPoint,c1)
        );
      var e2= OpenLayers.Util.getElement('a_'+f.fid);
      var c2= {
        'elem': e2,
        'data': df,
        'control': this
      };
      OpenLayers.Event.observe(
        e2,
        "click",
        OpenLayers.Function.bindAsEventListener(this.centerToPoint,c2)
        );
      var e3= OpenLayers.Util.getElement('p_'+f.fid);
      var c3= {
        'elem': e3,
        'data': df,
        'control': this
      };
      OpenLayers.Event.observe(
        e3,
        "click",
        OpenLayers.Function.bindAsEventListener(this.printPoint,c3)
        );
      var e4= OpenLayers.Util.getElement('d_'+f.fid);
      var c4= {
        'elem': e4,
        'data': df,
        'control': this
      };
      OpenLayers.Event.observe(
        e4,
        "click",
        OpenLayers.Function.bindAsEventListener(this.removePoint,c4)
        );
      this.dataFeatures.push(df);
    }
    this.redraw();
  },

  /**
             * Method: removeFeatures
             * Delete selected features
             *
             * Parameters:
             * evt - {Event}
             */
  removeFeatures: function(evt) {
    if (evt) {
      (evt.target || evt.srcElement).blur();
    }
    for (var i= this.dataFeatures.length-1; i>=0; i--) {
      var data= this.dataFeatures[i];
      if (!data.selected) {
        continue;
      }
      if (data.feature.attributes['type'].match(/^(RRF|RBF|RBA|RDF|RD|NTF|RBG|RBM|RBR|)$/)) {
        this.nbSites--;
      }
      this.nbPoints--;
      this.layer.removeFeatures([data.feature]);
      this.featuresBasket.getElementsByTagName('table')[0].tBodies[0].deleteRow(data.tr.rowIndex);
      this.dataFeatures.splice(i,1);
    }
    this.redraw();
  },

  /**
             * Method: selectAllFeatures
             * Select all features
             *
             * Parameters:
             * evt - {Event}
             */
  selectAllFeatures: function(evt) {
    var selectThem= false;
    // search if they are all selected ...
    for (var i= 0, l= this.dataFeatures.length; i<l; i++) {
      var data= this.dataFeatures[i];
      if (!data.selected) {
        selectThem= true;// no => select them all !
        break;
      }
    }
    for (var i= 0, l= this.dataFeatures.length; i<l; i++) {
      var data= this.dataFeatures[i];
      data.selected= selectThem;
      var e= OpenLayers.Util.getElement('c_'+data.feature.fid);
      e.checked= selectThem;
    }
    if (evt) {
      (evt.target || evt.srcElement).blur();
    }
  },

  /**
             * Method: empty
             * Remove all selected features
             *
             * Parameters:
             * evt - {Event}
             */
  empty: function(evt) {
    if (evt) {
      (evt.target || evt.srcElement).blur();
    }
    this.layer.destroyFeatures();
    this.dataFeatures= [];
    this.nbPoints= this.nbSites= 0;
    this.redraw();
    if(document.all){
      for (var i= 0; i<1001; i++) {
        if(this.featuresBasket.getElementsByTagName('table')[0].tBodies[0].innerHTML!="")
          this.featuresBasket.getElementsByTagName('table')[0].tBodies[0].deleteRow(0);
        else
          return;
      }
    }
    else{
      this.featuresBasket.getElementsByTagName('table')[0].tBodies[0].innerHTML = '';
    }
  },

  /**
             * Method: zoomTo
             * Zoom to extent of selected features.
             *
             * Parameters:
             * evt - {Event}
             */
  zoomTo: function(evt) {
    var nbSel= 0;
    var bounds= new OpenLayers.Bounds();
    for (var i= 0, l= this.dataFeatures.length; i<l; i++) {
      var data= this.dataFeatures[i];
      if (data.selected) {
        nbSel++;
        bounds.extend(data.feature.geometry.getBounds());
      }
    }
    if (nbSel>0) {
      this.layer.map.zoomToExtent(bounds);
    }
    if (evt) {
      (evt.target || evt.srcElement).blur();
    }
  },

  /**
             * Method: printToPDF
             * Print a PDF containing all selected features.
             *
             * Parameters:
             * evt - {Event}
             */
  printToPDFterrain: function(evt) {
    var sels= [];
    for (var i= 0, l= this.dataFeatures.length; i<l; i++) {
      var data= this.dataFeatures[i];
      if (data.selected) {
        var p= 'c_'+data.feature.attributes['cid']+'_';
        var sfx= '';
        if (typeof(data.feature.attributes['triplet_info'])!=='undefined') {
          if (this.map.viewer.territory=='FXX') {
            sfx= 'nivf';
          } else {
            sfx= 'nivo';
          }
        } else {
          if (this.map.viewer.territory=='FXX') {
            sfx= 'rsgf';
          } else {
            sfx= 'rsgo';
          }
        }
        p+= sfx;
        sels.push(p);
      }
    }
    if (sels.length>0) {
      if (sels.length<=400) {
        toggleTimer('show');
        sels.push('');
        var body= 'h_panier=pdf_terrain&'+sels.join('=on&');
        body= body.replace(/&$/,'');
        var postOptions= {
          url:this.pdfUrl,
          async:true,
          headers:{
            "Content-type":"application/x-www-form-urlencoded"
          },
          callback:function(){},
          success:this.printToPDFOk,
          failure:this.printToPDFKo,
          scope:this
        };
        var pdfRqst= OpenLayers.Request.POST(
          OpenLayers.Util.applyDefaults({
            'data':body
          },postOptions));
        body= null;
        postOptions= null;
      } else {
        alert('Trop de sites sélectionnés !');
      }
    } else {
      alert("Aucun point sélectionné !");//FIXME
    }
    if (evt) {
      (evt.target || evt.srcElement).blur();
    }
  },

  /**
             * Method: printToPDF
             * Print a PDF containing all selected features.
             *
             * Parameters:
             * evt - {Event}
             */
  printToPDF: function(evt) {
    var sels= [];
    for (var i= 0, l= this.dataFeatures.length; i<l; i++) {
      var data= this.dataFeatures[i];
      if (data.selected) {
        var p= 'c_'+data.feature.attributes['cid']+'_';
        var sfx= '';
        if (typeof(data.feature.attributes['triplet_info'])!=='undefined') {
          if (this.map.viewer.territory=='FXX') {
            sfx= 'nivf';
          } else {
            sfx= 'nivo';
          }
        } else {
          if (this.map.viewer.territory=='FXX') {
            sfx= 'rsgf';
          } else {
            sfx= 'rsgo';
          }
        }
        p+= sfx;
        sels.push(p);
      }
    }
    if (sels.length>0) {
      if (sels.length<=400) {
        toggleTimer('show');
        sels.push('');
        var body= 'h_panier=pdf&'+sels.join('=on&');
        body= body.replace(/&$/,'');
        var postOptions= {
          url:this.pdfUrl,
          async:true,
          headers:{
            "Content-type":"application/x-www-form-urlencoded"
          },
          callback:function(){},
          success:this.printToPDFOk,
          failure:this.printToPDFKo,
          scope:this
        };
        var pdfRqst= OpenLayers.Request.POST(
          OpenLayers.Util.applyDefaults({
            'data':body
          },postOptions));
        body= null;
        postOptions= null;
      } else {
        alert('Trop de sites sélectionnés !');
      }
    } else {
      alert("Aucun point sélectionné !");//FIXME
    }
    if (evt) {
      (evt.target || evt.srcElement).blur();
    }
  },

  /**
             * Method: printToPDFOk
             * Called when the Ajax request returns a response.
             *
             * Parameters:
             * request - {XmlNode} request to server
             */
  printToPDFOk: function(request) {
    if (!request) {
      alert("Echec à l'appel du service de création du PDF.");//FIXME
      toggleTimer('hide');
      return;
    }
    var parts= request.responseText.replace(/[\n\r]/g,'').split('<');
    if (parts[0]!=1) {//alert(parts[0]);
      window.open(OpenLayers.String.trim(parts[0]));
    } else {
      alert('Création du PDF échouée.');//FIXME
    }
    toggleTimer('hide');
  },

  /**
             * Method: printToPDFKo
             * Called when the Ajax request fails.
             *
             * Parameters:
             * request - {XmlNode} request to server
             */
  printToPDFKo: function(request) {
    alert('Création du PDF échouée.');//FIXME
    toggleTimer('hide');
  },

  /**
             * Method: clickPoint
             * Select/Unselect point.
             *
             * Parameters:
             * evt - {Event}
             *
             * Context:
             *      * elem - {DOMElement} the DOM element the event came from
             *      * data - {Object} the point's data (feature, selected, tr)
             *      * control - {<Geoportal.Control.GeodesyBasket>}
             */
  clickPoint: function(evt) {
    //mouseup => not yet click, revert checked value !!!
    this.data.selected= !this.elem.checked;
    this.elem.blur();
    return false;
  },
  /**
             * Method: centerToPoint
             * Center map on selected point
             *
             * Parameters:
             * evt - {Event}
             *
             * Context:
             *      * elem - {DOMElement} the DOM element the event came from
             *      * data - {Object} the point's data (feature, selected, tr)
             *      * control - {<Geoportal.Control.GeodesyBasket>}
             */
  centerToPoint: function(evt) {
    var c= new OpenLayers.LonLat(this.data.feature.geometry.x, this.data.feature.geometry.y);
    this.control.map.setCenter(c);
    this.elem.blur();
    return false;
  },

  /**
             * Method: printPoint
             * Print (PDF) the point's information.
             *
             * Parameters:
             * evt - {Event}
             *
             * Context:
             *      * elem - {DOMElement} the DOM element the event came from
             *      * data - {Object} the point's data (feature, selected, tr)
             *      * control - {<Geoportal.Control.GeodesyBasket>}
             */
  printPoint: function(evt) {
    window.open(this.data.feature.attributes['url']);
    this.elem.blur();
    return false;
  },

  /**
             * Method: removePoint
             * Remove the point
             *
             * Parameters:
             * evt - {Event}
             *
             * Context:
             *      * elem - {DOMElement} the DOM element the event came from
             *      * data - {Object} the point's data (feature, selected, tr)
             *      * control - {<Geoportal.Control.GeodesyBasket>}
             */
  removePoint: function(evt) {
    for (var i= 0, l= this.control.dataFeatures.length; i<l; i++) {
      if (this.control.dataFeatures[i].feature.fid===this.data.feature.fid) {
        if (this.data.feature.attributes['type'].match(/^(RRF|RBF|RBA|RDF|RD|NTF|RBG|RBM|RBR|)$/)) {
          this.control.nbSites--;
        }
        this.control.nbPoints--;
        this.control.layer.removeFeatures([this.data.feature]);
        this.control.featuresBasket.getElementsByTagName('table')[0].tBodies[0].deleteRow(this.data.tr.rowIndex);
        this.control.dataFeatures.splice(i,1);
        this.control.redraw();
        break;
      }
    }
    this.elem.blur();
    return false;
  },

  CLASS_NAME: 'Geoportal.Control.GeodesyBasket'
});

// Surcharge de OpenLayers.Control.GetFeature:
OpenLayers.Control.GetGeodesyFeature= OpenLayers.Class(OpenLayers.Control.GetFeature, {
  /**
             * Property: layer
             * {<OpenLayers.Layer.Vector>} The layer supporting selected points.
             */
  layer:null,
  /**
             * APIProperty: basket
             * {<Geoportal.Control.GeodesyBasket>} The control in charge of
             * handling selected points.
             */
  basket:null,
  /**
             * Constructor: OpenLayers.Control.GetGeodesyFeature
             * Create a new control for fetching remote features.
             *
             * Parameters:
             * cntrl - {<Geoportal.Control.GeodesyBasket>} selected points control
             * options - {Object} A configuration object which at least has to contain
             *     a <protocol> property
             */
  initialize: function(cntrl, options) {
    var T= viewer.getVariable('territories');
    OpenLayers.Util.applyDefaults(options,{
      protocol:new OpenLayers.Protocol.WFS({
        url:T.wfsUrl || T.wxsUrl,
        //Mapserver:
        /* */
        featurePrefix:'ms',
        featureNS:'http://mapserver.gis.umn.edu/mapserver',
        geometryName:'msGeometry',
        /* */
        //Geoserver:
        /*
            featurePrefix:'ignf',
            featureNS:'http://www.ign.fr/',
            geometryName:'the_geom',
   */
        featureType:[],     //see activate
        srsName:T.wxsSrs,
        version:"1.0.0",
        formatOptions: {
          internalProjection: viewer.getMap().getProjection().clone(),
          externalProjection: new OpenLayers.Projection(T.wxsSrs)
        }
      }),
      click:false,
      clickout:false,
      eventListeners:{
        'beforefeatureselected': function(e) {  //vérifie si l'objet sélectionné ne l'est pas déjà
          if (!this.layer.features) return;
          if (this.layer.features.length==1000) {
            alert('Trop de sites sélectionnés !');
            return false;
          }
          for (var i= 0, l= this.layer.features.length; i<l; i++) {
            var f= this.layer.features[i];
            if (e.feature.fid===f.fid) {
              return false;
            }
          }
          return;
        },
        'featuresselected': function(e) {//ajoute les points au panier
          this.basket.addFeatures(e.features);
        }
      }
    });
    OpenLayers.Control.GetFeature.prototype.initialize.apply(this, [options]);
    this.basket= cntrl;
    this.layer= this.basket.layer;
  },
  /**
             * Method: activate
             * Activates the control.
             *
             * Returns:
             * {Boolean} The control was effectively activated.
             */
  activate:function() {
    if (this.updateTypeNames()) {
      if (OpenLayers.Control.GetFeature.prototype.activate.apply(this,arguments)) {
        return true;
      }
    }
    var cppCntrl= viewer.getVariable('cppCntrl')
    cppCntrl.activateControl(cppCntrl.defaultControl);
    alert('Vous devez zoomer pour activer cette fonction.');//FIXME
    return false;
  },
  /**
             * Method: deactivate
             * Deactivates the control.
             *
             * Returns:
             * {Boolean} The control was effectively deactivated.
             */
  deactivate:function() {
    if (OpenLayers.Control.GetFeature.prototype.deactivate.apply(this,arguments)) {
      this.updateTypeNames([]);
      this.active= null;
      return true;
    }
    return false;
  },
  /**
             * APIMethod: updateTypeNames
             * Sets the underlaying protocol with the TYPENAMEs.
             *
             * Parameters:
             * tns {Array({String})} - TYPENAMEs requested by the protocol.
             *
             * Returns:
             * {Integer} the number of requested TYPENAMEs.
             */
  updateTypeNames:function(tns) {
    var typeNames= tns || this.layer.checkStatus();
    this.protocol.featureType= typeNames.slice(0);
    this.protocol.options.featureType= this.protocol.featureType.slice(0);
    this.protocol.format.featureType= this.protocol.featureType.slice(0);
    this.protocol.format.options.featureType= this.protocol.featureType.slice(0);
    return typeNames.length>0;
  },
  /**
             * APIProperty: onZoomEnd
             * Callback on 'zoomend' event.
             */
  onZoomEnd:function() {
    if (this.active) {
      this.deactivate();
      this.activate();
    }
  },
  /**
     * Method: request
     * Sends a GetFeature request to the WFS
     *
     * Parameters:
     * bounds - {<OpenLayers.Bounds | OpenLayers.Geometry>} bounds or geometry
     * for the request's filter
     * options - {Object} additional options for this method.
     *
     * Supported options include:
     * single - {Boolean} A single feature should be returned.
     *     Note that this will be ignored if the protocol does not
     *     return the geometries of the features.
     * hover - {Boolean} Do the request for the hover handler.
     */
  request: function(bounds, options) {
    // IGNF: Set the cursor to "wait" to tell the user we're working on their click.
    OpenLayers.Element.addClass(this.map.viewPortDiv, "olCursorWait");

    options = options || {};
    //IGNF: complex filter => BBOX AND FILTER to optimize request
    var filter = new OpenLayers.Filter.Spatial({
      type: this.filterType,
      value: bounds,
      projection:(this.srs || this.map.getProjection()).getCode()
    });
    if (this.filterType===OpenLayers.Filter.Spatial.WITHIN) {
      filter= new OpenLayers.Filter.Logical({
        type: OpenLayers.Filter.Logical.AND,
        filters: [
        new OpenLayers.Filter.Spatial({
          type: OpenLayers.Filter.Spatial.BBOX,
          value: (this.srs? bounds.clone().transform(this.map.getProjection(),this.srs) : bounds).getBounds(),
          projection:(this.srs || this.map.getProjection()).getCode()
        }),
        filter
        ]
      });
    }
    var response = this.protocol.read({
      maxFeatures: options.single == true ? this.maxFeatures : undefined,
      filter: filter,
      callback: function(result) {
        if(result.success()) {
          if(result.features.length) {
            if(options.single == true) {
              //IGNF
              var c= (bounds instanceof OpenLayers.Bounds?
                bounds
                :   bounds.getBounds()).getCenterLonLat();
              this.selectBestFeature(result.features, c, options);
            } else {
              this.select(result.features);
            }
          } else if(options.hover) {
            this.hoverSelect();
          } else {
            this.events.triggerEvent("clickout");
            if(this.clickout) {
              this.unselectAll();
            }
          }
        }
        // Reset the cursor.
        OpenLayers.Element.removeClass(this.map.viewPortDiv, "olCursorWait");
      },
      scope: this
    });
    if(options.hover == true) {
      this.hoverResponse = response;
    }
  },
  /**
             * Method: setMap
             * Set the map property for the control.
             *      Register the callback against the 'zoomend' event.
             *
             * Parameters:
             * map - {<OpenLayers.Map>}
             */
  setMap:function(map) {
    OpenLayers.Control.GetFeature.prototype.setMap.apply(this,arguments);
    this.map.events.register('zoomend', this, this.onZoomEnd);
  },
  /**
             * Method: destroy
             * The destroy method is used to perform any clean up before the control
             * is dereferenced.  Typically this is where event listeners are removed
             * to prevent memory leaks.
             */
  destroy: function() {
    this.map.events.unregister('zoomend', this, this.onZoomEnd);
    this.basket= null;
    this.layer= null;
    OpenLayers.Control.GetFeature.prototype.destroy.apply(this,arguments);
  },
  CLASS_NAME: 'OpenLayers.Control.GetGeodesyFeature'
});



// Recherche:
Geoportal.Control.GeodesySearches= OpenLayers.Class( Geoportal.Control, {
  /**
             * Property: layer
             * {<OpenLayers.Layer.Vector>} The layer supporting selected points.
             */
  layer:null,
  /**
             * APIProperty: basket
             * {<Geoportal.Control.GeodesyBasket>} The control in charge of
             * handling selected points.
             */
  basket:null,
  /**
             * APIProperty: urlAutoCompletion
             * {String} URL for the autocompletion search service
             */
  autoCompletionUrl:null,
  /**
             * APIProperty: searchUrl
             * {String} URL for the search service
             */
  searchUrl:null,
  /**
             * Constructor: Geoportal.Control.GeodesySearches
             * Create a new control for fetching remote features.
             *
             * Parameters:
             * cntrl - {<Geoportal.Control.GeodesyBasket>} selected points control
             * options - {Object}
             */
  initialize: function(cntrl, options) {
    Geoportal.Control.prototype.initialize.apply(this,[options]);
    this.basket= cntrl;
    this.layer= this.basket.layer;
    if (!this.autoCompletionUrl) {
      this.autoCompletionUrl= 'http://'+getServiceBaseUrl()+'/fiches/index.php?module=e&action=visugeod';
    }
    if (!this.searchUrl) {
      this.searchUrl= 'http://'+getServiceBaseUrl()+'/fiches/index.php?module=e&action=visugeod';
    }
    var proxy= getProxyUrl();
    if (proxy) {
      this.autoCompletionUrl= proxy+encodeURIComponent(this.autoCompletionUrl);
      this.searchUrl= proxy+encodeURIComponent(this.searchUrl);
    }
  },
  /**
             * APIMethod: destroy
             */
  destroy: function() {
    this.searchForm= null;
    this.repereField= null;
    this.siteField= null;
    this.eastingField= null;
    this.northingField= null;
    this.nuts5Field= null;
    this.sheet50Field= null;
    this.cancelButton= null;
    this.submitButton= null;
    this.checkAll= null;
    this.checkSite= null;
    this.checkRN= null;
    Geoportal.Control.prototype.destroy.apply(this, arguments);
  },
  /**
             * Method: activate
             * Activates the control.
             *
             * Returns:
             * {Boolean} The control was effectively activated.
             */
  activate:function() {
    if (Geoportal.Control.prototype.activate.apply(this,arguments)) {
      toggleTimer("show");
      OpenLayers.Element.show(this.div);
      return true;
    }
    return false;
  },
  /**
             * Method: deactivate
             * Deactivates the control.
             *
             * Returns:
             * {Boolean} The control was effectively deactivated.
             */
  deactivate:function() {
    if (Geoportal.Control.prototype.deactivate.apply(this,arguments)) {
      OpenLayers.Element.hide(this.div);
      toggleTimer("hide");
      var cppCntrl= viewer.getVariable('cppCntrl')
      cppCntrl.activateControl(cppCntrl.defaultControl);
      return true;
    }
    return false;
  },
  /**
             * Method: setMap
             *
             * Properties:
             * map - {<OpenLayers.Map>}
             */
  setMap: function(map) {
    Geoportal.Control.prototype.setMap.apply(this, arguments);
  },
  /**
             * Method: draw
             *
             * Returns:
             * {DOMElement} A reference to the DIV DOMElement containing the
             *     switcher tabs.
             */
  draw: function() {
    Geoportal.Control.prototype.draw.apply(this,arguments);

    // create layout divs
    this.loadContents();

    // populate div with current info
    this.redraw();

    return this.div;
  },
  /**
             * APIMethod: loadContents
             * Set up the control's basic content.
             * DOM elements for the features are not created here (See redraw()).
             */
  loadContents: function() {
    this.searchFormID= 'frm_recherche';
    this.repereID= 'repere_ajax';
    this.siteID= 'site_ajax';
    this.eastingID= 'cooX_ajax';
    this.northingID= 'cooY_ajax';
    this.nuts5ID= 'communes_visugeod';
    this.sheet50ID= 'feuilles_visugeod';
    this.cancelButtonID= 'MessBtFalse';
    this.submitButtonID= 'MessBtTrue';
    this.checkAllID= 'avec';
    this.checkSiteID= 'avec_site';
    this.checkRNID= 'avec_rn';
    var crsName= OpenLayers.String.trim(new OpenLayers.Projection(TERRITORIES_INFO[getGeodesyTerritory(viewer.territory)].allowedDisplayProjections[0]).getTitle());
    this.div.innerHTML=
    '<div style="display: block;" id="MessCenter" name="MessCenter">'+
    '<div id="MessCenter_Header">Rechercher</div>'+
    '<table id="tb_MessCenter">'+
    '<tr>'+
    '<td colspan="2">'+
    '<form id="'+this.searchFormID+'" name="'+this.searchFormID+'" action="javascript:void(0);">'+
    '<input type="hidden" id="h_recherche" name="h_recherche" value="false"/>'+
    '<table style="width:100%">'+
    '<tr>'+
    '<td style="text-align:center;" colspan="4">'+
    '<b>PAR LE NOM</b>'+
    '</td>'+
    '</tr>'+
    '<tr>'+
    '<td style="text-align:right;width:50%;" colspan="2">'+
    '<span>Repère de nivellement : </span>'+
    '</td>'+
    '<td colspan="2">'+
    '<input type="text" class="inText" name="repere" style="width :100%;" id="'+this.repereID+'" value=""/>'+
    '<span id="indicateur-chargement-repere_ajax" style="display:none;">'+
    '<img src="http://geodesie.ign.fr/fiches/src/images/logos/ajax-loader.gif"/>'+
    '</span>'+
    '<br/>'+
    '<div class="autocomplete" id="repere_ajax_propositions" style="display:none;"></div>'+
    '</td>'+
    '</tr>'+
    '<tr>'+
    '<td style="text-align:right;" colspan="2">'+
    '<span>Site géodésique : </span>'+
    '</td>'+
    '<td colspan="2">'+
    '<input type="text" class="inText" name="point_geo" style="width :100%;" id="'+this.siteID+'" value=""/>'+
    '<span id="indicateur-chargement-site_ajax" style="display:none;">'+
    '<img src="http://geodesie.ign.fr/fiches/src/images/logos/ajax-loader.gif"/>'+
    '</span>'+
    '<br/>'+
    '<div class="autocomplete" id="site_ajax_propositions" style="display:none;"></div>'+
    '</td>'+
    '</tr>'+
    '</table>'+
    '<table style="width:100%">'+
    '<tr>'+
    '<td style="text-align:center;" colspan="4">'+
    '<b>PAR LES COORDONNEES</b> ('+crsName+')'+
    '</td>'+
    '</tr>'+
    '<tr>'+
    '<td colspan="2">'+
    '<input type="text" class="inText" name="cooX" id="'+this.eastingID+'" value="" style="width:200px;"/>'+
    '</td>'+
    '<td style="text-align:left;" colspan="2">'+
    'Est en mètres'+
    '</td>'+
    '</tr>'+
    '<tr>'+
    '<td colspan="2">'+
    '<input type="text" class="inText" name="cooY" id="'+this.northingID+'" value="" style="width:200px;"/>'+
    '</td>'+
    '<td style="text-align:left;" colspan="2">'+
    'Nord en mètres'+
    '</td>'+
    '</tr>'+
    '</table>'+
    '<table style="width:100%">'+
    '<tr>'+
    '<td style="text-align:center;" colspan="4">'+
    '<b>PAR LE LIEU</b>'+
    '</td>'+
    '</tr>'+
    '<tr>'+
    '<td style="text-align:right;width:35%">'+
    '<b>Nom de commune ou n° INSEE</b>'+
    '</td>'+
    '<td colspan="3">'+
    '<input type="text" class="inText" name="insee_visugeod" style="width :80%;" id="'+this.nuts5ID+'" value=""/>'+
    '<span id="indicateur-chargement-communes_visugeod" style="display:none;">'+
    '<img src="http://geodesie.ign.fr/fiches/src/images/logos/ajax-loader.gif" />'+
    '</span>'+
    '<br/>'+
    '<div class="autocomplete" id="communes_visugeod_propositions" style="display:none;"></div>'+
    '</td>'+
    '</tr>'+
    '<tr>'+
    '<td style="text-align:right;width:35%">'+
    '<b>N° ou nom de feuille au 1/50000</b>'+
    '</td>'+
    '<td colspan="3">'+
    '<input type="text" class="inText" name="feuille50" style="width :80%;" id="'+this.sheet50ID+'" value=""/>'+
    '<span id="indicateur-chargement-feuilles_visugeod" style="display:none;">'+
    '<img src="http://geodesie.ign.fr/fiches/src/images/logos/ajax-loader.gif" />'+
    '</span>'+
    '<br />'+
    '<div class="autocomplete" id="feuilles_visugeod_propositions" style="display:none;"></div>'+
    '</td>'+
    '</tr>'+
    '<tr>'+
    '<td colspan="4">'+
    '<input style="margin-left:60px" type="checkbox" id="'+this.checkAllID+'" name="avec" value="avec" />'+
    '&nbsp;<span >Sélectionner tous les points.</span>'+
    '</td>'+
    '</tr>'+
    '<tr>'+
    '<td colspan="4">'+
    '<input style="margin-left:60px" type="checkbox" id="'+this.checkSiteID+'" name="avec_site" value="avec_site" />'+
    '&nbsp;<span >Sélectionner les sites.</span>'+
    '</td>'+
    '</tr>'+
    '<tr>'+
    '<td colspan="4">'+
    '<input style="margin-left:60px" type="checkbox" id="'+this.checkRNID+'" name="avec_rn" value="avec_rn" />'+
    '&nbsp;<span >Sélectionner les repères de nivellement.</span>'+
    '</td>'+
    '</tr>'+
    '<tr>'+
    '<td></td>'+
    '<td></td>'+
    '<td></td>'+
    '<td></td>'+
    '</tr>'+
    '</table>'+
    '</form>'+
    '</td>'+
    '</tr>'+
    '<tr>'+
    '<td>'+
    '<center>'+
    '<div class="MessBouton" id="'+this.cancelButtonID+'" style="display:block;">Annuler</div>'+
    '</center>'+
    '</td>'+
    '<td>'+
    '<center>'+
    '<div class="MessBouton" id="'+this.submitButtonID+'" style="display:block;">OK</div>'+
    '</center>'+
    '</td>'+
    '</tr>'+
    '</table>'+
    '</div>';

    // on utilise (pour l'instant) l'actuel code ...
    this.ident_site();
    this.ident_repere();
    this.ident_commune();
    this.ident_feuille();

    this.searchForm= OpenLayers.Util.getElement(this.searchFormID);
    this.repereField= OpenLayers.Util.getElement(this.repereID);
    this.siteField= OpenLayers.Util.getElement(this.siteID);
    this.eastingField= OpenLayers.Util.getElement(this.eastingID);
    this.northingField= OpenLayers.Util.getElement(this.northingID);
    this.nuts5Field= OpenLayers.Util.getElement(this.nuts5ID);
    this.sheet50Field= OpenLayers.Util.getElement(this.sheet50ID);
    this.cancelButton= OpenLayers.Util.getElement(this.cancelButtonID);
    this.submitButton= OpenLayers.Util.getElement(this.submitButtonID);

    this.checkAll= OpenLayers.Util.getElement(this.checkAllID);
    this.checkSite= OpenLayers.Util.getElement(this.checkSiteID);
    this.checkRN= OpenLayers.Util.getElement(this.checkRNID);

    OpenLayers.Event.observe(
      this.cancelButton,
      "click",
      OpenLayers.Function.bindAsEventListener(this.cancelButtonOnClick,this)
      );

    OpenLayers.Event.observe(
      this.submitButton,
      "click",
      OpenLayers.Function.bindAsEventListener(this.submitButtonOnClick,this)
      );

    this.checkAll.disabled= false;
    this.checkAll.checked= false;
    this.checkAll.defaultChecked= false;
    this.checkAll.style.autocomplete= "off";
    var cAll= {
      'elem':this.checkAll,
      'control':this
    };
    OpenLayers.Event.observe(
      this.checkAll,
      "mouseup",//FIXME click IE ne semble pas fonctionner?
      OpenLayers.Function.bindAsEventListener(this.selectPointOnClick,cAll)
      );

    this.checkSite.disabled= false;
    this.checkSite.checked= false;
    this.checkSite.defaultChecked= false;
    this.checkSite.style.autocomplete= "off";
    var cSite= {
      'elem':this.checkSite,
      'control':this
    };
    OpenLayers.Event.observe(
      this.checkSite,
      "mouseup",//FIXME click IE ne semble pas fonctionner?
      OpenLayers.Function.bindAsEventListener(this.selectPointOnClick,cSite)
      );

    this.checkRN.disabled= false;
    this.checkRN.checked= false;
    this.checkRN.defaultChecked= false;
    this.checkRN.style.autocomplete= "off";
    var cRN= {
      'elem':this.checkRN,
      'control':this
    };
    OpenLayers.Event.observe(
      this.checkRN,
      "mouseup",//FIXME click IE ne semble pas fonctionner?
      OpenLayers.Function.bindAsEventListener(this.selectPointOnClick,cRN)
      );
  },
  /**
             * APIMethod: redraw
             *  Builds the control to display search forms.
             *
             * Returns:
             * {DOMElement} A reference to the DIV DOMElement containing the
             * control
             */
  redraw: function() {
    return this.div;
  },
  /**
             * Method: ident_site
             * Set Ajax autocompletion on the relevant field.
             */
  ident_site: function() {
    var Ajax_ident_site= new Ajax.Autocompleter(
      // id du champ de formulaire
      "site_ajax",
      // id de l'élément utilisé pour les propositions
      "site_ajax_propositions",
      // URL du script côté serveur
      this.autoCompletionUrl,
      {
        method:'post',
        // Nom du paramètre reçu par le script serveur
        paramName: 'site_ajax',
        parameters: 'identifiant_visugeod=identificateur_site',
        // Nombre de caractères minimum avant que des appels serveur ne soient effectués
        minChars: 4,
        indicator: 'indicateur-chargement-site_ajax',
        afterUpdateElement: function (input, li) {
          // Fonction appelée après choix de l'utilisateur
          $('h_recherche').value= true;
        }
      });
  },
  /**
             * Method: ident_repere
             * Set Ajax autocompletion on the relevant field.
             */
  ident_repere: function() {
    var Ajax_ident_repere= new Ajax.Autocompleter(
      "repere_ajax",
      "repere_ajax_propositions",
      this.autoCompletionUrl,
      {
        method:'post',
        paramName: 'repere_ajax',
        parameters: 'identifiant_visugeod=identificateur_repere',
        minChars: 6,
        indicator: 'indicateur-chargement-repere_ajax',
        afterUpdateElement: function (input, li) {
          $('h_recherche').value= true;
        }
      });
  },
  /**
             * Method: ident_feuille
             * Set Ajax autocompletion on the relevant field.
             */
  ident_feuille: function() {
    var Ajax_ident_feuille= new Ajax.Autocompleter(
      "feuilles_visugeod",
      "feuilles_visugeod_propositions",
      this.autoCompletionUrl,
      {
        method:'post',
        paramName: 'feuilles_visugeod',
        parameters: 'identifiant_visugeod=identificateur_carte',
        minChars: 2,
        indicator: 'indicateur-chargement-feuilles_visugeod',
        afterUpdateElement: function (input, li) {
          $('h_recherche').value= true;
        }
      });
  },
  /**
             * Method: ident_commune
             * Set Ajax autocompletion on the relevant field.
             */
  ident_commune: function() {
    // Instanciation de la classe Autocompleter, pour le champ de saisie "org_cid"
    var Ajax_ident_commune= new Ajax.Autocompleter(
      "communes_visugeod",
      "communes_visugeod_propositions",
      this.autoCompletionUrl,
      {
        method:'post',
        paramName: 'communes_visugeod',
        parameters: 'identifiant_visugeod=identificateur',
        minChars: 5,
        indicator: 'indicateur-chargement-communes_visugeod',
        onLoad : function (){
          $('communes_visugeod').value= $('communes_visugeod').value.toUpperCase();
        },
        afterUpdateElement: function (input, li) {
          $('h_recherche').value= true;
        }
      }
      );
  },
  /**
             * Method: cancelButtonOnClick
             * Close the search form.
             *
             * Parameters:
             * evt - {Event}
             *
             * Returns:
             * {Boolean} false
             */
  cancelButtonOnClick: function(evt) {
    this.searchForm.reset();
    this.deactivate();
    return false;
  },
  /**
             * Method: submitButtonOnClick
             * Apply and close the search form.
             *
             * Parameters:
             * evt - {Event}
             *
             * Returns:
             * {Boolean} false
             */
  submitButtonOnClick: function(evt) {
    var body= '';
    var h= $('h_recherche').value;
    var p= this.repereField.value;//D'.BD - 59
    // Send request :
    if (body=='' && p!='' && p!='Pas de résultat' && h=='true') {
      p= p.replace(/^[^-]*([^ ])-([^ ]).*$/,"$1 - $2").
      replace(/^[^-]*([^ ])-.*$/,"$1 -").
      replace(/^[^-]*-([^ ]).*$/,"- $1").
      replace(/'/g,"''");
      body= 'h_recherche='+encodeURIComponent('repere|'+p)+'&';
    }
    p= this.siteField.value;//3720801
    if (body=='' && p!='' && p!='Pas de résultat' && h=='true') {
      body= 'h_recherche='+encodeURIComponent('sit|'+p)+'&';
    }
    if (body=='' && this.eastingField.value!='' &&
      (parseFloat(this.eastingField.value,10)==(this.eastingField.value*1)) &&
      this.northingField.value!='' &&
      (parseFloat(this.northingField.value,10)==(this.northingField.value*1))) {
      // 639713 6641123
      var en= new OpenLayers.LonLat(this.eastingField.value*1, this.northingField.value*1);
      var cntrl= viewer.getVariable('crsCntrl');
      var crs= cntrl.allowedDisplayProjections[0];
      en.transform(crs, viewer.getMap().getProjection());
      if (viewer.getMap().getMaxExtent({
        restricted:true
      }).containsLonLat(en)) {
        viewer.getMap().setCenter(en,(viewer.getMap().baseLayer.maxZoomLevel>13? 14:13));//~25000
      }
      this.cancelButtonOnClick(evt);
      return false;
    }
    p= this.nuts5Field.value;//commune - insee
    if (body=='' && p!='' && p!='Pas de résultat' && h=='true') {
      body= 'h_recherche='+encodeURIComponent('commune|'+p+
        (this.checkAll.checked?
          '|avec'
          : (this.checkSite.checked?
            '|avec_site'
            : (this.checkRN.checked?
              '|avec_rn'
              :   ''))))+'&';
    }
    p= this.sheet50Field.value;//carte_no - carte_nom
    if (body=='' && p!='' && p!='Pas de résultat' && h=='true') {
      body= 'h_recherche='+encodeURIComponent('feuille|'+p+
        (this.checkAll.checked?
          '|avec'
          : (this.checkSite.checked?
            '|avec_site'
            : (this.checkRN.checked?
              '|avec_rn'
              :   ''))))+'&';
    }
    if (body=='' || h=='false') {
      alert("Vous n'avez rien saisi ou vous n'avez pas choisi un élément de la liste");
      return false;
    }
    body+= 't='+getGeodesyTerritory(viewer.territory)+'&';
    body= body.replace(/&$/,'');
    var postOptions= {
      url:this.searchUrl,
      async:true,
      headers:{
        "Content-type":"application/x-www-form-urlencoded"
      },
      callback:function(){},
      success:this.searchOk,
      failure:this.searchKo,
      scope:this
    };
    var searchRqst= OpenLayers.Request.POST(
      OpenLayers.Util.applyDefaults({
        'data':body
      },postOptions));
    body= null;
    postOptions= null;
    return false;
  },
  /**
             * Method: searchKo
             * Called when the Ajax request fails.
             *
             * Parameters:
             * request - {XmlNode} request to server
             */
  searchKo: function(request) {
    alert('Echec lors de la recherche.');//FIXME
    this.cancelButtonOnClick();
  },
  /**
             * Method: searchOk
             * Called when the Ajax request returns a response.
             *
             * Parameters:
             * request - {XmlNode} request to server
             */
  searchOk: function(request) {
    if (!request) {
      alert("Echec à l'appel du service de recherche.");//FIXME
      return;
    }
    var response= request.responseText.split(/[\r\n]/)[0];
    if (response==='1') {
      this.searchKo(request);
      return;
    }//alert(response);
    var bbox= new OpenLayers.Bounds();
    var features= [];
    var nbFeatures= this.layer.features.length || 0;
    var objs= response.split('£');
    //debut des modifs
    var ecart = 0.02;//0.02 degrés décimaux = ecart estimé (par moi) pour avoir une emprise correcte pour la vue d'un site ou rn
    var flds_1= objs[0].split('|');
    if((flds_1[0] != "") || (flds_1[0] == "" && objs[1] && objs[1] != "")){
      if(flds_1[0] == "" && objs[1] && objs[1] != "")
        flds_1 = objs[1].split('|');
      var g= OpenLayers.Geometry.fromWKT('POINT('+flds_1[0]+')');
      bbox.extend(g);
      var l= objs.length;
      var absence_coord = false;//on suppose qu'il y a toujours des coordonnées pour une commune ou feuille
      if(!flds_1[5] || l==1){//recherche de feuille ou carte sans points, ou alors recherche de sit ou rn
        if(!flds_1[5]){//recherche de commune ou feuille
          ecart = 0.04;//0.07 degrés décimaux  = ecart estimé (par moi) pour avoir une emprise correcte pour la vue d'une commune ou feuille
        }
        //on retaille la carte
        var coord = flds_1[0].split(' ');
        var coin_gauche = coord[0]-ecart;
        var coin_droit = coord[0]-(-ecart);
        var coin_bas = coord[1]-ecart;
        var coin_haut = coord[1]-(-ecart);
        var h_g= OpenLayers.Geometry.fromWKT('POINT('+coin_gauche+' '+coin_bas+')');
        bbox.extend(h_g);
        h_g= OpenLayers.Geometry.fromWKT('POINT('+coin_gauche+' '+coin_haut+')');
        bbox.extend(h_g);
        h_g= OpenLayers.Geometry.fromWKT('POINT('+coin_droit+' '+coin_bas+')');
        bbox.extend(h_g);
        h_g= OpenLayers.Geometry.fromWKT('POINT('+coin_droit+' '+coin_haut+')');
        bbox.extend(h_g);
      }
      else{
        if(flds_1[5] && l>1)//cas d'une commune ou feuille sans coordonnées
          absence_coord = true;
      }
    }
				
    for (var i= 0; i<l; i++) {
      //          0|  1|  2|  3|        4|5|6|       7|   8|   9|                10
      // Lambda phi|url|nom|cid|matricule|e|n|altitude|etat|triplet_info|affichage_priorite
      // mimic WFS :
      var flds= objs[i].split('|');
      if(flds[0] != ""){
        g= OpenLayers.Geometry.fromWKT('POINT('+flds[0]+')');
        if(absence_coord ===true){//pas de coordonnées pour la commune ou feuille, donc on prend tous les points
          bbox.extend(g);
        }
      }
      if(flds[5]){//si flds[5] alors = recherche de rn ou sit
        var _nom= 'sit_nom';
        if (flds.length==11 && flds[10] && flds[10]!=50000) {
          _nom= 'nom';
        }
       // alert(document.getElementById('repere_ajax').value);
        var value_rn = document.getElementById('repere_ajax').value;
        var value_site = document.getElementById('site_ajax').value;
        if((this.checkSite.checked && _nom=='sit_nom') || (this.checkRN.checked && _nom=='nom') || value_rn!="" || value_site!=""){
          var as= {
            'url' : flds[1],
            'cid' : flds[3],
            'nom' : flds[4],
            'e'   : flds[5],
            'n'   : flds[6],
            'type': flds[7],
            'etat': flds[8]
          };
          as[_nom]= flds[2];//sit_nom||nom
          if (_nom=='nom') {
            as['type']= 'rn';
            as['matricule']= flds[4];
            as['altitude']= flds[7];
            as['triplet_info']= flds[9];
            as['affichage_priorite']= flds[10];
          }
          var feature= new OpenLayers.Feature.Vector(g.transform(OpenLayers.Projection.CRS84,this.map.getProjection()),as);
          
          //Rajout de 'Type' afin que les points soient sélectionnés. Modif Mathieu 16/07/2010
          feature.fid= (_nom=='sit_nom'? 'sit_'+(as['type']=='RBG'||as['type']=='RBM'||as['type']=='RBR'||as['type']=='RRF'||as['type']=='RBF'? 'rbfType':'rdfType') : 'rnType')+'.'+flds[3];
          if (_nom=='sit_nom' || _nom=='nom') {
            if (nbFeatures<1000) {
              var found= false;
              for (var ii= 0, il= this.layer.features.length; ii<il; ii++) {
                var f= this.layer.features[ii];
                if (feature.fid===f.fid) {
                  found= true;
                  break;
                }
              }
              if (found) {
                continue;
              }
              // add feature to pre-basket :
              nbFeatures++;
              features.push(feature);
            }
            else {
              alert('Trop de sites sélectionnés, seuls les premiers sont mis dans le panier !');
              break;
            }
          }
        }
      }
    }
    if (features.length>0) {
      // add features to basket now :
      this.basket.addFeatures(features);//ajoute dans le panier. C'est le panier qui affiche le point selectionné!
    }
    bbox.transform(OpenLayers.Projection.CRS84,this.map.getProjection(),true);
    this.map.zoomToExtent(bbox);
    this.cancelButtonOnClick();
  },
  /*   searchOk: function(request) {
                if (!request) {
                    alert("Echec à l'appel du service de recherche.");//FIXME
                    return;
                }
                var response= request.responseText.split(/[\r\n]/)[0];
                if (response==='1') {
                    this.searchKo(request);
                    return;
                }
                var bbox= new OpenLayers.Bounds();
                var features= [];
                var nbFeatures= this.layer.features.length || 0;
                var objs= response.split('£');
                var ecart = 0.02;
                for (var i= 0, l= objs.length; i<l; i++) {
                    //          0|  1|  2|  3|        4|5|6|       7|   8|   9|                10
                    // Lambda phi|url|nom|cid|matricule|e|n|altitude|etat|triplet_info|affichage_priorite
                    var flds= objs[i].split('|');
                    var g= OpenLayers.Geometry.fromWKT('POINT('+flds[0]+')');
                    bbox.extend(g);
          if(l==1){//recherche de rn,site ou commune,feuille ne possédant pas de points
            if(!flds[5]){//recherche de commune ou feuille
              ecart = 0.07;
            }
            //on retaille la carte
            var coord = flds[0].split(' ');
            var coin_gauche = coord[0]-ecart;
            var coin_droit = coord[0]-(-ecart);
            var coin_bas = coord[1]-ecart;
            var coin_haut = coord[1]-(-ecart);
            var h_g= OpenLayers.Geometry.fromWKT('POINT('+coin_gauche+' '+coin_bas+')');
            bbox.extend(h_g);
            h_g= OpenLayers.Geometry.fromWKT('POINT('+coin_gauche+' '+coin_haut+')');
            bbox.extend(h_g);
            h_g= OpenLayers.Geometry.fromWKT('POINT('+coin_droit+' '+coin_bas+')');
            bbox.extend(h_g);
            h_g= OpenLayers.Geometry.fromWKT('POINT('+coin_droit+' '+coin_haut+')');
            bbox.extend(h_g);
          }
                    // mimic WFS :
                    if(((this.checkSite.checked || this.checkRN.checked) && flds[5]) || (l==1 && flds[5])){
            var _nom= 'sit_nom';
            if (flds.length==11 && flds[10] && flds[10]!=50000) { _nom= 'nom'; }
            var as= {
              'url' : flds[1],
              'cid' : flds[3],
              'nom' : flds[4],
              'e'   : flds[5],
              'n'   : flds[6],
              'type': flds[7],
              'etat': flds[8]
            };
            as[_nom]= flds[2];//sit_nom||nom
            if (_nom=='nom') {
              as['type']= 'rn';
              as['matricule']= flds[4];
              as['altitude']= flds[7];
              as['triplet_info']= flds[9];
              as['affichage_priorite']= flds[10];
            }
            var feature= new OpenLayers.Feature.Vector(g.transform(OpenLayers.Projection.CRS84,this.map.getProjection()),as);
            //Rajout de 'Type' afin que les points soient sélectionnés. Modif Mathieu 16/07/2010
            feature.fid= (_nom=='sit_nom'? 'sit_'+(as['type']=='RRF'||as['type']=='RBF'? 'rbfType':'rdfType') : 'rnType')+'.'+flds[3];
            if (_nom=='sit_nom' || _nom=='nom') {
              if (nbFeatures<1000) {
                var found= false;
                for (var ii= 0, il= this.layer.features.length; ii<il; ii++) {
                  var f= this.layer.features[ii];
                  if (feature.fid===f.fid) {
                    found= true;
                    break;
                  }
                }
                if (found) { continue; }
                // add feature to pre-basket :
                nbFeatures++;
                features.push(feature);
              } else {
                alert('Trop de sites sélectionnés, seuls les premiers sont mis dans le panier !');
                break;
              }
            }
          }
                }
                if (features.length>0) {
                    // add features to basket now :
                    this.basket.addFeatures(features);//ajoute dans le panier. C'est le panier qui affiche le point selectionné!
                }
                bbox.transform(OpenLayers.Projection.CRS84,this.map.getProjection(),true);
                this.map.zoomToExtent(bbox);
                this.cancelButtonOnClick();
            },*/
  /**
             * Method: selectPointOnClick
             * Select/Unselect point.
             *
             * Parameters:
             * evt - {Event}
             *
             * Context:
             *      * elem - {DOMElement} the DOM element the event came from
             *      * control - {<Geoportal.Control.GeodesySearches>}
             */
  selectPointOnClick: function(evt) {
    // mouseup => not yet click, revert checked value !!!
    if (this.elem===this.control.checkAll) {
      this.control.checkSite.checked= this.control.checkRN.checked= !this.elem.checked;
    } else {
      this.control.checkAll.checked=
      !this.elem.checked===true &&
      (this.elem===this.control.checkSite?
        this.control.checkRN.checked===true
        :   this.control.checkSite.checked===true);
    }
    this.elem.blur();
    return false;
  },
  CLASS_NAME: 'Geoportal.Control.GeodesySearches'
});

