/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tag2link;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.plugins.tag2link.Tag2LinkConstants;
import org.openstreetmap.josm.plugins.tag2link.data.Link;
import org.openstreetmap.josm.plugins.tag2link.data.Rule;
import org.openstreetmap.josm.plugins.tag2link.data.Source;
import org.openstreetmap.josm.plugins.tag2link.io.SourcesReader;

public class Tag2LinkRuleChecker
implements Tag2LinkConstants {
    private static Collection<Source> sources = new ArrayList<Source>();
    private static boolean initialized = false;

    public static void init() {
        if (!initialized) {
            sources = SourcesReader.readSources();
            initialized = true;
        }
    }

    private static String findValue(String arg, Collection<Rule.MatchingTag> matchingTags) {
        for (Rule.MatchingTag tag : matchingTags) {
            if (!tag.params.containsKey(arg)) continue;
            return tag.params.get(arg);
        }
        return null;
    }

    private static Collection<Link> processEval(Rule.EvalResult eval, Rule rule, Source source) {
        ArrayList<Link> result = new ArrayList<Link>();
        if (eval.matches()) {
            for (Link link : rule.links) {
                Link copy = new Link(link);
                copy.name = copy.name.replaceAll("%name%", source.name);
                Matcher m = Pattern.compile("%([^%]*)%").matcher(copy.url);
                while (m.find()) {
                    Matcher lm;
                    String arg = m.group(1);
                    String val = Tag2LinkRuleChecker.findValue(arg, eval.matchingTags);
                    if (val == null && arg.contains(":")) {
                        String[] vars = arg.split(":");
                        int i = 0;
                        while (val == null && i < vars.length - 1) {
                            val = Tag2LinkRuleChecker.findValue(vars[i], eval.matchingTags);
                            ++i;
                        }
                        if (val == null) {
                            val = vars[vars.length - 1];
                        }
                    }
                    if (val == null && (lm = Pattern.compile("lang(?:\\(\\p{Lower}{2,}(?:,\\p{Lower}{2,})*\\))?(?::(\\p{Lower}{2,}))?").matcher(arg)).matches()) {
                        lm.groupCount();
                    }
                    if (val != null) {
                        try {
                            if (copy.url.contains("wikipedia.")) {
                                val = val.replaceAll(" ", "_");
                            }
                            if (!m.group().equals(copy.url)) {
                                val = URLEncoder.encode(val, "UTF-8");
                            }
                            copy.url = copy.url.replaceFirst(m.group(), val);
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    System.err.println("Invalid argument: " + arg);
                }
                result.add(copy);
            }
        }
        return result;
    }

    public static Collection<Link> getLinks(IPrimitive p) {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Source source : sources) {
            for (Rule rule : source.rules) {
                result.addAll(Tag2LinkRuleChecker.processEval(rule.evaluates(p), rule, source));
            }
        }
        return result;
    }

    public static Collection<Link> getLinks(Tag tag) {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Source source : sources) {
            for (Rule rule : source.rules) {
                result.addAll(Tag2LinkRuleChecker.processEval(rule.evaluates(tag), rule, source));
            }
        }
        return result;
    }
}

