/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tag2link.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.plugins.tag2link.Tag2LinkConstants;
import org.openstreetmap.josm.plugins.tag2link.data.Condition;
import org.openstreetmap.josm.plugins.tag2link.data.Link;
import org.openstreetmap.josm.plugins.tag2link.data.Rule;
import org.openstreetmap.josm.plugins.tag2link.data.Source;
import org.openstreetmap.josm.tools.I18n;

public class SourcesReader
implements Tag2LinkConstants {
    XMLStreamReader parser;

    public SourcesReader(XMLStreamReader parser) {
        this.parser = parser;
    }

    public static Collection<Source> readSources() {
        ArrayList<Source> result = new ArrayList<Source>();
        try {
            InputStream is = SourcesReader.class.getResourceAsStream("/resources/tag2link_sources.xml");
            UTFInputStreamReader ir = UTFInputStreamReader.create((InputStream)is, (String)"UTF-8");
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader((Reader)ir);
            result.addAll(new SourcesReader(parser).parseDoc());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
        return result;
    }

    private void jumpToEnd(boolean printWarning) throws XMLStreamException {
        while (true) {
            int event;
            if ((event = this.parser.next()) == 1) {
                this.parseUnknown(printWarning);
                continue;
            }
            if (event == 2) break;
        }
    }

    private void jumpToEnd() throws XMLStreamException {
        this.jumpToEnd(true);
    }

    protected void parseUnknown() throws XMLStreamException {
        this.parseUnknown(true);
    }

    protected void parseUnknown(boolean printWarning) throws XMLStreamException {
        if (printWarning) {
            System.out.println(I18n.tr((String)"Undefined element ''{0}'' found in input stream. Skipping.", (Object[])new Object[]{this.parser.getLocalName()}));
        }
        while (this.parser.hasNext()) {
            int event = this.parser.next();
            if (event == 1) {
                this.parseUnknown(false);
                continue;
            }
            if (event != 2) continue;
            return;
        }
    }

    private Collection<Source> parseDoc() throws XMLStreamException {
        ArrayList<Source> result = new ArrayList<Source>();
        while (this.parser.hasNext()) {
            int event = this.parser.next();
            if (event == 1) {
                if (this.parser.getLocalName().equals("tag2link")) {
                    result.addAll(this.parseRoot());
                    continue;
                }
                this.parseUnknown();
                continue;
            }
            if (event == 2) break;
        }
        return result;
    }

    private Collection<Source> parseRoot() throws XMLStreamException {
        ArrayList<Source> result = new ArrayList<Source>();
        while (this.parser.hasNext()) {
            int event = this.parser.next();
            if (event == 1) {
                if (this.parser.getLocalName().equals("source")) {
                    result.add(this.parseSource());
                    continue;
                }
                this.parseUnknown();
                continue;
            }
            if (event == 2) break;
        }
        return result;
    }

    private Source parseSource() throws XMLStreamException {
        Source source = new Source(this.parser.getAttributeValue(null, "name"));
        while (this.parser.hasNext()) {
            int event = this.parser.next();
            if (event == 1) {
                if (this.parser.getLocalName().equals("rule")) {
                    source.rules.add(this.parseRule());
                    continue;
                }
                this.parseUnknown();
                continue;
            }
            if (event == 2) break;
        }
        return source;
    }

    private Rule parseRule() throws XMLStreamException {
        Rule rule = new Rule();
        while (this.parser.hasNext()) {
            int event = this.parser.next();
            if (event == 1) {
                if (this.parser.getLocalName().equals("condition")) {
                    rule.conditions.add(this.parseCondition());
                    continue;
                }
                if (this.parser.getLocalName().equals("link")) {
                    rule.links.add(this.parseLink());
                    continue;
                }
                this.parseUnknown();
                continue;
            }
            if (event == 2) break;
        }
        return rule;
    }

    private Condition parseCondition() throws XMLStreamException {
        Condition c = new Condition();
        c.keyPattern = Pattern.compile(this.parser.getAttributeValue(null, "k"));
        String v = this.parser.getAttributeValue(null, "v");
        if (v != null) {
            c.valPattern = Pattern.compile(v);
        }
        c.id = this.parser.getAttributeValue(null, "id");
        this.jumpToEnd();
        return c;
    }

    private Link parseLink() throws XMLStreamException {
        Link link = new Link(this.parser.getAttributeValue(null, "name"), this.parser.getAttributeValue(null, "href"));
        this.jumpToEnd();
        return link;
    }
}

