/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tag2link.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.plugins.tag2link.data.Condition;
import org.openstreetmap.josm.plugins.tag2link.data.Link;

public class Rule {
    public final Collection<Condition> conditions = new ArrayList<Condition>();
    public final Collection<Link> links = new ArrayList<Link>();

    public EvalResult evaluates(Map<String, String> tags) {
        EvalResult result = new EvalResult();
        for (Condition c : this.conditions) {
            for (String key : tags.keySet()) {
                Matcher keyMatcher = c.keyPattern.matcher(key);
                if (!keyMatcher.matches()) continue;
                String idPrefix = c.id == null ? "" : String.valueOf(c.id) + ".";
                MatchingTag tag = new MatchingTag(key, tags.get(key), idPrefix);
                tag.addParams(keyMatcher, "k");
                boolean matchingTag = true;
                if (c.valPattern != null) {
                    Matcher valMatcher = c.valPattern.matcher(tag.value);
                    if (valMatcher.matches()) {
                        tag.addParams(valMatcher, "v");
                    } else {
                        matchingTag = false;
                    }
                }
                if (!matchingTag) continue;
                result.matchingTags.add(tag);
            }
        }
        return result;
    }

    public EvalResult evaluates(IPrimitive p) {
        return this.evaluates(p.getKeys());
    }

    public EvalResult evaluates(Tag tag) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(tag.getKey(), tag.getValue());
        return this.evaluates(map);
    }

    public static class EvalResult {
        public final Collection<MatchingTag> matchingTags = new ArrayList<MatchingTag>();

        public boolean matches() {
            return !this.matchingTags.isEmpty();
        }
    }

    public static class MatchingTag {
        public String key;
        public String value;
        public final Map<String, String> params;
        private String prefix;

        public MatchingTag(String key, String value, String prefix) {
            this.key = key;
            this.value = value;
            this.params = new HashMap<String, String>();
            this.prefix = prefix;
            this.addKeyValueParams();
        }

        public void addParams(Matcher m, String paramName) {
            int i = 1;
            while (i <= m.groupCount()) {
                this.params.put(String.valueOf(this.prefix) + paramName + "." + i, m.group(i));
                ++i;
            }
        }

        private void addKeyValueParams() {
            this.params.put("k", this.key);
            this.params.put("v", this.value);
            if (!this.prefix.isEmpty()) {
                this.params.put(String.valueOf(this.prefix) + "k", this.key);
                this.params.put(String.valueOf(this.prefix) + "v", this.value);
            }
        }
    }
}

