/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.columbusCSV;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.ImmutableGpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.plugins.columbusCSV.ColumbusCSVPreferences;
import org.openstreetmap.josm.plugins.columbusCSV.ColumbusCSVUtils;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumbusCSVReader {
    public static final String AUDIO_WAV_LINK = "audio/wav";
    private static final String VDOP_TAG = "vdop";
    private static final String HDOP_TAG = "hdop";
    private static final String PDOP_TAG = "pdop";
    private static final String ELEVATIONHEIGHT_TAG = "ele";
    private static final String TIME_TAG = "time";
    private static final String COMMENT_TAG = "cmt";
    private static final String DESC_TAG = "desc";
    private static final String FIX_TAG = "fix";
    private static final String TYPE_TAG = "columbus:type";
    private static String[] EMPTY_LINE = new String[0];
    private static final String SEPS = ",";
    private int dopConversionErrors = 0;
    private int dateConversionErrors = 0;
    private int firstVoxNumber = -1;
    private int lastVoxNumber = -1;
    private HashMap<String, WayPoint> voxFiles = new HashMap();
    private Collection<Collection<WayPoint>> allTrackPts = new ArrayList<Collection<WayPoint>>();
    private List<WayPoint> trackPts = new ArrayList<WayPoint>();
    private List<WayPoint> allWpts = new ArrayList<WayPoint>();
    private String fileDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GpxData transformColumbusCSV(String fileName) throws IOException, IllegalDataException {
        if (fileName == null || fileName.length() == 0) {
            throw new IllegalArgumentException("File name must not be null or empty");
        }
        GpxData gpxData = new GpxData();
        File f = new File(fileName);
        this.fileDir = f.getParent();
        FileInputStream fstream = new FileInputStream(fileName);
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        int line = 1;
        this.initImport();
        this.dropBufferLists();
        int waypts = 0;
        int trkpts = 0;
        int audiopts = 0;
        int missaudio = 0;
        int rescaudio = 0;
        try {
            String strLine;
            while ((strLine = br.readLine()) != null) {
                String[] csvFields = this.getCSVLine(strLine);
                if (csvFields.length == 0 || line <= 1) {
                    ++line;
                    continue;
                }
                try {
                    WayPoint wpt = this.createWayPoint(csvFields, this.fileDir);
                    String wptType = (String)wpt.attr.get(TYPE_TAG);
                    String oldWptType = csvFields[1];
                    if ("T".equals(wptType)) {
                        this.trackPts.add(wpt);
                        ++trkpts;
                    } else {
                        if (!wptType.equals(oldWptType)) {
                            if ("V".equals(oldWptType)) {
                                ++missaudio;
                            }
                            if ("C".equals(oldWptType)) {
                                ++rescaudio;
                            }
                        } else if ("V".equals(wptType)) {
                            ++audiopts;
                        }
                        gpxData.waypoints.add(wpt);
                        ++waypts;
                    }
                    this.allWpts.add(wpt);
                    wpt.attr.remove(TYPE_TAG);
                }
                catch (Exception ex) {
                    throw new IllegalDataException(I18n.tr((String)("Error in line " + line + ": " + ex.toString())));
                }
                ++line;
            }
        }
        finally {
            in.close();
        }
        assert (this.trackPts.size() == trkpts);
        assert (gpxData.waypoints.size() == waypts);
        assert (this.firstVoxNumber <= this.lastVoxNumber);
        rescaudio += this.searchForLostAudioFiles(gpxData);
        this.allTrackPts.add(this.trackPts);
        ImmutableGpxTrack trk = new ImmutableGpxTrack(this.allTrackPts, Collections.emptyMap());
        gpxData.tracks.add(trk);
        assert (gpxData.routes.size() == 1);
        if (ColumbusCSVPreferences.warnConversion() && (this.dateConversionErrors > 0 || this.dopConversionErrors > 0)) {
            String message = String.format("%d date conversion faults and %d DOP conversion errors", this.dateConversionErrors, this.dopConversionErrors);
            ColumbusCSVUtils.showWarningMessage(I18n.tr((String)message));
        }
        if (ColumbusCSVPreferences.showSummary()) {
            this.showSummary(waypts, trkpts, audiopts, missaudio, rescaudio);
        }
        String desc = String.format("Converted by ColumbusCSV plugin from track file '%s'", f.getName());
        gpxData.attr.put("meta.desc", desc);
        gpxData.storageFile = f;
        return gpxData;
    }

    private int searchForLostAudioFiles(GpxData gpx) {
        HashMap<String, WayPoint> voxFiles = this.getVoxFileMap();
        int first = this.getFirstVoxNumber();
        int last = this.getLastVoxNumber();
        int rescuedFiles = 0;
        for (int i = first; i < last; ++i) {
            String voxFile = String.format("vox%05d.wav", i);
            String nextVoxFile = String.format("vox%05d.wav", i + 1);
            if (voxFiles.containsKey(voxFile)) continue;
            System.out.println("Found lost vox file " + voxFile);
            File f = this.getVoxFilePath(voxFile);
            WayPoint nearestWpt = null;
            List<WayPoint> wpts = this.getAllWayPoints();
            if (voxFiles.containsKey(nextVoxFile)) {
                WayPoint nextWpt = voxFiles.get(nextVoxFile);
                int idx = this.getAllWayPoints().indexOf(nextWpt) - 5;
                nearestWpt = idx >= 0 ? wpts.get(idx) : wpts.get(0);
            } else {
                nearestWpt = wpts.get(wpts.size() - 1);
            }
            if (nearestWpt == null) continue;
            if (this.addLinkToWayPoint(nearestWpt, "*" + voxFile + "*", f)) {
                System.out.println(String.format("Linked file %s to position %s", voxFile, nearestWpt.getCoor().toDisplayString()));
                gpx.waypoints.add(nearestWpt);
                ++rescuedFiles;
                continue;
            }
            System.err.println(String.format("Could not link vox file %s due to invalid parameters.", voxFile));
        }
        return rescuedFiles;
    }

    private void initImport() {
        this.dateConversionErrors = 0;
        this.dopConversionErrors = 0;
        this.firstVoxNumber = Integer.MAX_VALUE;
        this.lastVoxNumber = Integer.MIN_VALUE;
    }

    void dropBufferLists() {
        this.allTrackPts.clear();
        this.trackPts.clear();
        this.voxFiles.clear();
    }

    private void showSummary(int waypts, int trkpts, int audiopts, int missaudio, int rescaudio) {
        String message = "";
        message = missaudio > 0 ? String.format("Imported %d track points and %d way points (%d with audio, %d rescued).\nNote: %d audio files could not be found, please check marker comments!", trkpts, waypts, audiopts, rescaudio, missaudio) : String.format("Imported %d track points and %d way points (%d with audio, %d rescued).", trkpts, waypts, audiopts, rescaudio);
        ColumbusCSVUtils.showInfoMessage(I18n.tr((String)message));
    }

    private WayPoint createWayPoint(String[] csvLine, String fileDir) throws IOException {
        if (csvLine.length != 10 && csvLine.length != 15) {
            throw new IOException("Invalid number of tokens: " + csvLine.length);
        }
        boolean isExtMode = csvLine.length > 10;
        String lat = csvLine[4];
        double latVal = Double.parseDouble(lat.substring(0, lat.length() - 1));
        if (lat.endsWith("S")) {
            latVal = -latVal;
        }
        String lon = csvLine[5];
        double lonVal = Double.parseDouble(lon.substring(0, lon.length() - 1));
        if (lon.endsWith("W")) {
            lonVal = -lonVal;
        }
        LatLon pos = new LatLon(latVal, lonVal);
        WayPoint wpt = new WayPoint(pos);
        wpt.attr.put(TYPE_TAG, csvLine[1]);
        String voxFile = null;
        voxFile = isExtMode ? csvLine[14] + ".wav" : csvLine[9] + ".wav";
        if (!ColumbusCSVUtils.isStringNullOrEmpty(voxFile)) {
            File file = this.getVoxFilePath(fileDir, voxFile);
            if (file != null && file.exists()) {
                int voxNum = this.getNumberOfVoxfile(voxFile);
                this.lastVoxNumber = Math.max(voxNum, this.lastVoxNumber);
                this.firstVoxNumber = Math.min(voxNum, this.firstVoxNumber);
                this.addLinkToWayPoint(wpt, voxFile, file);
                if (!"V".equals(csvLine[1])) {
                    System.out.println("Rescued unlinked audio file " + voxFile);
                }
                this.voxFiles.put(voxFile, wpt);
                wpt.attr.put(TYPE_TAG, "V");
            } else {
                System.err.println("File " + voxFile + " not found!");
                String warnMsg = I18n.tr((String)"Missing audio file") + ": " + voxFile;
                System.err.println(warnMsg);
                if (ColumbusCSVPreferences.warnMissingAudio()) {
                    ColumbusCSVUtils.showInfoMessage(warnMsg);
                }
                wpt.attr.put(COMMENT_TAG, warnMsg);
                wpt.attr.put(TYPE_TAG, "C");
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd/HHmmss");
        Date d = null;
        try {
            d = sdf.parse(csvLine[2] + "/" + csvLine[3]);
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            wpt.attr.put(TIME_TAG, f.format(d).toString());
            wpt.setTime();
        }
        catch (ParseException ex) {
            ++this.dateConversionErrors;
            System.err.println(ex);
        }
        wpt.attr.put(ELEVATIONHEIGHT_TAG, csvLine[6]);
        if (isExtMode && !ColumbusCSVPreferences.ignoreDOP()) {
            this.addExtendedGPSData(csvLine, wpt);
        }
        return wpt;
    }

    public File getVoxFilePath(String voxFile) {
        return this.getVoxFilePath(this.getWorkingDirOfImport(), voxFile);
    }

    public File getVoxFilePath(String fileDir, String voxFile) {
        String[] fileNameVariants = new String[]{voxFile, voxFile.toLowerCase(), voxFile.toUpperCase()};
        for (int i = 0; i < fileNameVariants.length; ++i) {
            System.out.println("Probing " + fileNameVariants[i]);
            File file = new File(fileDir + File.separator + fileNameVariants[i]);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    private void addExtendedGPSData(String[] csvLine, WayPoint wpt) {
        wpt.attr.put(FIX_TAG, csvLine[9].toLowerCase());
        Float f = ColumbusCSVUtils.floatFromString(csvLine[11]);
        if (f.floatValue() != Float.NaN) {
            wpt.attr.put(PDOP_TAG, f);
        } else {
            ++this.dopConversionErrors;
        }
        f = ColumbusCSVUtils.floatFromString(csvLine[12]);
        if (f.floatValue() != Float.NaN) {
            wpt.attr.put(HDOP_TAG, f);
        } else {
            ++this.dopConversionErrors;
        }
        f = ColumbusCSVUtils.floatFromString(csvLine[13]);
        if (f.floatValue() != Float.NaN) {
            wpt.attr.put(VDOP_TAG, f);
        } else {
            ++this.dopConversionErrors;
        }
    }

    public boolean addLinkToWayPoint(WayPoint wpt, String voxFile, File file) {
        if (file == null || wpt == null || voxFile == null) {
            return false;
        }
        GpxLink lnk = new GpxLink(file.toURI().toString());
        lnk.type = AUDIO_WAV_LINK;
        lnk.text = voxFile;
        ArrayList<GpxLink> linkList = new ArrayList<GpxLink>(1);
        linkList.add(lnk);
        wpt.attr.put("meta.links", linkList);
        wpt.attr.put(COMMENT_TAG, "Audio recording");
        wpt.attr.put(DESC_TAG, voxFile);
        return true;
    }

    private String[] getCSVLine(String line) {
        if (line == null || line.length() == 0) {
            return EMPTY_LINE;
        }
        StringTokenizer st = new StringTokenizer(line, SEPS, false);
        int n = st.countTokens();
        String[] res = new String[n];
        for (int i = 0; i < n; ++i) {
            res[i] = st.nextToken().trim();
        }
        return res;
    }

    private int getNumberOfVoxfile(String fileName) {
        if (fileName == null) {
            return -1;
        }
        try {
            String num = fileName.substring(3);
            int val = Integer.parseInt(num);
            return val;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public int getNumberOfDateConversionErrors() {
        return this.dateConversionErrors;
    }

    public int getNumberOfDOPConversionErrors() {
        return this.dopConversionErrors;
    }

    public int getFirstVoxNumber() {
        return this.firstVoxNumber;
    }

    public int getLastVoxNumber() {
        return this.lastVoxNumber;
    }

    public HashMap<String, WayPoint> getVoxFileMap() {
        return this.voxFiles;
    }

    public List<WayPoint> getAllWayPoints() {
        return this.allWpts;
    }

    public String getWorkingDirOfImport() {
        return this.fileDir;
    }
}

