/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.IndexColorModel;

public abstract class ImageModifier {
    private static final long serialVersionUID = 1L;
    protected int parcelColor = Color.RED.getRGB();
    public BufferedImage bufferedImage;
    public static int[] cRoofColors = new int[]{-197380, -592138};
    public static int[] cBuilingFootColors = new int[]{-256};

    protected BufferedImage convert1(BufferedImage src) {
        byte[] byArray = new byte[2];
        byArray[1] = -1;
        byte[] byArray2 = new byte[2];
        byArray2[1] = -1;
        byte[] byArray3 = new byte[2];
        byArray3[1] = -1;
        IndexColorModel icm = new IndexColorModel(1, 2, byArray, byArray2, byArray3);
        BufferedImage dest = new BufferedImage(src.getWidth(), src.getHeight(), 12, icm);
        ColorConvertOp cco = new ColorConvertOp(src.getColorModel().getColorSpace(), dest.getColorModel().getColorSpace(), null);
        cco.filter(src, dest);
        return dest;
    }

    protected BufferedImage convert4(BufferedImage src) {
        int[] nArray = new int[16];
        nArray[1] = 0x800000;
        nArray[2] = 32768;
        nArray[3] = 0x808000;
        nArray[4] = 128;
        nArray[5] = 0x800080;
        nArray[6] = 32896;
        nArray[7] = 0x808080;
        nArray[8] = 0xC0C0C0;
        nArray[9] = 0xFF0000;
        nArray[10] = 65280;
        nArray[11] = 0xFFFF00;
        nArray[12] = 255;
        nArray[13] = 0xFF00FF;
        nArray[14] = 65535;
        nArray[15] = 0xFFFFFF;
        int[] cmap = nArray;
        return this.convert4(src, cmap);
    }

    protected BufferedImage convert4(BufferedImage src, int[] cmap) {
        IndexColorModel icm = new IndexColorModel(4, cmap.length, cmap, 0, false, 1, 0);
        BufferedImage dest = new BufferedImage(src.getWidth(), src.getHeight(), 12, icm);
        ColorConvertOp cco = new ColorConvertOp(src.getColorModel().getColorSpace(), dest.getColorModel().getColorSpace(), null);
        cco.filter(src, dest);
        return dest;
    }

    protected BufferedImage convert8(BufferedImage src) {
        BufferedImage dest = new BufferedImage(src.getWidth(), src.getHeight(), 13);
        ColorConvertOp cco = new ColorConvertOp(src.getColorModel().getColorSpace(), dest.getColorModel().getColorSpace(), null);
        cco.filter(src, dest);
        return dest;
    }

    public boolean isBuildingColor(int rgb, boolean ignoreParcelColor) {
        int i = 0;
        while (i < cBuilingFootColors.length) {
            if (rgb == cBuilingFootColors[i]) {
                return true;
            }
            ++i;
        }
        return ignoreParcelColor && rgb == this.parcelColor;
    }

    public boolean isRoofColor(int rgb, boolean ignoreParcelColor) {
        int i = 0;
        while (i < cRoofColors.length) {
            if (rgb == cRoofColors[i]) {
                return true;
            }
            ++i;
        }
        return ignoreParcelColor && rgb == this.parcelColor;
    }

    public boolean isParcelColor(BufferedImage img, int x, int y) {
        int rgb = img.getRGB(x, y);
        return rgb == this.parcelColor;
    }

    public boolean isBuildingOrRoofColor(BufferedImage img, int x, int y, boolean ignoreParcelColor) {
        int rgb = img.getRGB(x, y);
        boolean ret = this.isBuildingColor(rgb, ignoreParcelColor) || this.isRoofColor(rgb, ignoreParcelColor);
        return ret;
    }

    public boolean isBuildingOrRoofColor(BufferedImage img, int x, int y, boolean colorType, boolean ignoreParcelColor) {
        int rgb = img.getRGB(x, y);
        boolean ret = colorType ? this.isBuildingColor(rgb, ignoreParcelColor) : this.isRoofColor(rgb, ignoreParcelColor);
        return ret;
    }

    public boolean isBackgroundColor(BufferedImage img, int x, int y) {
        return img.getRGB(x, y) == -1;
    }
}

