/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CadastrePlugin;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class CheckSourceUploadHook
implements UploadHook {
    private static final long serialVersionUID = -1L;

    public boolean checkUpload(APIDataSet apiDataSet) {
        if (CadastrePlugin.autoSourcing && CadastrePlugin.pluginUsed && !apiDataSet.getPrimitivesToAdd().isEmpty()) {
            HashSet<OsmPrimitive> sel = new HashSet<OsmPrimitive>();
            for (OsmPrimitive osm : apiDataSet.getPrimitivesToAdd()) {
                if ((!(osm instanceof Way) || osm.getKeys().size() != 0 && this.tagSourceExist(osm)) && (!(osm instanceof Node) || osm.getKeys().size() <= 0 || this.tagSourceExist(osm))) continue;
                sel.add(osm);
            }
            if (!sel.isEmpty()) {
                this.displaySource(sel);
            }
        }
        return true;
    }

    private boolean tagSourceExist(OsmPrimitive osm) {
        for (String key : osm.keySet()) {
            if (!key.equals("source")) continue;
            return true;
        }
        return false;
    }

    private void displaySource(Collection<OsmPrimitive> sel) {
        if (!sel.isEmpty()) {
            boolean bContinue;
            JPanel p = new JPanel(new GridBagLayout());
            OsmPrimitivRenderer renderer = new OsmPrimitivRenderer();
            p.add((Component)new JLabel(I18n.tr((String)"Add \"source=...\" to elements?", (Object[])new Object[0])), GBC.eol());
            JTextField tf = new JTextField(CadastrePlugin.source);
            p.add((Component)tf, GBC.eol());
            JList<Object> l = new JList<Object>(sel.toArray());
            l.setCellRenderer((ListCellRenderer<Object>)renderer);
            l.setVisibleRowCount(l.getModel().getSize() < 6 ? l.getModel().getSize() : 10);
            p.add((Component)new JScrollPane(l), GBC.eol().fill());
            boolean bl = bContinue = JOptionPane.showConfirmDialog(Main.parent, p, I18n.tr((String)"Add \"source=...\" to elements?", (Object[])new Object[0]), 0) == 0;
            if (bContinue) {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand(sel, "source", tf.getText()));
            }
        }
    }
}

