/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imageryxmlbounds.actions;

import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.imageryxmlbounds.XmlBoundsConstants;
import org.openstreetmap.josm.tools.I18n;

public class ComputeBoundsAction
extends AbstractAction
implements XmlBoundsConstants {
    protected static final DecimalFormat df = new DecimalFormat("#0.0000000", new DecimalFormatSymbols(Locale.UK));
    protected static final String ACTION_NAME = I18n.tr((String)"XML Imagery Bounds", (Object[])new Object[0]);
    private final Set<Relation> multipolygons = new HashSet<Relation>();
    private final Set<Way> closedWays = new HashSet<Way>();

    public ComputeBoundsAction() {
        this((OsmDataLayer)null);
    }

    public ComputeBoundsAction(OsmDataLayer layer) {
        this.putValue("ShortDescription", I18n.tr((String)"Generate Imagery XML bounds for the selection", (Object[])new Object[0]));
        this.putValue("Name", ACTION_NAME);
        try {
            this.putValue("SmallIcon", XML_ICON_24);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setEnabled(false);
        if (layer != null) {
            ArrayList primitives = new ArrayList();
            primitives.addAll(layer.data.getRelations());
            primitives.addAll(layer.data.getWays());
            this.updateOsmPrimitives(primitives);
        }
    }

    protected void updateOsmPrimitives(Collection<? extends OsmPrimitive> primitives) {
        this.multipolygons.clear();
        this.closedWays.clear();
        for (OsmPrimitive osmPrimitive : primitives) {
            Way w;
            if (osmPrimitive instanceof Relation) {
                Relation r = (Relation)osmPrimitive;
                if (!r.isMultipolygon()) continue;
                this.multipolygons.add(r);
                continue;
            }
            if (!(osmPrimitive instanceof Way) || !(w = (Way)osmPrimitive).isClosed()) continue;
            this.closedWays.add(w);
        }
        Iterator<Way> it = this.closedWays.iterator();
        while (it.hasNext()) {
            Way way = it.next();
            for (Relation mp : this.multipolygons) {
                for (RelationMember mb : mp.getMembers()) {
                    if (!mb.getMember().equals((Object)way)) continue;
                    it.remove();
                }
            }
        }
        this.setEnabled(!this.multipolygons.isEmpty() || !this.closedWays.isEmpty());
    }

    public final String getXml() {
        ArrayList<Object> primitives = new ArrayList<Object>();
        primitives.addAll(this.multipolygons);
        primitives.addAll(this.closedWays);
        return ComputeBoundsAction.getXml(primitives.toArray(new OsmPrimitive[0]));
    }

    protected static final String getXml(OsmPrimitive ... primitives) {
        ArrayList<String> entries = new ArrayList<String>();
        for (OsmPrimitive p : primitives) {
            if (p instanceof Relation) {
                entries.add(ComputeBoundsAction.getEntry(p, ComputeBoundsAction.getMultiPolygonBounds((Relation)p)));
                continue;
            }
            if (!(p instanceof Way)) continue;
            entries.add(ComputeBoundsAction.getEntry(p, ComputeBoundsAction.getClosedWayBounds((Way)p)));
        }
        return ComputeBoundsAction.getImagery(entries.toArray(new String[0]));
    }

    protected static final String getImagery(String ... entries) {
        String result = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n";
        result = result + "<!-- Generated with JOSM Imagery XML Plugin version 1.0 -->\n";
        result = result + "<imagery xmlns=\"http://josm.openstreetmap.de/maps-1.0\">\n";
        for (String entry : entries) {
            result = result + entry + "\n";
        }
        result = result + "</imagery>";
        return result;
    }

    protected static final String getEntry(OsmPrimitive p, String bounds) {
        return ComputeBoundsAction.getEntry(p.get("name"), p.get("imagery:type"), p.get("imagery:url"), bounds, p.get("imagery:projections"), p.get("imagery:eula"), p.get("imagery:attribution-text"), p.get("imagery:attribution-url"), p.get("imagery:country-code"));
    }

    protected static final String getEntry(String name, String type, String url, String bounds, String projections, String eula, String attributionText, String attributionUrl, String countryCode) {
        String result = "    <entry>\n        <name>" + (name != null ? name : "") + "</name>\n" + "        <type>" + (type != null ? type : "wms") + "</type>\n" + "        <url>" + (url != null ? ComputeBoundsAction.encodeUrl(url) : "") + "</url>\n" + bounds + "\n";
        if (projections != null && !projections.isEmpty()) {
            String[] codes;
            result = result + "        <projections>\n";
            int i = 0;
            for (String code : codes = projections.split(";")) {
                if (i % 6 == 0) {
                    result = result + "            ";
                }
                result = result + "<code>" + code.trim() + "</code>";
                if (i % 6 == 5 || i == codes.length - 1) {
                    result = result + "\n";
                }
                ++i;
            }
            result = result + "        </projections>\n";
        }
        if (eula != null && !eula.isEmpty()) {
            result = result + "        <eula mandatory='true'>" + ComputeBoundsAction.encodeUrl(eula) + "></eula>\n";
        }
        if (attributionText != null && !attributionText.isEmpty()) {
            result = result + "        <attribution-text mandatory='true'>" + attributionText + "</attribution-text>\n";
        }
        if (attributionUrl != null && !attributionUrl.isEmpty()) {
            result = result + "        <attribution-url>" + ComputeBoundsAction.encodeUrl(attributionUrl) + "</attribution-url>\n";
        }
        if (countryCode != null && !countryCode.isEmpty()) {
            result = result + "        <country-code>" + countryCode + "</country-code>\n";
        }
        result = result + "    </entry>";
        return result;
    }

    protected static final String encodeUrl(String url) {
        return "<![CDATA[" + url + "]]>";
    }

    protected static final String getBounds(OsmPrimitive p, boolean closeTag) {
        BBox bbox = p.getBBox();
        String result = "        <bounds ";
        result = result + "min-lat='" + df.format(bbox.getBottomRight().lat()) + "' ";
        result = result + "min-lon='" + df.format(bbox.getTopLeft().lon()) + "' ";
        result = result + "max-lat='" + df.format(bbox.getTopLeft().lat()) + "' ";
        result = result + "max-lon='" + df.format(bbox.getBottomRight().lon()) + "'";
        result = result + (closeTag ? " />" : ">\n");
        return result;
    }

    protected static final boolean isValidOuterMember(RelationMember mb) {
        return (mb.getRole() == null || mb.getRole().isEmpty() || mb.getRole().equals("outer")) && mb.getMember() instanceof Way && ((Way)mb.getMember()).isClosed();
    }

    protected static final String getMultiPolygonBounds(Relation mp) {
        ArrayList<Way> outerClosedWays = new ArrayList<Way>();
        for (RelationMember mb : mp.getMembers()) {
            if (!ComputeBoundsAction.isValidOuterMember(mb)) continue;
            outerClosedWays.add((Way)mb.getMember());
        }
        if (outerClosedWays.isEmpty() || outerClosedWays.size() == 1 && ComputeBoundsAction.areClosedWayAndBboxEqual((Way)outerClosedWays.get(0), mp.getBBox())) {
            return ComputeBoundsAction.getBounds((OsmPrimitive)mp, true);
        }
        String result = ComputeBoundsAction.getBounds((OsmPrimitive)mp, false);
        for (Way way : outerClosedWays) {
            result = result + ComputeBoundsAction.getClosedWayShape(way);
        }
        result = result + "        </bounds>";
        return result;
    }

    protected static final boolean areClosedWayAndBboxEqual(Way way, BBox bBox) {
        if (way.getNodesCount() == 5) {
            HashMap<Double, ArrayList<Integer>> latMap = new HashMap<Double, ArrayList<Integer>>();
            HashMap<Double, ArrayList<Integer>> lonMap = new HashMap<Double, ArrayList<Integer>>();
            for (int i = 0; i < 4; ++i) {
                LatLon b;
                LatLon c = way.getNode(i).getCoor();
                if (i > 1 && (b = way.getNode(i - 1).getCoor()).lat() != c.lat() && b.lon() != c.lon()) {
                    return false;
                }
                ArrayList<Integer> latList = (ArrayList<Integer>)latMap.get(c.lat());
                if (latList == null) {
                    latList = new ArrayList<Integer>();
                    latMap.put(c.lat(), latList);
                }
                latList.add(i);
                ArrayList<Integer> lonList = (ArrayList<Integer>)lonMap.get(c.lon());
                if (lonList == null) {
                    lonList = new ArrayList<Integer>();
                    lonMap.put(c.lon(), lonList);
                }
                lonList.add(i);
            }
            boolean result = latMap.size() == 2 && lonMap.size() == 2 && latMap.containsKey(bBox.getBottomRight().lat()) && latMap.containsKey(bBox.getTopLeft().lat()) && lonMap.containsKey(bBox.getBottomRight().lon()) && lonMap.containsKey(bBox.getTopLeft().lon());
            System.out.println(result);
            return result;
        }
        return false;
    }

    protected static final String getClosedWayBounds(Way cw) {
        if (ComputeBoundsAction.areClosedWayAndBboxEqual(cw, cw.getBBox())) {
            return ComputeBoundsAction.getBounds((OsmPrimitive)cw, true);
        }
        return ComputeBoundsAction.getBounds((OsmPrimitive)cw, false) + ComputeBoundsAction.getClosedWayShape(cw) + "        </bounds>";
    }

    protected static final String getClosedWayShape(Way cw) {
        String result = "            <shape>\n";
        for (int i = 0; i < cw.getNodesCount() - 1; ++i) {
            if (i % 3 == 0) {
                result = result + "                ";
            }
            result = result + "<point ";
            result = result + "lat='" + df.format(cw.getNode(i).getCoor().lat()) + "' ";
            result = result + "lon='" + df.format(cw.getNode(i).getCoor().lon()) + "'/>";
            if (i % 3 != 2 && i != cw.getNodesCount() - 2) continue;
            result = result + "\n";
        }
        result = result + "            </shape>\n";
        return result;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        System.out.println(this.getXml());
    }
}

