/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imageryxmlbounds;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.Shape;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.imagery.ImageryReader;
import org.openstreetmap.josm.plugins.imageryxmlbounds.ValidatingImageryReader;
import org.openstreetmap.josm.plugins.imageryxmlbounds.XmlBoundsConstants;
import org.openstreetmap.josm.plugins.imageryxmlbounds.XmlBoundsLayer;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class XmlBoundsImporter
extends FileImporter
implements XmlBoundsConstants {
    public XmlBoundsImporter() {
        super(FILE_FILTER);
    }

    public DataSet convertImageryEntries(List<ImageryInfo> entries) {
        DataSet dataSet = new DataSet();
        for (ImageryInfo imagery : entries) {
            ImageryInfo.ImageryBounds bounds;
            if (imagery.isBlacklisted() || (bounds = imagery.getBounds()) == null) continue;
            dataSet.addPrimitive(this.convertImagery(imagery, bounds, dataSet));
        }
        return dataSet;
    }

    private void safePut(OsmPrimitive p, String key, Object value) {
        if (value != null) {
            if (value instanceof Collection) {
                String s = "";
                for (Object elt : (Collection)value) {
                    if (elt == null || elt.toString() == null || elt.toString().isEmpty()) continue;
                    if (!s.isEmpty()) {
                        s = s + ";";
                    }
                    s = s + elt.toString();
                }
                if (!s.isEmpty()) {
                    p.put(key, s);
                }
            } else if (!value.equals(0) && value.toString() != null && !value.toString().isEmpty()) {
                p.put(key, value.toString());
            }
        }
    }

    private Node getNode(LatLon latlon, DataSet dataSet) {
        List nodes = dataSet.searchNodes(new BBox(latlon, latlon));
        if (!nodes.isEmpty()) {
            return (Node)nodes.get(0);
        }
        Node node = new Node(latlon);
        dataSet.addPrimitive((OsmPrimitive)node);
        return node;
    }

    private Node getNode(double lat, double lon, DataSet dataSet) {
        return this.getNode(new LatLon(lat, lon), dataSet);
    }

    private void ensureWayIsClosed(Way way) {
        if (!way.getNode(0).equals((Object)way.getNode(way.getNodesCount() - 1))) {
            way.addNode(way.getNode(0));
        }
    }

    private OsmPrimitive convertImagery(ImageryInfo imagery, ImageryInfo.ImageryBounds bounds, DataSet dataSet) {
        Relation osmImagery = null;
        if (bounds.getShapes().isEmpty()) {
            LatLon bottomLeft = bounds.getMin();
            LatLon topRight = bounds.getMax();
            LatLon topLeft = new LatLon(topRight.lat(), bottomLeft.lon());
            LatLon bottomRight = new LatLon(bottomLeft.lat(), topRight.lon());
            Way way = new Way();
            for (LatLon ll : new LatLon[]{bottomLeft, topLeft, topRight, bottomRight}) {
                way.addNode(this.getNode(ll, dataSet));
            }
            this.ensureWayIsClosed(way);
            osmImagery = way;
        } else {
            Relation relation = new Relation();
            relation.put("type", "multipolygon");
            for (Shape shape : bounds.getShapes()) {
                Way way = new Way();
                for (Coordinate coor : shape.getPoints()) {
                    way.addNode(this.getNode(coor.getLat(), coor.getLon(), dataSet));
                }
                this.ensureWayIsClosed(way);
                dataSet.addPrimitive((OsmPrimitive)way);
                relation.addMember(new RelationMember("outer", (OsmPrimitive)way));
            }
            osmImagery = relation;
        }
        this.safePut((OsmPrimitive)osmImagery, "name", imagery.getName());
        this.safePut((OsmPrimitive)osmImagery, "imagery:type", imagery.getImageryType().getUrlString());
        this.safePut((OsmPrimitive)osmImagery, "imagery:default", imagery.isDefaultEntry());
        this.safePut((OsmPrimitive)osmImagery, "imagery:url", imagery.getUrl());
        this.safePut((OsmPrimitive)osmImagery, "imagery:projections", imagery.getServerProjections());
        this.safePut((OsmPrimitive)osmImagery, "imagery:eula", imagery.getEulaAcceptanceRequired());
        this.safePut((OsmPrimitive)osmImagery, "imagery:attribution-text", imagery.getAttributionText());
        this.safePut((OsmPrimitive)osmImagery, "imagery:attribution-url", imagery.getAttributionLinkURL());
        this.safePut((OsmPrimitive)osmImagery, "imagery:terms-of-use-url", imagery.getTermsOfUseURL());
        this.safePut((OsmPrimitive)osmImagery, "imagery:country-code", imagery.getCountryCode());
        if (imagery.getImageryType().equals((Object)ImageryInfo.ImageryType.TMS)) {
            this.safePut((OsmPrimitive)osmImagery, "imagery:max-zoom", imagery.getMaxZoom());
            this.safePut((OsmPrimitive)osmImagery, "imagery:min-zoom", imagery.getMinZoom());
        }
        return osmImagery;
    }

    public void importData(final File file, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        try {
            ValidatingImageryReader reader = null;
            try {
                reader = new ValidatingImageryReader(file.getAbsolutePath());
            }
            catch (SAXException e) {
                if (JOptionPane.showConfirmDialog(Main.parent, I18n.tr((String)"Validating error in file {0}:\n{1}\nDo you want to continue without validating the file ?", (Object[])new Object[]{file.getPath(), e.getLocalizedMessage()}), I18n.tr((String)"Open Imagery XML file", (Object[])new Object[0]), 1) != 0) {
                    return;
                }
                reader = new ImageryReader(file.getAbsolutePath());
            }
            final DataSet dataSet = this.convertImageryEntries(reader.parse());
            final XmlBoundsLayer layer = new XmlBoundsLayer(dataSet, file.getName(), file);
            Runnable uiStuff = new Runnable(){

                @Override
                public void run() {
                    if (dataSet.allPrimitives().isEmpty()) {
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No data found in file {0}.", (Object[])new Object[]{file.getPath()}), I18n.tr((String)"Open Imagery XML file", (Object[])new Object[0]), 1);
                    }
                    Main.main.addLayer((Layer)layer);
                    layer.onPostLoadFromFile();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                uiStuff.run();
            } else {
                SwingUtilities.invokeLater(uiStuff);
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public void importData(List<File> files, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        for (File file : files) {
            this.importData(file, progressMonitor);
        }
    }
}

