/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.turnlanes.model.ModelContainer;
import org.openstreetmap.josm.plugins.turnlanes.model.Road;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Junction {
    private final ModelContainer container;
    private final Node node;
    private final Set<Way> roads = new HashSet<Way>();

    Junction(ModelContainer container, Node n) {
        this.container = container;
        this.node = n;
    }

    public boolean isPrimary() {
        return this.getContainer().isPrimary(this);
    }

    public Node getNode() {
        return this.node;
    }

    public List<Road> getRoads() {
        ArrayList<Road> result = new ArrayList<Road>(this.roads.size());
        for (Way w : this.roads) {
            result.add(this.container.getRoad(w));
        }
        return result;
    }

    public List<Road.End> getRoadEnds() {
        ArrayList<Road.End> result = new ArrayList<Road.End>(this.roads.size());
        for (Way w : this.roads) {
            result.add(this.getRoadEnd(w));
        }
        return result;
    }

    void addRoad(Way w) {
        this.roads.add(w);
    }

    Road.End getRoadEnd(Way w) {
        Road r = this.getContainer().getRoad(w);
        if (r.getRoute().getSegments().size() == 1) {
            boolean starts = r.getRoute().getStart().equals((Object)this.node);
            boolean ends = r.getRoute().getEnd().equals((Object)this.node);
            if (starts && ends) {
                throw new IllegalArgumentException("Ambiguous: The way starts and ends at the junction node.");
            }
            if (starts) {
                return r.getFromEnd();
            }
            if (ends) {
                return r.getToEnd();
            }
        } else {
            if (r.getRoute().getFirstSegment().getWay().equals((Object)w)) {
                return r.getFromEnd();
            }
            if (r.getRoute().getLastSegment().getWay().equals((Object)w)) {
                return r.getToEnd();
            }
        }
        throw new IllegalArgumentException("While there exists a road for the given way, the way neither starts nor ends at the junction node.");
    }

    public ModelContainer getContainer() {
        return this.container;
    }
}

