/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.alignways;

import java.awt.Point;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.plugins.alignways.AlignWaysAlgnSegment;
import org.openstreetmap.josm.plugins.alignways.AlignWaysRefSegment;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlignWaysSegmentMgr {
    private static volatile AlignWaysSegmentMgr singleton;
    private AlignWaysRefSegment refSeg = null;
    private AlignWaysAlgnSegment algnSeg = null;
    private final MapView mv;

    private AlignWaysSegmentMgr(MapView mapView) {
        this.mv = mapView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AlignWaysSegmentMgr getInstance(MapView mapView) {
        if (singleton != null) return singleton;
        Class<AlignWaysSegmentMgr> clazz = AlignWaysSegmentMgr.class;
        synchronized (AlignWaysSegmentMgr.class) {
            if (singleton != null) return singleton;
            singleton = new AlignWaysSegmentMgr(mapView);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    public boolean algnUpdate(Point clickedPoint) {
        if (this.algnSeg != null && this.algnSeg.updatePivot(clickedPoint)) {
            return false;
        }
        AlignWaysAlgnSegment tmpAlgnSeg = new AlignWaysAlgnSegment(this.mv, clickedPoint);
        if (tmpAlgnSeg.getSegment() == null) {
            return false;
        }
        if (this.refSeg != null && tmpAlgnSeg.equals(this.refSeg)) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Segment to be aligned cannot be the same with the reference segment.\nPlease choose a different segment to be aligned.", (Object[])new Object[0]), I18n.tr((String)"AlignWayS message", (Object[])new Object[0]), 2);
            return false;
        }
        if (this.algnSeg != null) {
            this.algnSeg.destroy();
        }
        this.algnSeg = tmpAlgnSeg;
        return true;
    }

    public boolean refUpdate(Point clickedPoint) {
        AlignWaysRefSegment tmpRefSeg = new AlignWaysRefSegment(this.mv, clickedPoint);
        if (tmpRefSeg.getSegment() == null) {
            return false;
        }
        if (this.algnSeg != null && tmpRefSeg.equals(this.algnSeg)) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Reference segment cannot be the same with the segment to be aligned.\nPlease choose a different reference segment.", (Object[])new Object[0]), I18n.tr((String)"AlignWayS message", (Object[])new Object[0]), 2);
            return false;
        }
        if (this.refSeg != null) {
            this.refSeg.destroy();
        }
        this.refSeg = tmpRefSeg;
        return true;
    }

    public Collection<Node> getSelectedNodes() {
        if (this.algnSeg != null) {
            return this.algnSeg.getSegmentEndPoints();
        }
        return null;
    }

    public void cleanupWays() {
        if (this.algnSeg != null) {
            this.algnSeg.destroy();
            this.algnSeg = null;
        }
        if (this.refSeg != null) {
            this.refSeg.destroy();
            this.refSeg = null;
        }
    }

    public AlignWaysAlgnSegment getAlgnSeg() {
        return this.algnSeg;
    }

    public AlignWaysRefSegment getRefSeg() {
        return this.refSeg;
    }
}

