/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.gpxpoints;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GpxPointsPanel
extends ToggleDialog {
    private static final String ICON_PANEL = "marker";
    private final JTable pointsList;
    private final DefaultTableModel gpxTableModel;
    private int lastSelected = -1;
    List<Marker> tableData = new ArrayList<Marker>();
    JosmAction nextGpxAction = new NextGpxAction();

    public GpxPointsPanel(String name, String iconName, String tooltip, Shortcut shortcut, int preferredHeight, boolean defShow) {
        super(name, iconName, tooltip, shortcut, preferredHeight, defShow);
        this.gpxTableModel = new DefaultTableModel();
        this.pointsList = new JTable(this.gpxTableModel){

            public boolean isCellEditable(int nRow, int nCol) {
                return false;
            }
        };
        this.gpxTableModel.setColumnCount(1);
        this.gpxTableModel.setColumnIdentifiers(new Object[]{I18n.tr((String)"Name", (Object[])new Object[0])});
        this.pointsList.setSelectionMode(0);
        this.pointsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (GpxPointsPanel.this.pointsList == null) {
                    return;
                }
                int selected = GpxPointsPanel.this.pointsList.getSelectedRow();
                if (selected == GpxPointsPanel.this.lastSelected || selected == -1) {
                    return;
                }
                GpxPointsPanel.this.lastSelected = selected;
                if (Main.map != null && Main.map.mapView != null) {
                    Main.map.mapView.zoomTo(GpxPointsPanel.this.tableData.get(selected).getCoor());
                }
            }
        });
        this.add(new JScrollPane(this.pointsList), "Center");
        JButton btn = new JButton(I18n.tr((String)"Next", (Object[])new Object[0]));
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GpxPointsPanel.this.nextGpxAction.actionPerformed(null);
            }
        });
        this.add(btn, "South");
    }

    public GpxPointsPanel() {
        this(I18n.tr((String)"GPX Waypoints Enum", (Object[])new Object[0]), ICON_PANEL, I18n.tr((String)"Waypoint Enumerator", (Object[])new Object[0]), null, 200, true);
    }

    public void addPoints(Collection<Marker> points) {
        this.tableData.addAll(points);
        for (Marker p : points) {
            String name = p.getText();
            if (name == null) {
                name = "noname";
            }
            this.gpxTableModel.addRow(new Object[]{name});
        }
    }

    public void removePoints(Collection<Marker> points) {
        for (Marker p : points) {
            int position = this.tableData.indexOf(p);
            if (position < 0) continue;
            this.gpxTableModel.removeRow(position);
            this.tableData.remove(position);
        }
    }

    class NextGpxAction
    extends JosmAction {
        public NextGpxAction() {
            super(I18n.tr((String)"Next GPX Waypoint", (Object[])new Object[0]), "nextgpx", I18n.tr((String)"Select to the next Waypoint in List", (Object[])new Object[0]), Shortcut.registerShortcut((String)"gpxenum:next", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Next GPX Waypoint", (Object[])new Object[0])}), (int)107, (int)2), false);
        }

        public void actionPerformed(ActionEvent action) {
            int rowSel = GpxPointsPanel.this.pointsList.getSelectedRow();
            if (rowSel < 0) {
                rowSel = 0;
            }
            if (rowSel < GpxPointsPanel.this.pointsList.getRowCount() - 1) {
                GpxPointsPanel.this.pointsList.getSelectionModel().setSelectionInterval(rowSel + 1, rowSel + 1);
                GpxPointsPanel.this.pointsList.scrollRectToVisible(GpxPointsPanel.this.pointsList.getCellRect(rowSel + 2, 0, true));
            }
        }
    }
}

