/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.gpxpoints;

import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.gpxpoints.GpxPointsPanel;

public class GpxPointsPlugin
extends Plugin {
    private static final GpxPointsPanel togglePanel = new GpxPointsPanel();

    public GpxPointsPlugin(PluginInformation info) {
        super(info);
        MapView.addLayerChangeListener((MapView.LayerChangeListener)new MapView.LayerChangeListener(){

            public void layerRemoved(Layer oldLayer) {
                if (oldLayer instanceof MarkerLayer) {
                    togglePanel.removePoints(((MarkerLayer)oldLayer).data);
                }
            }

            public void layerAdded(Layer newLayer) {
                if (newLayer instanceof MarkerLayer) {
                    togglePanel.addPoints(((MarkerLayer)newLayer).data);
                }
            }

            public void activeLayerChange(Layer oldLayer, Layer newLayer) {
            }
        });
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        super.mapFrameInitialized(oldFrame, newFrame);
        if (newFrame != null) {
            newFrame.addToggleDialog((ToggleDialog)togglePanel);
        }
    }
}

