/*
 * Decompiled with CFR 0.152.
 */
package utilsplugin2.selection;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NodeWayUtils {
    static final int maxLevel = Main.pref.getInteger("selection.maxrecursion", 5);
    static final int maxWays = Main.pref.getInteger("selection.maxfoundways", 2000);
    static final int maxWays1 = Main.pref.getInteger("selection.maxfoundways.intersection", 500);

    static void addNeighbours(Way w, Node n, Collection<Node> nodes) {
        List nodeList = w.getNodes();
        int idx = nodeList.indexOf(n);
        if (idx == -1) {
            return;
        }
        if (idx > 0) {
            nodes.add((Node)nodeList.get(idx - 1));
        }
        if (idx < nodeList.size() - 1) {
            nodes.add((Node)nodeList.get(idx + 1));
        }
        if (w.isClosed()) {
            if (idx == 0) {
                nodes.add((Node)nodeList.get(nodeList.size() - 2));
            }
            if (idx == nodeList.size() - 1) {
                nodes.add((Node)nodeList.get(1));
            }
        }
    }

    static int addWaysConnectedToWay(Way w, Set<Way> ways) {
        int s = ways.size();
        List nodes = w.getNodes();
        for (Node n : nodes) {
            ways.addAll(OsmPrimitive.getFilteredList((Collection)n.getReferrers(), Way.class));
        }
        return ways.size() - s;
    }

    static int addWaysConnectedToNode(Node n, Set<Way> ways) {
        int s = ways.size();
        ways.addAll(OsmPrimitive.getFilteredList((Collection)n.getReferrers(), Way.class));
        return ways.size() - s;
    }

    static int addWaysIntersectingWay(Collection<Way> ways, Way w, Set<Way> newWays, Set<Way> excludeWays) {
        List nodePairs = w.getNodePairs(false);
        int count = 0;
        block0: for (Way anyway : ways) {
            if (anyway == w || newWays.contains(anyway) || excludeWays.contains(anyway)) continue;
            List nodePairs2 = anyway.getNodePairs(false);
            for (Pair p1 : nodePairs) {
                for (Pair p2 : nodePairs2) {
                    if (null == Geometry.getSegmentSegmentIntersection((EastNorth)((Node)p1.a).getEastNorth(), (EastNorth)((Node)p1.b).getEastNorth(), (EastNorth)((Node)p2.a).getEastNorth(), (EastNorth)((Node)p2.b).getEastNorth())) continue;
                    newWays.add(anyway);
                    ++count;
                    continue block0;
                }
            }
        }
        return count;
    }

    static int addWaysIntersectingWay(Collection<Way> ways, Way w, Set<Way> newWays) {
        List nodePairs = w.getNodePairs(false);
        int count = 0;
        block0: for (Way anyway : ways) {
            if (anyway == w || newWays.contains(anyway)) continue;
            List nodePairs2 = anyway.getNodePairs(false);
            for (Pair p1 : nodePairs) {
                for (Pair p2 : nodePairs2) {
                    if (null == Geometry.getSegmentSegmentIntersection((EastNorth)((Node)p1.a).getEastNorth(), (EastNorth)((Node)p1.b).getEastNorth(), (EastNorth)((Node)p2.a).getEastNorth(), (EastNorth)((Node)p2.b).getEastNorth())) continue;
                    newWays.add(anyway);
                    ++count;
                    continue block0;
                }
            }
        }
        return count;
    }

    static int addWaysIntersectingWays(Collection<Way> allWays, Collection<Way> initWays, Set<Way> newWays) {
        int count = 0;
        for (Way w : initWays) {
            count += NodeWayUtils.addWaysIntersectingWay(allWays, w, newWays);
        }
        return count;
    }

    static int addWaysConnectedToNodes(Set<Node> selectedNodes, Set<Way> newWays) {
        int s = newWays.size();
        for (Node node : selectedNodes) {
            NodeWayUtils.addWaysConnectedToNode(node, newWays);
        }
        return newWays.size() - s;
    }

    static int addNodesConnectedToWays(Set<Way> initWays, Set<Node> newNodes) {
        int s = newNodes.size();
        for (Way w : initWays) {
            newNodes.addAll(w.getNodes());
        }
        return newNodes.size() - s;
    }

    static void addWaysIntersectingWaysRecursively(Collection<Way> allWays, Collection<Way> initWays, Set<Way> newWays) {
        int c;
        HashSet<Way> foundWays = new HashSet<Way>();
        foundWays.addAll(initWays);
        newWays.addAll(initWays);
        HashSet<Way> newFoundWays = new HashSet<Way>();
        int level = 0;
        do {
            c = 0;
            newFoundWays = new HashSet();
            for (Way w : foundWays) {
                c += NodeWayUtils.addWaysIntersectingWay(allWays, w, newFoundWays, newWays);
            }
            foundWays = newFoundWays;
            newWays.addAll(newFoundWays);
            ++level;
            if (c <= maxWays1) continue;
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Too many ways are added: {0}!", (Object[])new Object[]{c}), I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
            return;
        } while (c > 0 && level < maxLevel);
    }

    static void addWaysConnectedToWaysRecursively(Collection<Way> initWays, Set<Way> newWays) {
        int c;
        int level = 0;
        newWays.addAll(initWays);
        do {
            c = 0;
            HashSet<Way> foundWays = new HashSet<Way>();
            foundWays.addAll(newWays);
            for (Way w : foundWays) {
                c += NodeWayUtils.addWaysConnectedToWay(w, newWays);
            }
            ++level;
            if (c <= maxWays) continue;
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Too many ways are added: {0}!", (Object[])new Object[]{c}), I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
            return;
        } while (c > 0 && level < maxLevel);
    }

    static void addMiddle(Set<Node> selectedNodes, Set<Node> newNodes) {
        Iterator<Node> it = selectedNodes.iterator();
        Node n1 = it.next();
        Node n2 = it.next();
        HashSet ways = new HashSet();
        ways.addAll(OsmPrimitive.getFilteredList((Collection)n1.getReferrers(), Way.class));
        for (Way w : ways) {
            int i;
            if (!w.isUsable() || !w.containsNode(n2) || !w.containsNode(n1)) continue;
            List nodes = w.getNodes();
            int i1 = nodes.indexOf(n1);
            int i2 = nodes.indexOf(n2);
            int n = nodes.size();
            if (i1 > i2) {
                int p = i2;
                i2 = i1;
                i1 = p;
            }
            if (w.isClosed()) {
                if ((i2 - i1) * 2 <= n) {
                    for (i = i1 + 1; i != i2; ++i) {
                        newNodes.add((Node)nodes.get(i));
                    }
                    continue;
                }
                i = i2 + 1;
                while (i != i1) {
                    newNodes.add((Node)nodes.get(i));
                    i = (i + 1) % n;
                }
                continue;
            }
            for (i = i1 + 1; i < i2; ++i) {
                newNodes.add((Node)nodes.get(i));
            }
        }
        if (newNodes.size() == 0) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select two nodes connected by way!", (Object[])new Object[0]), I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
        }
    }

    static void addAllInsideWay(DataSet data, Way way, Set<Way> newWays, Set<Node> newNodes) {
        if (!way.isClosed()) {
            return;
        }
        BBox box = way.getBBox();
        List polyNodes = way.getNodes();
        List searchNodes = data.searchNodes(box);
        HashSet<Node> newestNodes = new HashSet<Node>();
        HashSet<Way> newestWays = new HashSet<Way>();
        for (Node n : searchNodes) {
            if (!Geometry.nodeInsidePolygon((Node)n, (List)polyNodes)) continue;
            newestNodes.add(n);
        }
        List searchWays = data.searchWays(box);
        for (Way w : searchWays) {
            if (!newestNodes.containsAll(w.getNodes())) continue;
            newestWays.add(w);
        }
        for (Way w : newestWays) {
            newestNodes.removeAll(w.getNodes());
        }
        newNodes.addAll(newestNodes);
        newWays.addAll(newestWays);
    }
}

