/*
 * Decompiled with CFR 0.152.
 */
package utilsplugin2.dumbutils;

import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceGeometryAction
extends JosmAction {
    private static final String TITLE = I18n.tr((String)"Replace Geometry", (Object[])new Object[0]);
    private static final double MAX_NODE_REPLACEMENT_DISTANCE = 3.0E-4;

    public ReplaceGeometryAction() {
        super(TITLE, "dumbutils/replacegeometry", I18n.tr((String)"Replace geometry of selected way with a new one", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:replacegeometry", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{TITLE}), (int)71, (int)1, (int)1), true);
    }

    public void actionPerformed(ActionEvent e) {
        if (ReplaceGeometryAction.getCurrentDataSet() == null) {
            return;
        }
        List selection = OsmPrimitive.getFilteredList((Collection)ReplaceGeometryAction.getCurrentDataSet().getSelected(), Way.class);
        if (selection.size() != 2) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"This tool replaces geometry of one way with another, and requires two ways to be selected.", (Object[])new Object[0]), TITLE, 1);
            return;
        }
        int idxNew = ((Way)selection.get(0)).isNew() ? 0 : 1;
        Way geometry = (Way)selection.get(idxNew);
        Way way = (Way)selection.get(1 - idxNew);
        if (way.isNew() || !geometry.isNew()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select one way that exists in the database and one new way with correct geometry.", (Object[])new Object[0]), TITLE, 2);
            return;
        }
        HashSet<Node> nodePool = new HashSet<Node>();
        Area a = ReplaceGeometryAction.getCurrentDataSet().getDataSourceArea();
        for (Node node : way.getNodes()) {
            List referrers = node.getReferrers();
            if (node.isDeleted() || referrers.size() != 1 || !((OsmPrimitive)referrers.get(0)).equals((Object)way) || !node.isNewOrUndeleted() && !a.contains((Point2D)node.getCoor())) continue;
            nodePool.add(node);
        }
        HashSet<Node> geometryPool = new HashSet<Node>();
        for (Node node : geometry.getNodes()) {
            List referrers = node.getReferrers();
            if (!node.isNew() || node.isDeleted() || referrers.size() != 1 || !((OsmPrimitive)referrers.get(0)).equals((Object)geometry) || way.containsNode(node)) continue;
            geometryPool.add(node);
        }
        HashMap<Node, Node> nodeAssoc = new HashMap<Node, Node>();
        for (Node n : geometryPool) {
            Node nearest = this.findNearestNode(n, nodePool);
            if (nearest == null) continue;
            nodeAssoc.put(n, nearest);
            nodePool.remove(nearest);
        }
        for (Node n : geometryPool) {
            if (!nodeAssoc.containsKey(n)) continue;
            nodePool.add(n);
        }
        List geometryNodes = geometry.getNodes();
        for (int i = 0; i < geometryNodes.size(); ++i) {
            if (!nodeAssoc.containsKey(geometryNodes.get(i))) continue;
            geometryNodes.set(i, nodeAssoc.get(geometryNodes.get(i)));
        }
        ArrayList<Object> commands = new ArrayList<Object>();
        commands.add(new ChangeNodesCommand(way, geometryNodes));
        for (Node node : nodeAssoc.keySet()) {
            commands.add(new MoveCommand((Node)nodeAssoc.get(node), node.getCoor()));
        }
        for (String key : geometry.keySet()) {
            commands.add(new ChangePropertyCommand((OsmPrimitive)way, key, geometry.get(key)));
        }
        ReplaceGeometryAction.getCurrentDataSet().clearSelection(new PrimitiveId[]{geometry});
        commands.add(new DeleteCommand((OsmPrimitive)geometry));
        if (!nodePool.isEmpty()) {
            commands.add(new DeleteCommand(nodePool));
        }
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Replace geometry for way {0}", (Object[])new Object[]{way.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())}), commands));
    }

    private Node findNearestNode(Node node, Collection<Node> nodes) {
        if (nodes.contains(node)) {
            return node;
        }
        Node nearest = null;
        double distance = 3.0E-4;
        LatLon coor = node.getCoor();
        for (Node n : nodes) {
            double d = n.getCoor().distance((Point2D)coor);
            if (!(d < distance)) continue;
            distance = d;
            nearest = n;
        }
        return nearest;
    }

    protected void updateEnabledState() {
        if (ReplaceGeometryAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(ReplaceGeometryAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && selection.size() >= 2);
    }
}

