/*
 * Decompiled with CFR 0.152.
 */
package utilsplugin2;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ChooseURLAction
extends JosmAction {
    public ChooseURLAction() {
        super(I18n.tr((String)"Select custom URL", (Object[])new Object[0]), "selecturl", I18n.tr((String)"Select custom URL", (Object[])new Object[0]), null, true, true);
        this.putValue("toolbar", "action/selectURL");
    }

    public void actionPerformed(ActionEvent e) {
        ChooseURLAction.showConfigDialog();
    }

    protected void updateEnabledState() {
        if (ChooseURLAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    public static void showConfigDialog() {
        JPanel all = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        all.setLayout(layout);
        List items = (List)Main.pref.getCollection("utilsplugin2.urlHistory");
        int n = items.size() / 2;
        int idxToSelect = -1;
        String[] names = new String[n];
        final String[] vals = new String[n];
        String addr = Main.pref.get("utilsplugin2.customurl");
        for (int i = 0; i < n; ++i) {
            names[i] = (String)items.get(i * 2);
            vals[i] = (String)items.get(i * 2 + 1);
            if (!vals[i].equals(addr)) continue;
            idxToSelect = i;
        }
        JLabel label1 = new JLabel(I18n.tr((String)"Please select one of custom URLs (configured in Preferences)", (Object[])new Object[0]));
        final JComboBox<String> combo1 = new JComboBox<String>(names);
        final JTextField editField = new JTextField();
        JCheckBox check1 = new JCheckBox(I18n.tr((String)"Ask every time", (Object[])new Object[0]));
        combo1.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                int idx = combo1.getSelectedIndex();
                if (idx >= 0) {
                    editField.setText(vals[idx]);
                }
            }
        });
        combo1.setSelectedIndex(idxToSelect);
        check1.setSelected(Main.pref.getBoolean("utilsplugin2.askurl", false));
        editField.setEditable(false);
        all.add((Component)label1, GBC.eop().fill(2).insets(15, 5, 15, 0));
        all.add(combo1, GBC.eop().fill(2).insets(5, 5, 0, 0));
        all.add((Component)editField, GBC.eop().fill(2).insets(5, 5, 0, 0));
        all.add((Component)check1, GBC.eop().fill(2).insets(5, 5, 0, 0));
        ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr((String)"Configure custom URL", (Object[])new Object[0]), new String[]{I18n.tr((String)"OK", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])});
        dialog.setContent((Component)all, false);
        dialog.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        dialog.setDefaultButton(1);
        dialog.showDialog();
        int idx = combo1.getSelectedIndex();
        if (dialog.getValue() == 1 && idx >= 0) {
            Main.pref.put("utilsplugin2.customurl", vals[idx]);
            Main.pref.put("utilsplugin2.askurl", check1.isSelected());
        }
    }
}

