/*
 * Decompiled with CFR 0.152.
 */
package utilsplugin2;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UtilsPluginPreferences
implements PreferenceSetting {
    private final String defaultURL = "http://ru.wikipedia.org/w/index.php?search={name}&fulltext=Search";
    HistoryComboBox combo1 = new HistoryComboBox();
    JTable table;

    public void addGui(PreferenceTabbedPane gui) {
        JPanel pp = gui.createPreferenceTab("utils", I18n.tr((String)"Utilsplugin2 settings [TESTING]", (Object[])new Object[0]), I18n.tr((String)"Here you can change some preferences of Utilsplugin2 functions", (Object[])new Object[0]));
        JPanel all = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        all.setLayout(layout);
        ArrayList<String> items = (ArrayList<String>)Main.pref.getCollection("utilsplugin2.urlHistory");
        if (items == null || items.size() == 0) {
            items = new ArrayList<String>();
            items.add("Wikipedia");
            items.add("http://en.wikipedia.org/w/index.php?search={name}&fulltext=Search");
            items.add("Wikipedia RU");
            items.add("http://ru.wikipedia.org/w/index.php?search={name}&fulltext=Search");
            items.add("LatLon buildings");
            items.add("http://latlon.org/buildings?zoom=17&lat={#lat}&lon={#lon}&layers=B");
            items.add("AMDMi3 Russian streets");
            items.add("http://addresses.amdmi3.ru/?zoom=11&lat={#lat}&lon={#lon}&layers=B00");
            items.add("Element history");
            items.add("http://www.openstreetmap.org/browse/{#type}/{#id}/history");
            items.add("Browse element");
            items.add("http://www.openstreetmap.org/browse/{#type}/{#id}");
        }
        String addr = Main.pref.get("utilsplugin2.customurl", "http://ru.wikipedia.org/w/index.php?search={name}&fulltext=Search");
        this.table = new JTable(new DefaultTableModel((Object[][])null, new String[]{"Title", "URL"}));
        this.fillRows(items);
        HtmlPanel help = new HtmlPanel(I18n.tr((String)"Please edit custom URLs and select one row to use with the tool<br/> <b>&#123;key&#125;</b> is replaced with the tag walue<br/> <b>&#123;#id&#125;</b> is replaced with the element ID<br/> <b>&#123;#type&#125;</b> is replaced with \"node\",\"way\" or \"relation\" <br/> <b>&#123;#lat&#125; , &#123;#lon&#125;</b> is replaced with element latitude/longitude", (Object[])new Object[0]));
        all.add((Component)new JLabel(I18n.tr((String)"Custom URL configuration", (Object[])new Object[0])), GBC.eop().insets(5, 10, 0, 0));
        all.add((Component)help, GBC.eop().insets(5, 10, 0, 0));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(0).setMaxWidth(300);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.table.setSelectionMode(0);
        this.table.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                int row = e.getFirstRow();
                int column = e.getColumn();
                DefaultTableModel model = (DefaultTableModel)e.getSource();
                String columnName = model.getColumnName(column);
                if (row < 0 || column < 0) {
                    return;
                }
                String data = (String)model.getValueAt(row, column);
                if (data != null && data.length() > 0 && row == model.getRowCount() - 1) {
                    model.addRow(new String[]{"", ""});
                }
            }
        });
        all.add((Component)this.table, GBC.eop().fill());
        pp.add((Component)all, GBC.eol().fill(1));
    }

    private void fillRows(List<String> items) {
        int p = 0;
        int row = 0;
        String[][] data = new String[][]{{"", ""}};
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        int n = items.size();
        while (p < n) {
            String name = items.get(p);
            if (++p >= n) break;
            String url = items.get(p);
            ++p;
            model.addRow(new String[]{name, url});
            ++row;
        }
        model.addRow(new String[]{"", ""});
    }

    public boolean ok() {
        String v;
        String addr = this.combo1.getText();
        TableModel model = this.table.getModel();
        ArrayList<String> lst = new ArrayList<String>();
        int n = model.getRowCount();
        for (int i = 0; i < n; ++i) {
            v = (String)model.getValueAt(i, 0);
            if (v.length() == 0) continue;
            lst.add(v);
            v = (String)model.getValueAt(i, 1);
            lst.add(v);
        }
        Main.pref.putCollection("utilsplugin2.urlHistory", lst);
        int row = this.table.getSelectedRow();
        if (row != -1) {
            v = (String)model.getValueAt(row, 1);
            Main.pref.put("utilsplugin2.customurl", v);
        }
        try {
            Main.pref.save();
        }
        catch (IOException ex) {
            Logger.getLogger(UtilsPluginPreferences.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }
}

