/*
 * Decompiled with CFR 0.152.
 */
package utilsplugin2;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OpenPageAction
extends JosmAction {
    private final String defaultURL = "http://ru.wikipedia.org/w/index.php?search={name}&fulltext=Search";

    public OpenPageAction() {
        super(I18n.tr((String)"Open custom URL", (Object[])new Object[0]), "openurl", I18n.tr((String)"Opens specified URL browser", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:openaddress", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Open custom URL", (Object[])new Object[0])}), (int)92, (int)3, (int)1), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/OpenPage"));
    }

    public void actionPerformed(ActionEvent e) {
        Collection sel = OpenPageAction.getCurrentDataSet().getSelected();
        OsmPrimitive p = null;
        if (sel.size() != 1) {
            this.showConfigDialog();
            return;
        }
        p = (OsmPrimitive)sel.iterator().next();
        String addr = Main.pref.get("utilsplugin2.customurl", "http://ru.wikipedia.org/w/index.php?search={name}&fulltext=Search");
        Pattern pat = Pattern.compile("\\{([^\\}]*)\\}");
        Matcher m = pat.matcher(addr);
        String[] keys = new String[100];
        String[] vals = new String[100];
        int i = 0;
        try {
            while (m.find()) {
                String val;
                System.out.println(m.group());
                String key = m.group(1);
                if (key.equals("#id")) {
                    val = Long.toString(p.getId());
                } else if (key.equals("#type")) {
                    val = OsmPrimitiveType.from((IPrimitive)p).getAPIName();
                } else if (key.equals("#lat")) {
                    val = Double.toString(p.getBBox().getTopLeft().lat());
                } else if (key.equals("#lon")) {
                    val = Double.toString(p.getBBox().getTopLeft().lon());
                } else {
                    val = p.get(key);
                    if (val != null) {
                        val = URLEncoder.encode(p.get(key), "UTF-8");
                    } else {
                        return;
                    }
                }
                keys[i] = m.group();
                vals[i] = val != null ? val : "";
                ++i;
            }
        }
        catch (UnsupportedEncodingException ex) {
            System.err.println("Encoding error");
            return;
        }
        System.out.println(i);
        for (int j = 0; j < i; ++j) {
            addr = addr.replace(keys[j], vals[j]);
        }
        System.out.println(addr);
        try {
            OpenBrowser.displayUrl((String)addr);
        }
        catch (Exception ex) {
            System.err.println("Can not open URL" + addr);
        }
    }

    protected void updateEnabledState() {
        if (OpenPageAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(OpenPageAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null);
    }

    private void showConfigDialog() {
        JPanel all = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        all.setLayout(layout);
        HistoryComboBox combo1 = new HistoryComboBox();
        ArrayList<String> items = new ArrayList<String>();
        items.add("http://ru.wikipedia.org/w/index.php?search={name}&fulltext=Search");
        items.add("http://latlon.org/buildings?zoom=17&lat={#lat}&lon={#lon}&layers=B");
        items.add("http://addresses.amdmi3.ru/?zoom=11&lat={#lat}&lon={#lon}&layers=B00");
        items.add("http://www.openstreetmap.org/browse/{#type}/{#id}/history");
        items.add("http://www.openstreetmap.org/browse/{#type}/{#id}");
        String addr = Main.pref.get("utilsplugin2.customurl", "http://ru.wikipedia.org/w/index.php?search={name}&fulltext=Search");
        System.out.println("pref:" + addr);
        combo1.setPossibleItems(items);
        HtmlPanel help = new HtmlPanel(I18n.tr((String)"You can open custom URL for <b>one</b> selected object<br/> <b>&#123;key&#125;</b> is replaced with the tag walue<br/> <b>&#123;#id&#125;</b> is replaced with the element ID<br/> <b>&#123;#type&#125;</b> is replaced with \"node\",\"way\" or \"relation\" <br/> <b>&#123;#lat&#125; , &#123;#lon&#125;</b> is replaced with element latitude/longitude", (Object[])new Object[0]));
        help.setBorder(BorderFactory.createEtchedBorder(1));
        all.add((Component)help, GBC.eop().insets(5, 10, 0, 0));
        all.add((Component)combo1, GBC.eop().insets(5, 10, 0, 0));
        ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr((String)"Configure custom URL", (Object[])new Object[0]), new String[]{I18n.tr((String)"OK", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])});
        dialog.setContent((Component)all, false);
        dialog.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        dialog.setDefaultButton(1);
        dialog.showDialog();
        addr = combo1.getText();
        if (dialog.getValue() == 1 && addr.length() > 6) {
            Main.pref.put("utilsplugin2.customurl", addr);
        }
    }
}

