/*
 * Decompiled with CFR 0.152.
 */
package utilsplugin2.selection;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import utilsplugin2.selection.NodeWayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntersectedWaysRecursiveAction
extends JosmAction {
    public IntersectedWaysRecursiveAction() {
        super(I18n.tr((String)"All intersecting ways", (Object[])new Object[0]), "intwayall", I18n.tr((String)"Select all intersecting ways", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:intwayall", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{"All intersecting ways"}), (int)73, (int)2, (int)192), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/SelectAllIntersectingWays"));
    }

    public void actionPerformed(ActionEvent e) {
        Collection selection = IntersectedWaysRecursiveAction.getCurrentDataSet().getSelected();
        LinkedHashSet selectedNodes = OsmPrimitive.getFilteredSet((Collection)selection, Node.class);
        HashSet activeWays = new HashSet();
        LinkedHashSet selectedWays = OsmPrimitive.getFilteredSet((Collection)IntersectedWaysRecursiveAction.getCurrentDataSet().getSelected(), Way.class);
        if (!selectedWays.isEmpty()) {
            HashSet<Way> newWays = new HashSet<Way>();
            NodeWayUtils.addWaysIntersectingWaysRecursively(IntersectedWaysRecursiveAction.getCurrentDataSet().getWays(), selectedWays, newWays);
            IntersectedWaysRecursiveAction.getCurrentDataSet().addSelected(newWays);
            return;
        }
        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select some ways to find all connected and intersecting ways!", (Object[])new Object[0]), I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
    }

    protected void updateEnabledState() {
        if (IntersectedWaysRecursiveAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(IntersectedWaysRecursiveAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if (selection == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(!selection.isEmpty());
    }
}

