/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.undelete;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.OsmIdTextField;
import org.openstreetmap.josm.gui.widgets.OsmPrimitiveTypesComboBox;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.undelete.DownloadPrimitiveTask;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Undelete
extends Plugin {
    JMenuItem Undelete;

    public Undelete(PluginInformation info) {
        super(info);
        this.Undelete = MainMenu.add((JMenu)Main.main.menu.fileMenu, (JosmAction)new UndeleteAction());
    }

    public void undelete(boolean newLayer, final OsmPrimitiveType type, final List<Long> ids, final long parent) {
        OsmDataLayer tmpLayer = Main.main.getEditLayer();
        if (tmpLayer == null || newLayer) {
            tmpLayer = new OsmDataLayer(new DataSet(), OsmDataLayer.createNewName(), null);
            Main.main.addLayer((Layer)tmpLayer);
        }
        final DataSet datas = tmpLayer.data;
        final OsmDataLayer layer = tmpLayer;
        HistoryLoadTask task = new HistoryLoadTask();
        for (long id : ids) {
            task.add(id, type);
        }
        Main.worker.execute((Runnable)task);
        Runnable r = new Runnable(){

            public void run() {
                ArrayList<Node> nodes = new ArrayList<Node>();
                Iterator i$ = ids.iterator();
                while (i$.hasNext()) {
                    HistoryOsmPrimitive hPrimitive2;
                    Relation primitive;
                    long id = (Long)i$.next();
                    History h = HistoryDataSet.getInstance().getHistory(id, type);
                    HistoryOsmPrimitive hPrimitive1 = h.getLatest();
                    boolean visible = hPrimitive1.isVisible();
                    if (visible) {
                        DownloadPrimitiveTask download = new DownloadPrimitiveTask((PrimitiveId)new SimplePrimitiveId(id, type), layer);
                        System.out.println(I18n.tr((String)"Will get {0}", (Object[])new Object[]{id}));
                        download.run();
                        System.out.println(I18n.tr((String)"Looking for {0}", (Object[])new Object[]{id}));
                        primitive = datas.getPrimitiveById(id, type);
                        System.out.println(I18n.tr((String)"Found {0}", (Object[])new Object[]{primitive.getId()}));
                        if (parent <= 0L || !type.equals((Object)OsmPrimitiveType.NODE)) continue;
                        nodes.add((Node)primitive);
                        continue;
                    }
                    if (type.equals((Object)OsmPrimitiveType.NODE)) {
                        hPrimitive2 = hPrimitive1;
                        Node node = new Node(id, (int)hPrimitive1.getVersion());
                        HistoryNode hNode = (HistoryNode)hPrimitive1;
                        node.setCoor(hNode.getCoords());
                        primitive = node;
                        if (parent > 0L) {
                            nodes.add(node);
                        }
                    } else if (type.equals((Object)OsmPrimitiveType.WAY)) {
                        hPrimitive1 = h.getLatest();
                        hPrimitive2 = h.getByVersion((long)(h.getNumVersions() - 1));
                        Way way = new Way(id, (int)hPrimitive1.getVersion());
                        HistoryWay hWay = (HistoryWay)hPrimitive2;
                        List nodeIds = hWay.getNodes();
                        Undelete.this.undelete(false, OsmPrimitiveType.NODE, nodeIds, id);
                        primitive = way;
                    } else {
                        primitive = new Relation();
                        hPrimitive1 = h.getLatest();
                        hPrimitive2 = h.getByVersion((long)(h.getNumVersions() - 1));
                        Relation rel = new Relation(id, (int)hPrimitive1.getVersion());
                        HistoryRelation hRel = (HistoryRelation)hPrimitive2;
                        ArrayList<RelationMember> members = new ArrayList<RelationMember>(hRel.getNumMembers());
                        for (org.openstreetmap.josm.data.osm.history.RelationMember m : hRel.getMembers()) {
                            OsmPrimitive p = datas.getPrimitiveById(m.getPrimitiveId(), m.getPrimitiveType());
                            if (p == null) {
                                switch (m.getPrimitiveType()) {
                                    case NODE: {
                                        p = new Node(m.getPrimitiveId());
                                        break;
                                    }
                                    case WAY: {
                                        p = new Way(m.getPrimitiveId());
                                        break;
                                    }
                                    case RELATION: {
                                        p = new Relation(m.getPrimitiveId());
                                    }
                                }
                                datas.addPrimitive(p);
                            }
                            members.add(new RelationMember(m.getRole(), p));
                        }
                        rel.setMembers(members);
                        primitive = rel;
                    }
                    User user = User.createOsmUser((long)hPrimitive1.getUid(), (String)hPrimitive1.getUser());
                    primitive.setUser(user);
                    primitive.setKeys(hPrimitive2.getTags());
                    primitive.put("history", "retrieved using undelete JOSM plugin");
                    primitive.setModified(true);
                    datas.addPrimitive((OsmPrimitive)primitive);
                }
                if (parent > 0L && type.equals((Object)OsmPrimitiveType.NODE)) {
                    Way parentWay = (Way)datas.getPrimitiveById(parent, OsmPrimitiveType.WAY);
                    parentWay.setNodes(nodes);
                }
            }
        };
        Main.worker.submit(r);
    }

    private class UndeleteAction
    extends JosmAction {
        private static final long serialVersionUID = 1L;

        public UndeleteAction() {
            super(I18n.tr((String)"Undelete object...", (Object[])new Object[0]), "undelete", I18n.tr((String)"Undelete object by id", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:undelete", (String)I18n.tr((String)"File: {0}", (Object[])new Object[]{I18n.tr((String)"Undelete object...", (Object[])new Object[0])}), (int)85, (int)3, (int)576), true);
        }

        public void actionPerformed(ActionEvent e) {
            JCheckBox layer = new JCheckBox(I18n.tr((String)"Separate Layer", (Object[])new Object[0]));
            layer.setToolTipText(I18n.tr((String)"Select if the data should be added into a new layer", (Object[])new Object[0]));
            layer.setSelected(Main.pref.getBoolean("undelete.newlayer"));
            JPanel all = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 2;
            gc.anchor = 23;
            gc.gridy = 0;
            gc.weightx = 0.0;
            all.add((Component)new JLabel(I18n.tr((String)"Object type:", (Object[])new Object[0])), gc);
            OsmPrimitiveTypesComboBox cbType = new OsmPrimitiveTypesComboBox();
            cbType.setToolTipText("Choose the OSM object type");
            cbType.setSelectedIndex(Main.pref.getInteger("undelete.lasttype", 0));
            gc.weightx = 1.0;
            all.add((Component)cbType, gc);
            gc.gridy = 1;
            gc.weightx = 0.0;
            all.add((Component)new JLabel(I18n.tr((String)"Object ID:", (Object[])new Object[0])), gc);
            OsmIdTextField tfId = new OsmIdTextField();
            tfId.setText(Main.pref.get("undelete.osmid"));
            tfId.setToolTipText(I18n.tr((String)"Enter the ID of the object that should be undeleted", (Object[])new Object[0]));
            tfId.getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(10, 0, false));
            gc.weightx = 1.0;
            all.add((Component)tfId, gc);
            gc.gridy = 2;
            gc.fill = 1;
            gc.weighty = 1.0;
            gc.weightx = 0.0;
            gc.gridy = 3;
            all.add((Component)layer, gc);
            ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr((String)"Undelete Object", (Object[])new Object[0]), new String[]{I18n.tr((String)"Undelete object", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])});
            dialog.setContent((Component)all, false);
            dialog.setButtonIcons(new String[]{"undelete.png", "cancel.png"});
            dialog.setToolTipTexts(new String[]{I18n.tr((String)"Start undeleting", (Object[])new Object[0]), I18n.tr((String)"Close dialog and cancel", (Object[])new Object[0])});
            dialog.setDefaultButton(1);
            dialog.showDialog();
            if (dialog.getValue() != 1) {
                return;
            }
            Main.pref.putInteger("undelete.lasttype", Integer.valueOf(cbType.getSelectedIndex()));
            Main.pref.put("undelete.newlayer", layer.isSelected());
            Main.pref.put("undelete.osmid", Long.toString(tfId.getOsmId()));
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(tfId.getOsmId());
            Undelete.this.undelete(layer.isSelected(), cbType.getType(), ids, 0L);
        }
    }
}

