/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.videomapping;

import java.awt.event.ActionEvent;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.Action;
import javax.swing.InputVerifier;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.text.MaskFormatter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.videomapping.VideoPositionLayer;
import org.openstreetmap.josm.plugins.videomapping.video.GPSVideoPlayer;
import org.openstreetmap.josm.plugins.videomapping.video.VideoEngine;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class VideoPlugin
extends Plugin
implements MapView.LayerChangeListener {
    private JMenu VMenu;
    private JMenu VDeinterlacer;
    private JosmAction VAdd;
    private JosmAction VRemove;
    private JosmAction VStart;
    private JosmAction Vbackward;
    private JosmAction Vforward;
    private JosmAction VJump;
    private JosmAction Vfaster;
    private JosmAction Vslower;
    private JosmAction Vloop;
    private JRadioButtonMenuItem VIntBob;
    private JRadioButtonMenuItem VIntNone;
    private JRadioButtonMenuItem VIntLinear;
    private JCheckBoxMenuItem VCenterIcon;
    private JCheckBoxMenuItem VSubTitles;
    private JMenuItem VJumpLength;
    private JMenuItem VLoopLength;
    private final String PROP_MRU = "videomapping.mru";
    private final String PROP_AUTOCENTER = "videomapping.autocenter";
    private final String PROP_JUMPLENGTH = "videomapping.jumplength";
    private final String PROP_LOOPLENGTH = "videomapping.looplength";
    private String deinterlacer;
    private boolean autoCenter;
    private Integer jumpLength;
    private Integer loopLength;
    private String mostRecentFolder;
    private GpxLayer gpsLayer;
    private VideoPositionLayer videoPositionLayer;
    private GPSVideoPlayer gpsVideoPlayer;

    public VideoPlugin(PluginInformation info) {
        super(info);
        VideoEngine.setupPlayer();
        MapView.addLayerChangeListener((MapView.LayerChangeListener)this);
        this.createMenusAndShortCuts();
        this.enableVideoControlMenus(false);
        this.setDefaults();
        this.loadProperties();
    }

    private void createMenusAndShortCuts() {
        MainMenu mainMenu = Main.main.menu;
        Main.main.menu.getClass();
        this.VMenu = mainMenu.addMenu(" Video", 86, 6, HelpUtil.ht((String)"/Plugin/Videomapping"));
        this.VMenu.setEnabled(false);
        this.VAdd = new JosmAction(I18n.tr((String)"Import Video", (Object[])new Object[0]), "videomapping", I18n.tr((String)"Sync a video against this GPS track", (Object[])new Object[0]), null, false){

            public void actionPerformed(ActionEvent arg0) {
                VideoPlugin.this.importVideoFile();
            }
        };
        this.VRemove = new JosmAction(I18n.tr((String)"Remove Video", (Object[])new Object[0]), "videomapping", I18n.tr((String)"removes current video from layer", (Object[])new Object[0]), null, false){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent arg0) {
            }
        };
        this.VStart = new JosmAction(I18n.tr((String)"Play/Pause", (Object[])new Object[0]), "audio-playpause", I18n.tr((String)"starts/pauses video playback", (Object[])new Object[0]), Shortcut.registerShortcut((String)"videomapping:startstop", (String)("Video: " + I18n.tr((String)"Play/Pause", (Object[])new Object[0])), (int)101, (int)5), false){

            public void actionPerformed(ActionEvent e) {
                VideoPlugin.this.gpsVideoPlayer.pause();
            }
        };
        this.Vbackward = new JosmAction(I18n.tr((String)"Backward", (Object[])new Object[0]), "audio-prev", I18n.tr((String)"jumps n sec back", (Object[])new Object[0]), Shortcut.registerShortcut((String)"videomapping:backward", (String)("Video: " + I18n.tr((String)"Backward", (Object[])new Object[0])), (int)100, (int)5), false){

            public void actionPerformed(ActionEvent e) {
                VideoPlugin.this.gpsVideoPlayer.backward();
            }
        };
        this.Vforward = new JosmAction(I18n.tr((String)"Forward", (Object[])new Object[0]), "audio-next", I18n.tr((String)"jumps n sec forward", (Object[])new Object[0]), Shortcut.registerShortcut((String)"videomapping:forward", (String)("Video: " + I18n.tr((String)"Forward", (Object[])new Object[0])), (int)102, (int)5), false){

            public void actionPerformed(ActionEvent e) {
                VideoPlugin.this.gpsVideoPlayer.forward();
            }
        };
        this.Vfaster = new JosmAction(I18n.tr((String)"Faster", (Object[])new Object[0]), "audio-faster", I18n.tr((String)"faster playback", (Object[])new Object[0]), Shortcut.registerShortcut((String)"videomapping:faster", (String)("Video: " + I18n.tr((String)"Faster", (Object[])new Object[0])), (int)104, (int)5), false){

            public void actionPerformed(ActionEvent e) {
                VideoPlugin.this.gpsVideoPlayer.setSpeed(VideoPlugin.this.gpsVideoPlayer.getSpeed() + 20);
            }
        };
        this.Vslower = new JosmAction(I18n.tr((String)"Slower", (Object[])new Object[0]), "audio-slower", I18n.tr((String)"slower playback", (Object[])new Object[0]), Shortcut.registerShortcut((String)"videomapping:slower", (String)("Video: " + I18n.tr((String)"Slower", (Object[])new Object[0])), (int)98, (int)5), false){

            public void actionPerformed(ActionEvent e) {
                VideoPlugin.this.gpsVideoPlayer.setSpeed(VideoPlugin.this.gpsVideoPlayer.getSpeed() - 20);
            }
        };
        this.VJump = new JosmAction(I18n.tr((String)"Jump To", (Object[])new Object[0]), "jumpto", I18n.tr((String)"jumps to the entered gps time", (Object[])new Object[0]), null, false){

            public void actionPerformed(ActionEvent e) {
                VideoPlugin.this.showJumpTo();
            }
        };
        this.Vloop = new JosmAction(I18n.tr((String)"Loop", (Object[])new Object[0]), "loop", I18n.tr((String)"loops n sec around current position", (Object[])new Object[0]), Shortcut.registerShortcut((String)"videomapping:loop", (String)("Video: " + I18n.tr((String)"loop", (Object[])new Object[0])), (int)103, (int)5), false){

            public void actionPerformed(ActionEvent e) {
                VideoPlugin.this.gpsVideoPlayer.toggleLooping();
            }
        };
        this.VCenterIcon = new JCheckBoxMenuItem((Action)new JosmAction(I18n.tr((String)"Keep centered", (Object[])new Object[0]), null, I18n.tr((String)"follows the video icon automaticly", (Object[])new Object[0]), null, false){

            public void actionPerformed(ActionEvent e) {
                VideoPlugin.this.videoPositionLayer.setAutoCenter(VideoPlugin.this.VCenterIcon.isSelected());
            }
        });
        this.VSubTitles = new JCheckBoxMenuItem((Action)new JosmAction(I18n.tr((String)"Subtitles", (Object[])new Object[0]), null, I18n.tr((String)"Show subtitles in video", (Object[])new Object[0]), null, false){

            public void actionPerformed(ActionEvent e) {
                VideoPlugin.this.gpsVideoPlayer.setSubtitles(VideoPlugin.this.VSubTitles.isSelected());
            }
        });
        this.VJumpLength = new JMenuItem((Action)new JosmAction(I18n.tr((String)"Jump length", (Object[])new Object[0]), null, I18n.tr((String)"Set the length of a jump", (Object[])new Object[0]), null, false){

            public void actionPerformed(ActionEvent e) {
                Object[] possibilities = new Object[]{"200", "500", "1000", "2000", "10000"};
                String s = (String)JOptionPane.showInputDialog(Main.parent, I18n.tr((String)"Jump in video for x ms", (Object[])new Object[0]), I18n.tr((String)"Jump length", (Object[])new Object[0]), 3, null, possibilities, VideoPlugin.this.jumpLength);
                VideoPlugin.this.jumpLength = Integer.getInteger(s);
                VideoPlugin.this.saveProperties();
            }
        });
        this.VLoopLength = new JMenuItem((Action)new JosmAction(I18n.tr((String)"Loop length", (Object[])new Object[0]), null, I18n.tr((String)"Set the length around a looppoint", (Object[])new Object[0]), null, false){

            public void actionPerformed(ActionEvent e) {
                Object[] possibilities = new Object[]{"500", "1000", "3000", "5000", "10000"};
                String s = (String)JOptionPane.showInputDialog(Main.parent, I18n.tr((String)"Jump in video for x ms", (Object[])new Object[0]), I18n.tr((String)"Loop length", (Object[])new Object[0]), 3, null, possibilities, VideoPlugin.this.loopLength);
                VideoPlugin.this.loopLength = Integer.getInteger(s);
                VideoPlugin.this.saveProperties();
            }
        });
        this.VDeinterlacer = new JMenu("Deinterlacer");
        this.VIntNone = new JRadioButtonMenuItem((Action)new JosmAction(I18n.tr((String)"none", (Object[])new Object[0]), null, I18n.tr((String)"no deinterlacing", (Object[])new Object[0]), null, false){

            public void actionPerformed(ActionEvent e) {
                VideoPlugin.this.gpsVideoPlayer.setDeinterlacer("none");
            }
        });
        this.VIntBob = new JRadioButtonMenuItem((Action)new JosmAction("bob", null, I18n.tr((String)"deinterlacing using line doubling", (Object[])new Object[0]), null, false){

            public void actionPerformed(ActionEvent e) {
                VideoPlugin.this.gpsVideoPlayer.setDeinterlacer("bob");
            }
        });
        this.VIntLinear = new JRadioButtonMenuItem((Action)new JosmAction("linear", null, I18n.tr((String)"deinterlacing using linear interpolation", (Object[])new Object[0]), null, false){

            public void actionPerformed(ActionEvent e) {
                VideoPlugin.this.gpsVideoPlayer.setDeinterlacer("linear");
            }
        });
        this.VDeinterlacer.add(this.VIntNone);
        this.VDeinterlacer.add(this.VIntBob);
        this.VDeinterlacer.add(this.VIntLinear);
        this.VMenu.add((Action)this.VAdd);
        this.VMenu.add((Action)this.VStart);
        this.VMenu.add((Action)this.Vbackward);
        this.VMenu.add((Action)this.Vforward);
        this.VMenu.add((Action)this.Vfaster);
        this.VMenu.add((Action)this.Vslower);
        this.VMenu.add((Action)this.Vloop);
        this.VMenu.add((Action)this.VJump);
        this.VMenu.addSeparator();
        this.VMenu.add(this.VCenterIcon);
        this.VMenu.add(this.VJumpLength);
        this.VMenu.add(this.VLoopLength);
        this.VMenu.add(this.VDeinterlacer);
        this.VMenu.add(this.VSubTitles);
    }

    protected void importVideoFile() {
        JFileChooser fc = new JFileChooser(this.mostRecentFolder);
        fc.setSelectedFile(new File(this.mostRecentFolder));
        if (fc.showOpenDialog(Main.parent) != 1) {
            this.mostRecentFolder = fc.getSelectedFile().getAbsolutePath();
            this.saveProperties();
            if (this.videoPositionLayer == null) {
                this.videoPositionLayer = new VideoPositionLayer(this.gpsLayer);
                this.gpsVideoPlayer = new GPSVideoPlayer(new SimpleDateFormat("hh:mm:ss"), this.videoPositionLayer);
                this.gpsVideoPlayer.setJumpLength(this.jumpLength.intValue());
                this.gpsVideoPlayer.setLoopLength(this.loopLength.intValue());
                this.enableVideoControlMenus(true);
            }
            this.gpsVideoPlayer.addVideo(fc.getSelectedFile());
        }
    }

    private void enableVideoControlMenus(boolean b) {
        this.VStart.setEnabled(b);
        this.Vbackward.setEnabled(b);
        this.Vforward.setEnabled(b);
        this.Vloop.setEnabled(b);
        this.Vfaster.setEnabled(b);
        this.Vslower.setEnabled(b);
        this.VJump.setEnabled(b);
    }

    private void setDefaults() {
        this.autoCenter = false;
        this.deinterlacer = "";
        this.jumpLength = 1000;
        this.loopLength = 6000;
        this.mostRecentFolder = System.getProperty("user.home");
    }

    private void loadProperties() {
        String temp = Main.pref.get("videomapping.autocenter");
        if (temp != null && temp.length() != 0) {
            this.autoCenter = Boolean.getBoolean(temp);
        }
        if ((temp = Main.pref.get("videomapping.jumplength")) != null && temp.length() != 0) {
            this.jumpLength = Integer.valueOf(temp);
        }
        if ((temp = Main.pref.get("videomapping.looplength")) != null && temp.length() != 0) {
            this.loopLength = Integer.valueOf(temp);
        }
        if ((temp = Main.pref.get("videomapping.mru")) != null && temp.length() != 0) {
            this.mostRecentFolder = Main.pref.get("videomapping.mru");
        }
    }

    private void saveProperties() {
        Main.pref.put("videomapping.autocenter", this.autoCenter);
        Main.pref.put("videomapping.jumplength", this.jumpLength.toString());
        Main.pref.put("videomapping.looplength", this.loopLength.toString());
        Main.pref.put("videomapping.mru", this.mostRecentFolder);
    }

    private void showJumpTo() {
        try {
            JOptionPane d = new JOptionPane(I18n.tr((String)"Jump to", (Object[])new Object[0]), 3, 2);
            SimpleDateFormat gpsTimeFormat = new SimpleDateFormat("HH:mm:ss");
            String timerange = gpsTimeFormat.format(this.videoPositionLayer.getFirstWayPoint().getTime()) + " - ";
            timerange = timerange + gpsTimeFormat.format(this.videoPositionLayer.getLastWayPoint().getTime());
            d.add(new JLabel(timerange));
            final JFormattedTextField inp = new JFormattedTextField(new MaskFormatter("##:##:##"));
            inp.setText(gpsTimeFormat.format(this.videoPositionLayer.getGPSDate()));
            inp.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    return false;
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    inp.requestFocus();
                    inp.setCaretPosition(0);
                }
            });
            if (JOptionPane.showConfirmDialog(Main.panel, inp, I18n.tr((String)"Jump to GPS time", (Object[])new Object[0]), 2) == 0) {
                Date t = gpsTimeFormat.parse(inp.getText());
                Calendar time = Calendar.getInstance();
                Calendar date = Calendar.getInstance();
                time.setTime(t);
                date.setTime(this.videoPositionLayer.getFirstWayPoint().getTime());
                time.set(date.get(1), date.get(2), date.get(5));
                if (t != null) {
                    this.videoPositionLayer.jump(time.getTime());
                }
            }
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
        this.VMenu.setEnabled(true);
        if (newLayer instanceof GpxLayer) {
            this.VAdd.setEnabled(true);
            this.gpsLayer = (GpxLayer)newLayer;
        }
    }

    public void layerAdded(Layer arg0) {
        this.activeLayerChange(null, arg0);
    }

    public void layerRemoved(Layer arg0) {
        if (arg0 instanceof VideoPositionLayer) {
            this.enableVideoControlMenus(false);
        }
        this.activeLayerChange(null, arg0);
    }
}

