/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.isomorphism;

import java.util.HashMap;
import java.util.List;
import org.jgrapht.Graph;
import org.jgrapht.GraphMapping;
import org.jgrapht.graph.DefaultGraphMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsomorphismRelation<V, E>
implements GraphMapping<V, E> {
    private List<V> vertexList1;
    private List<V> vertexList2;
    private GraphMapping<V, E> graphMapping = null;
    private Graph<V, E> graph1;
    private Graph<V, E> graph2;

    public IsomorphismRelation(List<V> list, List<V> list2, Graph<V, E> graph, Graph<V, E> graph2) {
        this.vertexList1 = list;
        this.vertexList2 = list2;
        this.graph1 = graph;
        this.graph2 = graph2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("vertexList1: ").append(this.vertexList1.toString());
        stringBuffer.append("\tvertexList2: ").append(this.vertexList2.toString());
        return stringBuffer.toString();
    }

    @Override
    public V getVertexCorrespondence(V v, boolean bl) {
        if (this.graphMapping == null) {
            this.initGraphMapping();
        }
        return this.graphMapping.getVertexCorrespondence(v, bl);
    }

    @Override
    public E getEdgeCorrespondence(E e, boolean bl) {
        if (this.graphMapping == null) {
            this.initGraphMapping();
        }
        return this.graphMapping.getEdgeCorrespondence(e, bl);
    }

    private void initGraphMapping() {
        int n = this.vertexList1.size();
        HashMap<V, V> hashMap = new HashMap<V, V>(n);
        HashMap<V, V> hashMap2 = new HashMap<V, V>(n);
        for (int i = 0; i < n; ++i) {
            V v = this.vertexList1.get(i);
            V v2 = this.vertexList2.get(i);
            hashMap.put(v, v2);
            hashMap2.put(v2, v);
        }
        this.graphMapping = new DefaultGraphMapping(hashMap, hashMap2, this.graph1, this.graph2);
    }
}

