/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import reverter.ChangesetIdQuery;
import reverter.ChangesetReverter;
import reverter.RevertChangesetCommand;

public class RevertChangesetAction
extends JosmAction {
    public RevertChangesetAction() {
        super(I18n.tr((String)"Revert changeset", (Object[])new Object[0]), "revert-changeset", I18n.tr((String)"Revert changeset", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tool:revert", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Revert changeset", (Object[])new Object[0])}), (int)84, (int)3, (int)1), true);
    }

    protected void updateEnabledState() {
        this.setEnabled(RevertChangesetAction.getCurrentDataSet() != null);
    }

    public void actionPerformed(ActionEvent arg0) {
        if (RevertChangesetAction.getCurrentDataSet() == null) {
            return;
        }
        ChangesetIdQuery dlg = new ChangesetIdQuery();
        dlg.setVisible(true);
        if (dlg.getValue() != 1) {
            return;
        }
        final int changesetId = dlg.getChangesetId();
        final ChangesetReverter.RevertType revertType = dlg.getRevertType();
        if (changesetId == 0) {
            return;
        }
        if (revertType == null) {
            return;
        }
        Main.worker.submit((Runnable)new PleaseWaitRunnable(I18n.tr((String)"Reverting...", (Object[])new Object[0])){
            private ChangesetReverter rev;
            private boolean downloadConfirmed;
            {
                super(x0);
                this.downloadConfirmed = false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean checkAndDownloadMissing() throws OsmTransferException {
                if (!this.rev.hasMissingObjects()) {
                    return true;
                }
                if (!this.downloadConfirmed) {
                    boolean bl = this.downloadConfirmed = JOptionPane.showConfirmDialog(Main.parent, I18n.tr((String)"This changeset has objects that are not present in current dataset.\nIt is needed to download them before reverting. Do you want to continue?", (Object[])new Object[0]), I18n.tr((String)"Confirm", (Object[])new Object[0]), 0) == 0;
                    if (!this.downloadConfirmed) {
                        return false;
                    }
                }
                PleaseWaitProgressMonitor monitor = new PleaseWaitProgressMonitor(I18n.tr((String)"Fetching missing primitives", (Object[])new Object[0]));
                try {
                    this.rev.downloadMissingPrimitives((ProgressMonitor)monitor);
                }
                finally {
                    monitor.close();
                }
                return !monitor.isCanceled();
            }

            protected void realRun() throws OsmTransferException {
                this.progressMonitor.indeterminateSubTask(I18n.tr((String)"Downloading changeset", (Object[])new Object[0]));
                this.rev = new ChangesetReverter(changesetId, revertType, this.progressMonitor.createSubTaskMonitor(0, true));
                if (this.progressMonitor.isCanceled()) {
                    return;
                }
                this.rev.checkMissingCreated();
                this.rev.checkMissingUpdated();
                if (this.rev.hasMissingObjects()) {
                    this.rev.checkMissingDeleted();
                    if (!this.checkAndDownloadMissing()) {
                        return;
                    }
                } else {
                    this.rev.checkMissingDeleted();
                    this.rev.downloadMissingPrimitives(this.progressMonitor.createSubTaskMonitor(0, false));
                }
                if (this.progressMonitor.isCanceled()) {
                    return;
                }
                this.rev.downloadObjectsHistory(this.progressMonitor.createSubTaskMonitor(-1, false));
                if (this.progressMonitor.isCanceled()) {
                    return;
                }
                if (!this.checkAndDownloadMissing()) {
                    return;
                }
                List<Command> cmds = this.rev.getCommands();
                RevertChangesetCommand cmd = new RevertChangesetCommand(I18n.tr((String)(revertType == ChangesetReverter.RevertType.FULL ? "Revert changeset #{0}" : "Partially revert changeset #{0}"), (Object[])new Object[]{changesetId}), cmds);
                Main.main.undoRedo.add((Command)cmd);
            }

            protected void cancel() {
            }

            protected void finish() {
            }
        });
    }
}

