/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.piclayer.LoadPictureCalibrationAction;
import org.openstreetmap.josm.plugins.piclayer.ResetPictureAllAction;
import org.openstreetmap.josm.plugins.piclayer.ResetPictureAngleAction;
import org.openstreetmap.josm.plugins.piclayer.ResetPicturePositionAction;
import org.openstreetmap.josm.plugins.piclayer.ResetPictureScaleAction;
import org.openstreetmap.josm.plugins.piclayer.ResetPictureShearAction;
import org.openstreetmap.josm.plugins.piclayer.SavePictureCalibrationAction;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public abstract class PicLayerAbstract
extends Layer {
    private static int m_counter = 0;
    private Image m_image = null;
    private EastNorth m_initial_position;
    private EastNorth m_position;
    private double m_angle = 0.0;
    private double m_scalex = 1.0;
    private double m_scaley = 1.0;
    private double m_shearx = 0.0;
    private double m_sheary = 0.0;
    private double m_initial_scale = 1.0;
    private Icon m_layericon = null;
    private final String INITIAL_POS_X = "INITIAL_POS_X";
    private final String INITIAL_POS_Y = "INITIAL_POS_y";
    private final String POSITION_X = "POSITION_X";
    private final String POSITION_Y = "POSITION_Y";
    private final String ANGLE = "ANGLE";
    private final String INITIAL_SCALE = "INITIAL_SCALE";
    private final String SCALEX = "SCALEX";
    private final String SCALEY = "SCALEY";
    private final String SHEARX = "SHEARX";
    private final String SHEARY = "SHEARY";

    public PicLayerAbstract() {
        super("PicLayer #" + m_counter);
        ++m_counter;
        this.m_layericon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(PicLayerAbstract.class.getResource("/images/layericon.png")));
    }

    public void initialize() throws IOException {
        if (Main.map == null || Main.map.mapView == null) {
            throw new IOException(I18n.tr((String)"Could not find the map object.", (Object[])new Object[0]));
        }
        EastNorth center = Main.map.mapView.getCenter();
        this.m_initial_position = new EastNorth(center.east(), center.north());
        this.m_position = new EastNorth(center.east(), center.north());
        this.m_initial_scale = Main.map.mapView.getDist100Pixel();
        this.m_image = this.createImage();
        if (this.m_image == null) {
            throw new IOException(I18n.tr((String)"PicLayer failed to load or import the image.", (Object[])new Object[0]));
        }
        new ImageIcon(this.m_image).getImage();
        this.lookForCalibration();
    }

    protected abstract Image createImage() throws IOException;

    protected abstract void lookForCalibration() throws IOException;

    protected abstract String getPicLayerName();

    public Icon getIcon() {
        return this.m_layericon;
    }

    public Object getInfoComponent() {
        return null;
    }

    public Action[] getMenuEntries() {
        return new Action[]{new ResetSubmenuAction(), Layer.SeparatorLayerAction.INSTANCE, new SavePictureCalibrationAction(this), new LoadPictureCalibrationAction(this), Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(null, (Layer)this)};
    }

    public String getToolTipText() {
        return this.getPicLayerName();
    }

    public boolean isMergable(Layer arg0) {
        return false;
    }

    public void mergeFrom(Layer arg0) {
    }

    public void paint(Graphics2D g2, MapView mv, Bounds bounds) {
        if (this.m_image != null) {
            EastNorth center = Main.map.mapView.getCenter();
            EastNorth leftop = Main.map.mapView.getEastNorth(0, 0);
            double pixel_per_en = (double)Main.map.mapView.getWidth() / 2.0 / (center.east() - leftop.east());
            double pic_offset_x = (this.m_position.east() - leftop.east()) * pixel_per_en;
            double pic_offset_y = (leftop.north() - this.m_position.north()) * pixel_per_en;
            Graphics2D g = (Graphics2D)g2.create();
            g.translate(pic_offset_x, pic_offset_y);
            g.rotate(this.m_angle * Math.PI / 180.0);
            double scalex = this.m_scalex * this.m_initial_scale * pixel_per_en / this.getMetersPerEasting(this.m_position) / 100.0;
            double scaley = this.m_scaley * this.m_initial_scale * pixel_per_en / this.getMetersPerNorthing(this.m_position) / 100.0;
            g.scale(scalex, scaley);
            g.shear(this.m_shearx, this.m_sheary);
            g.drawImage(this.m_image, -this.m_image.getWidth(null) / 2, -this.m_image.getHeight(null) / 2, null);
            if (Main.map.mapView.getActiveLayer() == this) {
                g.setColor(new Color(0xFF0000));
                g.drawRect(-this.m_image.getWidth(null) / 2, -this.m_image.getHeight(null) / 2, this.m_image.getWidth(null), this.m_image.getHeight(null));
            }
        } else {
            System.out.println("PicLayerAbstract::paint - general drawing error (m_image is null or Graphics not 2D");
        }
    }

    private double getMetersPerEasting(EastNorth en) {
        double naturalScale = Main.getProjection().getDefaultZoomInPPD();
        LatLon ll1 = Main.getProjection().eastNorth2latlon(new EastNorth(en.east() - (naturalScale *= 0.01), en.north()));
        LatLon ll2 = Main.getProjection().eastNorth2latlon(new EastNorth(en.east() + naturalScale, en.north()));
        double dist = ll1.greatCircleDistance(ll2) / naturalScale / 2.0;
        return dist;
    }

    private double getMetersPerNorthing(EastNorth en) {
        double naturalScale = Main.getProjection().getDefaultZoomInPPD();
        LatLon ll1 = Main.getProjection().eastNorth2latlon(new EastNorth(en.east(), en.north() - (naturalScale *= 0.01)));
        LatLon ll2 = Main.getProjection().eastNorth2latlon(new EastNorth(en.east(), en.north() + naturalScale));
        double dist = ll1.greatCircleDistance(ll2) / naturalScale / 2.0;
        return dist;
    }

    public void movePictureBy(double east, double north) {
        this.m_position = this.m_position.add(east, north);
    }

    public void scalePictureBy(double scalex, double scaley) {
        this.m_scalex *= scalex;
        this.m_scaley *= scaley;
    }

    public void rotatePictureBy(double angle) {
        this.m_angle += angle;
    }

    public void shearPictureBy(double shearx, double sheary) {
        this.m_shearx += shearx;
        this.m_sheary += sheary;
    }

    public void resetPosition() {
        this.m_position = this.m_initial_position;
    }

    public void resetScale() {
        this.m_scalex = 1.0;
        this.m_scaley = 1.0;
    }

    public void resetAngle() {
        this.m_angle = 0.0;
    }

    public void resetShear() {
        this.m_shearx = 0.0;
        this.m_sheary = 0.0;
    }

    public void visitBoundingBox(BoundingXYVisitor arg0) {
        if (this.m_image == null) {
            return;
        }
        String projcode = Main.getProjection().toCode();
        if (projcode.equals("EPSG:4326")) {
            return;
        }
        EastNorth center = this.m_position;
        double w = this.m_image.getWidth(null);
        double h = this.m_image.getHeight(null);
        double diag_pix = Math.sqrt(w * w + h * h);
        double diag_m = diag_pix / 100.0 * this.m_initial_scale;
        double factor = Math.max(this.m_scalex, this.m_scaley);
        double offset = factor * diag_m / 2.0;
        EastNorth topleft = center.add(-offset, -offset);
        EastNorth bottomright = center.add(offset, offset);
        arg0.visit(topleft);
        arg0.visit(bottomright);
    }

    public void saveCalibration(Properties props) {
        props.put("INITIAL_POS_X", "" + this.m_initial_position.getX());
        props.put("INITIAL_POS_y", "" + this.m_initial_position.getY());
        props.put("POSITION_X", "" + this.m_position.getX());
        props.put("POSITION_Y", "" + this.m_position.getY());
        props.put("INITIAL_SCALE", "" + this.m_initial_scale);
        props.put("SCALEX", "" + this.m_scalex);
        props.put("SCALEY", "" + this.m_scaley);
        props.put("ANGLE", "" + this.m_angle);
        props.put("SHEARX", "" + this.m_shearx);
        props.put("SHEARY", "" + this.m_sheary);
    }

    public void loadCalibration(InputStream is) throws IOException {
        Properties props = new Properties();
        props.load(is);
        this.loadCalibration(props);
    }

    public void loadCalibration(Properties props) {
        double pos_x = Double.valueOf(props.getProperty("POSITION_X"));
        double pos_y = Double.valueOf(props.getProperty("POSITION_Y"));
        double in_pos_x = Double.valueOf(props.getProperty("INITIAL_POS_X"));
        double in_pos_y = Double.valueOf(props.getProperty("INITIAL_POS_y"));
        double angle = Double.valueOf(props.getProperty("ANGLE"));
        double in_scale = Double.valueOf(props.getProperty("INITIAL_SCALE"));
        double scale_x = Double.valueOf(props.getProperty("SCALEX"));
        double scale_y = Double.valueOf(props.getProperty("SCALEY"));
        double shear_x = Double.valueOf(props.getProperty("SHEARX"));
        double shear_y = Double.valueOf(props.getProperty("SHEARY"));
        this.m_position.setLocation(pos_x, pos_y);
        this.m_initial_position.setLocation(pos_x, pos_y);
        this.m_angle = angle;
        this.m_scalex = scale_x;
        this.m_scaley = scale_y;
        this.m_shearx = shear_x;
        this.m_sheary = shear_y;
        this.m_initial_scale = in_scale;
        Main.map.mapView.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadWorldfile(InputStream is) throws IOException {
        BufferedReader br = null;
        try {
            InputStreamReader reader = new InputStreamReader(is);
            br = new BufferedReader(reader);
            double[] e = new double[6];
            for (int i = 0; i < 6; ++i) {
                String line = br.readLine();
                e[i] = Double.parseDouble(line);
            }
            double sx = e[0];
            double ry = e[1];
            double rx = e[2];
            double sy = e[3];
            double dx = e[4];
            double dy = e[5];
            int w = this.m_image.getWidth(null);
            int h = this.m_image.getHeight(null);
            this.m_position.setLocation(dx + (double)(w / 2) * sx + (double)(h / 2) * rx, dy + (double)(w / 2) * ry + (double)(h / 2) * sy);
            this.m_initial_position.setLocation((Point2D)this.m_position);
            this.m_angle = 0.0;
            this.m_scalex = 100.0 * sx * this.getMetersPerEasting(this.m_position);
            this.m_scaley = -100.0 * sy * this.getMetersPerNorthing(this.m_position);
            this.m_shearx = rx / sx;
            this.m_sheary = ry / sy;
            this.m_initial_scale = 1.0;
            Main.map.mapView.repaint();
        }
        catch (Throwable throwable) {
            Utils.close(br);
            throw throwable;
        }
        Utils.close((Reader)br);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResetSubmenuAction
    extends AbstractAction
    implements Layer.LayerAction {
        public ResetSubmenuAction() {
            super(I18n.tr((String)"Reset", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public Component createMenuComponent() {
            JMenu reset_submenu = new JMenu(this);
            reset_submenu.add((Action)((Object)new ResetPictureAllAction(PicLayerAbstract.this)));
            reset_submenu.addSeparator();
            reset_submenu.add((Action)((Object)new ResetPicturePositionAction(PicLayerAbstract.this)));
            reset_submenu.add((Action)((Object)new ResetPictureAngleAction(PicLayerAbstract.this)));
            reset_submenu.add((Action)((Object)new ResetPictureScaleAction(PicLayerAbstract.this)));
            reset_submenu.add((Action)((Object)new ResetPictureShearAction(PicLayerAbstract.this)));
            return reset_submenu;
        }

        public boolean supportLayers(List<Layer> layers) {
            return layers.size() == 1 && layers.get(0) instanceof PicLayerAbstract;
        }
    }
}

