/*
 * Decompiled with CFR 0.152.
 */
package toms.seamarks.buoys;

import java.util.Map;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import toms.Messages;
import toms.dialogs.SmpDialogAction;
import toms.seamarks.buoys.Buoy;

public class BuoyLat
extends Buoy {
    public BuoyLat(SmpDialogAction dia, Node node) {
        super(dia);
        Map keys = node.getKeys();
        this.setNode(node);
        this.resetMask();
        this.dlg.cbM01TypeOfMark.setSelectedIndex(1);
        this.dlg.cbM01CatOfMark.removeAllItems();
        this.dlg.cbM01CatOfMark.addItem(Messages.getString("SmpDialogAction.152"));
        this.dlg.cbM01CatOfMark.addItem(Messages.getString("SmpDialogAction.153"));
        this.dlg.cbM01CatOfMark.addItem(Messages.getString("SmpDialogAction.154"));
        this.dlg.cbM01CatOfMark.addItem(Messages.getString("SmpDialogAction.155"));
        this.dlg.cbM01CatOfMark.addItem(Messages.getString("SmpDialogAction.156"));
        this.dlg.rbM01RegionA.setEnabled(true);
        this.dlg.rbM01RegionB.setEnabled(true);
        this.dlg.cbM01CatOfMark.setEnabled(true);
        this.dlg.cbM01CatOfMark.setVisible(true);
        this.dlg.lM01CatOfMark.setVisible(true);
        this.dlg.cbM01StyleOfMark.removeAllItems();
        this.dlg.cbM01StyleOfMark.addItem(Messages.getString("SmpDialogAction.212"));
        this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.01"));
        this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.04"));
        this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.05"));
        this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.06"));
        this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.07"));
        this.dlg.cbM01StyleOfMark.setEnabled(true);
        if (keys.containsKey("name")) {
            this.setName((String)keys.get("name"));
        }
        if (keys.containsKey("seamark:name")) {
            this.setName((String)keys.get("seamark:name"));
        }
        if (keys.containsKey("seamark:longname")) {
            this.setLongname((String)keys.get("seamark:longname"));
        }
        if (keys.containsKey("seamark:fixme")) {
            this.setFixme((String)keys.get("seamark:fixme"));
        }
        if (keys.containsKey("seamark:buoy_lateral:name")) {
            this.setName((String)keys.get("seamark:buoy_lateral:name"));
        } else if (keys.containsKey("seamark:beacon_lateral:name")) {
            this.setName((String)keys.get("seamark:beacon_lateral:name"));
        } else if (keys.containsKey("seamark:light_float:name")) {
            this.setName((String)keys.get("seamark:light_float:name"));
        }
        String cat = "";
        String col = "";
        String top = "";
        if (keys.containsKey("seamark:buoy_lateral:category")) {
            cat = (String)keys.get("seamark:buoy_lateral:category");
        } else if (keys.containsKey("seamark:beacon_lateral:category")) {
            cat = (String)keys.get("seamark:beacon_lateral:category");
        }
        if (keys.containsKey("seamark:buoy_lateral:colour")) {
            col = (String)keys.get("seamark:buoy_lateral:colour");
        } else if (keys.containsKey("seamark:beacon_lateral:colour")) {
            col = (String)keys.get("seamark:beacon_lateral:colour");
        } else if (keys.containsKey("seamark:light_float:colour")) {
            col = (String)keys.get("seamark:light_float:colour");
        }
        if (this.getStyleIndex() != 7) {
            if (keys.containsKey("seamark:topmark:shape")) {
                top = (String)keys.get("seamark:topmark:shape");
                this.setTopMark(true);
            }
            if (keys.containsKey("seamark:topmark:colour")) {
                if (col.isEmpty()) {
                    col = (String)keys.get("seamark:topmark:colour");
                }
                this.setTopMark(true);
            }
        }
        if (col.isEmpty() && keys.containsKey("seamark:light:colour")) {
            col = (String)keys.get("seamark:light:colour");
        }
        if (cat.isEmpty()) {
            if (col.equals("red")) {
                this.setColour(1);
                if (top.equals("cylinder")) {
                    this.setBuoyIndex(1);
                    this.setRegion(false);
                } else if (top.equals("cone, point up")) {
                    this.setBuoyIndex(2);
                    this.setRegion(true);
                } else if (!this.getRegion()) {
                    this.setBuoyIndex(1);
                } else {
                    this.setBuoyIndex(2);
                }
            } else if (col.equals("green")) {
                this.setColour(2);
                if (top.equals("cone, point up")) {
                    this.setBuoyIndex(2);
                    this.setRegion(false);
                } else if (top.equals("cylinder")) {
                    this.setBuoyIndex(1);
                    this.setRegion(true);
                } else if (!this.getRegion()) {
                    this.setBuoyIndex(2);
                } else {
                    this.setBuoyIndex(1);
                }
            } else if (col.equals("red;green;red")) {
                this.setColour(3);
                if (top.equals("cylinder")) {
                    this.setBuoyIndex(3);
                    this.setRegion(false);
                } else if (top.equals("cone, point up")) {
                    this.setBuoyIndex(4);
                    this.setRegion(true);
                } else if (!this.getRegion()) {
                    this.setBuoyIndex(3);
                } else {
                    this.setBuoyIndex(4);
                }
            } else if (col.equals("green;red;green")) {
                this.setColour(4);
                if (top.equals("cone, point up")) {
                    this.setBuoyIndex(4);
                    this.setRegion(false);
                } else if (top.equals("cylinder")) {
                    this.setBuoyIndex(3);
                    this.setRegion(true);
                } else if (!this.getRegion()) {
                    this.setBuoyIndex(4);
                } else {
                    this.setBuoyIndex(3);
                }
            }
        } else if (cat.equals("port")) {
            this.setBuoyIndex(1);
            if (col.equals("red")) {
                this.setRegion(false);
                this.setColour(1);
            } else if (col.equals("green")) {
                this.setRegion(true);
                this.setColour(2);
            } else if (!this.getRegion()) {
                this.setColour(1);
            } else {
                this.setColour(2);
            }
        } else if (cat.equals("starboard")) {
            this.setBuoyIndex(2);
            if (col.equals("green")) {
                this.setRegion(false);
                this.setColour(2);
            } else if (col.equals("red")) {
                this.setRegion(true);
                this.setColour(1);
            } else if (!this.getRegion()) {
                this.setColour(2);
            } else {
                this.setColour(1);
            }
        } else if (cat.equals("preferred_channel_port")) {
            this.setBuoyIndex(3);
            if (col.equals("red;green;red")) {
                this.setRegion(false);
                this.setColour(3);
            } else if (col.equals("green;red;green")) {
                this.setRegion(true);
                this.setColour(4);
            } else if (!this.getRegion()) {
                this.setColour(3);
            } else {
                this.setColour(4);
            }
        } else if (cat.equals("preferred_channel_starboard")) {
            this.setBuoyIndex(4);
            if (col.equals("green;red;green")) {
                this.setRegion(false);
                this.setColour(4);
            } else if (col.equals("red;green;red")) {
                this.setRegion(true);
                this.setColour(3);
            } else if (!this.getRegion()) {
                this.setColour(4);
            } else {
                this.setColour(3);
            }
        }
        if (keys.containsKey("seamark:buoy_lateral:shape")) {
            String str = (String)keys.get("seamark:buoy_lateral:shape");
            switch (this.getBuoyIndex()) {
                case 1: {
                    if (str.equals("can")) {
                        this.setStyleIndex(1);
                        break;
                    }
                    if (str.equals("pillar")) {
                        this.setStyleIndex(2);
                        break;
                    }
                    if (!str.equals("spar")) break;
                    this.setStyleIndex(3);
                    break;
                }
                case 3: {
                    if (str.equals("can")) {
                        this.setStyleIndex(1);
                        break;
                    }
                    if (str.equals("pillar")) {
                        this.setStyleIndex(2);
                        break;
                    }
                    if (!str.equals("spar")) break;
                    this.setStyleIndex(3);
                    break;
                }
                case 2: {
                    if (str.equals("conical")) {
                        this.setStyleIndex(1);
                        break;
                    }
                    if (str.equals("pillar")) {
                        this.setStyleIndex(2);
                        break;
                    }
                    if (!str.equals("spar")) break;
                    this.setStyleIndex(3);
                    break;
                }
                case 4: {
                    if (str.equals("conical")) {
                        this.setStyleIndex(1);
                        break;
                    }
                    if (str.equals("pillar")) {
                        this.setStyleIndex(2);
                        break;
                    }
                    if (!str.equals("spar")) break;
                    this.setStyleIndex(3);
                }
            }
        } else if (keys.containsKey("seamark:beacon_lateral:shape")) {
            String str = (String)keys.get("seamark:beacon_lateral:shape");
            if (str.equals("tower")) {
                this.setStyleIndex(5);
            } else if (str.equals("perch")) {
                this.setStyleIndex(7);
            } else {
                this.setStyleIndex(4);
            }
        } else if (keys.containsKey("seamark:type") && ((String)keys.get("seamark:type")).equals("beacon_lateral")) {
            this.setStyleIndex(4);
        } else if (keys.containsKey("seamark:type") && ((String)keys.get("seamark:type")).equals("light_float")) {
            this.setStyleIndex(6);
        }
        if (keys.containsKey("seamark:buoy_lateral:system")) {
            this.setRegion(((String)keys.get("seamark:buoy_lateral:system")).equals("iala-b"));
        } else if (keys.containsKey("seamark:beacon_lateral:system")) {
            this.setRegion(((String)keys.get("seamark:beacon_lateral:system")).equals("iala-b"));
        } else if (keys.containsKey("seamark:light_float:system")) {
            this.setRegion(((String)keys.get("seamark:light_float:system")).equals("iala-b"));
        }
        this.refreshStyles();
        this.refreshLights();
        this.parseLights(keys);
        this.parseFogRadar(keys);
        this.setLightColour();
        this.dlg.cbM01CatOfMark.setSelectedIndex(this.getBuoyIndex());
        this.dlg.cbM01StyleOfMark.setSelectedIndex(this.getStyleIndex());
        this.dlg.tfM01Name.setText(this.getName());
        this.dlg.cM01TopMark.setSelected(this.hasTopMark());
    }

    public void refreshStyles() {
        int type = this.getBuoyIndex();
        int style = this.getStyleIndex();
        this.dlg.cbM01StyleOfMark.removeAllItems();
        this.dlg.cbM01StyleOfMark.addItem(Messages.getString("SmpDialogAction.213"));
        switch (type) {
            case 1: {
                this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.02"));
                this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.01"));
                this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.04"));
                this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.05"));
                this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.06"));
                this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.07"));
                this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.10"));
                break;
            }
            case 2: {
                this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.03"));
                this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.01"));
                this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.04"));
                this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.05"));
                this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.06"));
                this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.07"));
                this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.10"));
                break;
            }
            case 3: {
                this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.02"));
                this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.01"));
                this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.04"));
                this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.05"));
                this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.06"));
                this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.07"));
                break;
            }
            case 4: {
                this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.03"));
                this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.01"));
                this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.04"));
                this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.05"));
                this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.06"));
                this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.07"));
            }
        }
        if (style >= this.dlg.cbM01StyleOfMark.getItemCount()) {
            style = 0;
        }
        this.setStyleIndex(style);
        this.dlg.cbM01StyleOfMark.setSelectedIndex(style);
        this.dlg.cbM01StyleOfMark.setVisible(true);
        this.dlg.lM01StyleOfMark.setVisible(true);
    }

    public void refreshLights() {
        super.refreshLights();
    }

    public boolean isValid() {
        return this.getBuoyIndex() > 0 && this.getStyleIndex() > 0;
    }

    public void setLightColour() {
        if (!this.getRegion()) {
            if (this.getBuoyIndex() == 1 || this.getBuoyIndex() == 3) {
                super.setLightColour("R");
            } else {
                super.setLightColour("G");
            }
        } else if (this.getBuoyIndex() == 1 || this.getBuoyIndex() == 3) {
            super.setLightColour("G");
        } else {
            super.setLightColour("R");
        }
    }

    public void paintSign() {
        if (this.dlg.paintlock) {
            return;
        }
        super.paintSign();
        this.dlg.sM01StatusBar.setText(this.getErrMsg());
        if (this.isValid()) {
            this.dlg.tfM01Name.setEnabled(true);
            this.dlg.tfM01Name.setText(this.getName());
            boolean region = this.getRegion();
            int style = this.getStyleIndex();
            if (style == 7) {
                this.dlg.cM01TopMark.setVisible(false);
                this.dlg.cM01TopMark.setSelected(false);
                this.dlg.cM01Radar.setVisible(false);
                this.dlg.cM01Racon.setVisible(false);
                this.dlg.cM01Fog.setVisible(false);
                this.dlg.cM01Fired.setVisible(false);
                this.dlg.cM01Fired.setSelected(false);
            } else {
                this.dlg.cM01TopMark.setEnabled(true);
                this.dlg.cM01TopMark.setVisible(true);
                this.dlg.cM01Radar.setVisible(true);
                this.dlg.cM01Racon.setVisible(true);
                this.dlg.cM01Fog.setVisible(true);
                this.dlg.cM01Fired.setVisible(true);
                this.dlg.cM01Fired.setEnabled(true);
                this.dlg.cM01TopMark.setEnabled(true);
            }
            if (!this.isSectored()) {
                this.dlg.cbM01Colour.setVisible(false);
                this.dlg.lM01Colour.setVisible(false);
            }
            this.dlg.rbM01Fired1.setVisible(false);
            this.dlg.rbM01FiredN.setVisible(false);
            this.dlg.lM01Height.setVisible(false);
            this.dlg.tfM01Height.setVisible(false);
            this.dlg.lM01Range.setVisible(false);
            this.dlg.tfM01Range.setVisible(false);
            if (this.isFired()) {
                switch (style) {
                    case 4: 
                    case 5: 
                    case 6: {
                        this.dlg.lM01Height.setVisible(true);
                        this.dlg.tfM01Height.setVisible(true);
                        this.dlg.lM01Range.setVisible(true);
                        this.dlg.tfM01Range.setVisible(true);
                        break;
                    }
                }
            }
            String image = "/images/Lateral";
            block3 : switch (this.getBuoyIndex()) {
                case 1: {
                    if (!region) {
                        switch (style) {
                            case 1: {
                                image = image + "_Can_Red";
                                break block3;
                            }
                            case 2: {
                                image = image + "_Pillar_Red";
                                break block3;
                            }
                            case 3: {
                                image = image + "_Spar_Red";
                                break block3;
                            }
                            case 4: {
                                image = image + "_Beacon_Red";
                                break block3;
                            }
                            case 5: {
                                image = image + "_Tower_Red";
                                break block3;
                            }
                            case 6: {
                                image = image + "_Float_Red";
                                break block3;
                            }
                            case 7: {
                                image = image + "_Perch_Port";
                                break block3;
                            }
                        }
                        break;
                    }
                    switch (style) {
                        case 1: {
                            image = image + "_Can_Green";
                            break block3;
                        }
                        case 2: {
                            image = image + "_Pillar_Green";
                            break block3;
                        }
                        case 3: {
                            image = image + "_Spar_Green";
                            break block3;
                        }
                        case 4: {
                            image = image + "_Beacon_Green";
                            break block3;
                        }
                        case 5: {
                            image = image + "_Tower_Green";
                            break block3;
                        }
                        case 6: {
                            image = image + "_Float_Green";
                            break block3;
                        }
                        case 7: {
                            image = image + "_Perch_Port";
                            break block3;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!region) {
                        switch (style) {
                            case 1: {
                                image = image + "_Cone_Green";
                                break block3;
                            }
                            case 2: {
                                image = image + "_Pillar_Green";
                                break block3;
                            }
                            case 3: {
                                image = image + "_Spar_Green";
                                break block3;
                            }
                            case 4: {
                                image = image + "_Beacon_Green";
                                break block3;
                            }
                            case 5: {
                                image = image + "_Tower_Green";
                                break block3;
                            }
                            case 6: {
                                image = image + "_Float_Green";
                                break block3;
                            }
                            case 7: {
                                image = image + "_Perch_Starboard";
                                break block3;
                            }
                        }
                        break;
                    }
                    switch (style) {
                        case 1: {
                            image = image + "_Cone_Red";
                            break block3;
                        }
                        case 2: {
                            image = image + "_Pillar_Red";
                            break block3;
                        }
                        case 3: {
                            image = image + "_Spar_Red";
                            break block3;
                        }
                        case 4: {
                            image = image + "_Beacon_Red";
                            break block3;
                        }
                        case 5: {
                            image = image + "_Tower_Red";
                            break block3;
                        }
                        case 6: {
                            image = image + "_Float_Red";
                            break block3;
                        }
                        case 7: {
                            image = image + "_Perch_Starboard";
                            break block3;
                        }
                    }
                    break;
                }
                case 3: {
                    if (!region) {
                        switch (style) {
                            case 1: {
                                image = image + "_Can_Red_Green_Red";
                                break block3;
                            }
                            case 2: {
                                image = image + "_Pillar_Red_Green_Red";
                                break block3;
                            }
                            case 3: {
                                image = image + "_Spar_Red_Green_Red";
                                break block3;
                            }
                            case 4: {
                                image = image + "_Beacon_Red_Green_Red";
                                break block3;
                            }
                            case 5: {
                                image = image + "_Tower_Red_Green_Red";
                                break block3;
                            }
                            case 6: {
                                image = image + "_Float_Red_Green_Red";
                                break block3;
                            }
                        }
                        break;
                    }
                    switch (style) {
                        case 1: {
                            image = image + "_Can_Green_Red_Green";
                            break block3;
                        }
                        case 2: {
                            image = image + "_Pillar_Green_Red_Green";
                            break block3;
                        }
                        case 3: {
                            image = image + "_Spar_Green_Red_Green";
                            break block3;
                        }
                        case 4: {
                            image = image + "_Beacon_Green_Red_Green";
                            break block3;
                        }
                        case 5: {
                            image = image + "_Tower_Green_Red_Green";
                            break block3;
                        }
                        case 6: {
                            image = image + "_Float_Green_Red_Green";
                            break block3;
                        }
                    }
                    break;
                }
                case 4: {
                    if (!region) {
                        switch (style) {
                            case 1: {
                                image = image + "_Cone_Green_Red_Green";
                                break block3;
                            }
                            case 2: {
                                image = image + "_Pillar_Green_Red_Green";
                                break block3;
                            }
                            case 3: {
                                image = image + "_Spar_Green_Red_Green";
                                break block3;
                            }
                            case 4: {
                                image = image + "_Beacon_Green_Red_Green";
                                break block3;
                            }
                            case 5: {
                                image = image + "_Tower_Green_Red_Green";
                                break block3;
                            }
                            case 6: {
                                image = image + "_Float_Green_Red_Green";
                                break block3;
                            }
                        }
                        break;
                    }
                    switch (style) {
                        case 1: {
                            image = image + "_Cone_Red_Green_Red";
                            break block3;
                        }
                        case 2: {
                            image = image + "_Pillar_Red_Green_Red";
                            break block3;
                        }
                        case 3: {
                            image = image + "_Spar_Red_Green_Red";
                            break block3;
                        }
                        case 4: {
                            image = image + "_Beacon_Red_Green_Red";
                            break block3;
                        }
                        case 5: {
                            image = image + "_Tower_Red_Green_Red";
                            break block3;
                        }
                        case 6: {
                            image = image + "_Float_Red_Green_Red";
                            break block3;
                        }
                    }
                    break;
                }
            }
            if (!image.equals("/images/Lateral")) {
                image = image + ".png";
                this.dlg.lM01Icon.setIcon(new ImageIcon(this.getClass().getResource(image)));
                if (this.hasTopMark()) {
                    image = "";
                    block77 : switch (this.getBuoyIndex()) {
                        case 1: 
                        case 3: {
                            if (!region) {
                                switch (style) {
                                    case 1: {
                                        image = "/images/Top_Can_Red_Buoy_Small.png";
                                        break;
                                    }
                                    case 2: 
                                    case 3: {
                                        image = "/images/Top_Can_Red_Buoy.png";
                                        break;
                                    }
                                    case 4: 
                                    case 5: {
                                        image = "/images/Top_Can_Red_Beacon.png";
                                        break;
                                    }
                                    case 6: {
                                        image = "/images/Top_Can_Red_Float.png";
                                    }
                                }
                                break;
                            }
                            switch (style) {
                                case 1: {
                                    image = "/images/Top_Can_Green_Buoy_Small.png";
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    image = "/images/Top_Can_Green_Buoy.png";
                                    break;
                                }
                                case 4: 
                                case 5: {
                                    image = "/images/Top_Can_Green_Beacon.png";
                                    break;
                                }
                                case 6: {
                                    image = "/images/Top_Can_Green_Float.png";
                                }
                            }
                            break;
                        }
                        case 2: 
                        case 4: {
                            if (!region) {
                                switch (style) {
                                    case 1: {
                                        image = "/images/Top_Cone_Green_Buoy_Small.png";
                                        break;
                                    }
                                    case 2: 
                                    case 3: {
                                        image = "/images/Top_Cone_Green_Buoy.png";
                                        break;
                                    }
                                    case 4: 
                                    case 5: {
                                        image = "/images/Top_Cone_Green_Beacon.png";
                                        break;
                                    }
                                    case 6: {
                                        image = "/images/Top_Cone_Green_Float.png";
                                    }
                                }
                                break;
                            }
                            switch (style) {
                                case 1: {
                                    image = "/images/Top_Cone_Red_Buoy_Small.png";
                                    break block77;
                                }
                                case 2: 
                                case 3: {
                                    image = "/images/Top_Cone_Red_Buoy.png";
                                    break block77;
                                }
                                case 4: 
                                case 5: {
                                    image = "/images/Top_Cone_Red_Beacon.png";
                                    break block77;
                                }
                                case 6: {
                                    image = "/images/Top_Cone_Red_Float.png";
                                }
                            }
                        }
                    }
                    if (!image.isEmpty()) {
                        this.dlg.lM06Icon.setIcon(new ImageIcon(this.getClass().getResource(image)));
                    }
                }
            } else {
                this.dlg.lM01Icon.setIcon(null);
            }
        }
    }

    public void saveSign() {
        Node node = this.getNode();
        if (node == null) {
            return;
        }
        int cat = this.getBuoyIndex();
        String shape = "";
        String colour = "";
        switch (cat) {
            case 1: {
                switch (this.getStyleIndex()) {
                    case 1: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "can"));
                        break;
                    }
                    case 2: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "pillar"));
                        break;
                    }
                    case 3: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "spar"));
                        break;
                    }
                    case 4: {
                        super.saveSign("beacon_lateral");
                        break;
                    }
                    case 5: {
                        super.saveSign("beacon_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:shape", "tower"));
                        break;
                    }
                    case 6: {
                        super.saveSign("light_float");
                        break;
                    }
                    case 7: {
                        super.saveSign("beacon_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:shape", "perch"));
                        break;
                    }
                }
                switch (this.getStyleIndex()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:category", "port"));
                        if (!this.getRegion()) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:colour", "red"));
                            colour = "red";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:colour", "green"));
                        colour = "green";
                        break;
                    }
                    case 7: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:category", "port"));
                        break;
                    }
                    case 4: 
                    case 5: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:category", "port"));
                        if (!this.getRegion()) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:colour", "red"));
                            colour = "red";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:colour", "green"));
                        colour = "green";
                        break;
                    }
                    case 6: {
                        if (!this.getRegion()) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour", "red"));
                            colour = "red";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour", "green"));
                        colour = "green";
                    }
                }
                shape = "cylinder";
                break;
            }
            case 3: {
                switch (this.getStyleIndex()) {
                    case 1: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "can"));
                        break;
                    }
                    case 2: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "pillar"));
                        break;
                    }
                    case 3: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "spar"));
                        break;
                    }
                    case 4: {
                        super.saveSign("beacon_lateral");
                        break;
                    }
                    case 5: {
                        super.saveSign("beacon_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:shape", "tower"));
                        break;
                    }
                    case 6: {
                        super.saveSign("light_float");
                        break;
                    }
                }
                switch (this.getStyleIndex()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:category", "preferred_channel_port"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:colour_pattern", "horizontal"));
                        if (!this.getRegion()) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:colour", "red;green;red"));
                            colour = "red";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:colour", "green;red;green"));
                        colour = "green";
                        break;
                    }
                    case 4: 
                    case 5: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:category", "preferred_channel_port"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:colour_pattern", "horizontal"));
                        if (!this.getRegion()) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:colour", "red;green;red"));
                            colour = "red";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:colour", "green;red;green"));
                        colour = "green";
                        break;
                    }
                    case 6: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour_pattern", "horizontal"));
                        if (!this.getRegion()) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour", "red;green;red"));
                            colour = "red";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour", "green;red;green"));
                        colour = "green";
                    }
                }
                shape = "cylinder";
                break;
            }
            case 2: {
                switch (this.getStyleIndex()) {
                    case 1: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "conical"));
                        break;
                    }
                    case 2: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "pillar"));
                        break;
                    }
                    case 3: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "spar"));
                        break;
                    }
                    case 4: {
                        super.saveSign("beacon_lateral");
                        break;
                    }
                    case 5: {
                        super.saveSign("beacon_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:shape", "tower"));
                        break;
                    }
                    case 6: {
                        super.saveSign("light_float");
                        break;
                    }
                    case 7: {
                        super.saveSign("beacon_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:shape", "perch"));
                        break;
                    }
                }
                switch (this.getStyleIndex()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:category", "starboard"));
                        if (!this.getRegion()) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:colour", "green"));
                            colour = "green";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:colour", "red"));
                        colour = "red";
                        break;
                    }
                    case 4: 
                    case 5: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:category", "starboard"));
                        if (!this.getRegion()) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:colour", "green"));
                            colour = "green";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:colour", "red"));
                        colour = "red";
                        break;
                    }
                    case 6: {
                        if (!this.getRegion()) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour", "green"));
                            colour = "green";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour", "red"));
                        colour = "red";
                        break;
                    }
                    case 7: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:category", "starboard"));
                    }
                }
                shape = "cone, point up";
                break;
            }
            case 4: {
                switch (this.getStyleIndex()) {
                    case 1: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "conical"));
                        break;
                    }
                    case 2: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "pillar"));
                        break;
                    }
                    case 3: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "spar"));
                        break;
                    }
                    case 4: {
                        super.saveSign("beacon_lateral");
                        break;
                    }
                    case 5: {
                        super.saveSign("beacon_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:shape", "tower"));
                        break;
                    }
                    case 6: {
                        super.saveSign("light_float");
                        break;
                    }
                }
                switch (this.getStyleIndex()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:category", "preferred_channel_starboard"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:colour_pattern", "horizontal"));
                        if (!this.getRegion()) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:colour", "green;red;green"));
                            colour = "green";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:colour", "red;green;red"));
                        colour = "red";
                        break;
                    }
                    case 4: 
                    case 5: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:category", "preferred_channel_starboard"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:colour_pattern", "horizontal"));
                        if (!this.getRegion()) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:colour", "green;red;green"));
                            colour = "green";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:colour", "red;green;red"));
                        colour = "red";
                        break;
                    }
                    case 6: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour_pattern", "horizontal"));
                        if (!this.getRegion()) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour", "green;red;green"));
                            colour = "green";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour", "red;green;red"));
                        colour = "red";
                    }
                }
                shape = "cone, point up";
                break;
            }
        }
        switch (this.getStyleIndex()) {
            case 1: 
            case 2: 
            case 3: {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:system", this.getRegion() ? "iala-b" : "iala-a"));
                break;
            }
            case 4: 
            case 5: {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:system", this.getRegion() ? "iala-b" : "iala-a"));
                break;
            }
            case 6: {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:system", this.getRegion() ? "iala-b" : "iala-a"));
            }
        }
        this.saveTopMarkData(shape, colour);
        this.saveLightData();
        this.saveRadarFogData();
        Main.pref.put("tomsplugin.IALA", this.getRegion() ? "iala-b" : "iala-a");
    }
}

