/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.cos;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.ICOSVisitor;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.io.RandomAccessFile;
import org.apache.pdfbox.pdfparser.PDFObjectStreamParser;
import org.apache.pdfbox.pdfparser.PDFXrefStreamParser;
import org.apache.pdfbox.persistence.util.COSObjectKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class COSDocument
extends COSBase {
    private static final Log log = LogFactory.getLog(COSDocument.class);
    private float version;
    private final Map<COSObjectKey, COSObject> objectPool = new HashMap<COSObjectKey, COSObject>();
    private final Map<COSObjectKey, Integer> xrefTable = new HashMap<COSObjectKey, Integer>();
    private COSDictionary trailer;
    private final RandomAccess scratchFile;
    private final File tmpFile;
    private String headerString = "%PDF-1.4";
    private boolean warnMissingClose = true;
    private boolean closed = false;
    private final boolean forceParsing;

    public COSDocument(RandomAccess scratchFile, boolean forceParsing) {
        this.scratchFile = scratchFile;
        this.tmpFile = null;
        this.forceParsing = forceParsing;
    }

    public COSDocument(File scratchDir, boolean forceParsing) throws IOException {
        this.tmpFile = File.createTempFile("pdfbox-", ".tmp", scratchDir);
        this.scratchFile = new RandomAccessFile(this.tmpFile, "rw");
        this.forceParsing = forceParsing;
    }

    public COSDocument() throws IOException {
        this((File)null);
    }

    public COSDocument(File scratchDir) throws IOException {
        this(scratchDir, false);
    }

    public COSDocument(RandomAccess file) {
        this(file, false);
    }

    public RandomAccess getScratchFile() {
        return this.scratchFile;
    }

    public COSObject getObjectByType(String type) throws IOException {
        return this.getObjectByType(COSName.getPDFName(type));
    }

    public COSObject getObjectByType(COSName type) throws IOException {
        for (COSObject object : this.objectPool.values()) {
            COSBase realObject = object.getObject();
            if (!(realObject instanceof COSDictionary)) continue;
            try {
                COSDictionary dic = (COSDictionary)realObject;
                COSName objectType = (COSName)dic.getItem(COSName.TYPE);
                if (objectType == null || !objectType.equals(type)) continue;
                return object;
            }
            catch (ClassCastException e) {
                log.warn(e, e);
            }
        }
        return null;
    }

    public List<COSObject> getObjectsByType(String type) throws IOException {
        return this.getObjectsByType(COSName.getPDFName(type));
    }

    public List<COSObject> getObjectsByType(COSName type) throws IOException {
        ArrayList<COSObject> retval = new ArrayList<COSObject>();
        for (COSObject object : this.objectPool.values()) {
            COSBase realObject = object.getObject();
            if (!(realObject instanceof COSDictionary)) continue;
            try {
                COSDictionary dic = (COSDictionary)realObject;
                COSName objectType = (COSName)dic.getItem(COSName.TYPE);
                if (objectType == null || !objectType.equals(type)) continue;
                retval.add(object);
            }
            catch (ClassCastException e) {
                log.warn(e, e);
            }
        }
        return retval;
    }

    public void print() {
        for (COSObject object : this.objectPool.values()) {
            System.out.println(object);
        }
    }

    public void setVersion(float versionValue) {
        this.version = versionValue;
    }

    public float getVersion() {
        return this.version;
    }

    public boolean isEncrypted() {
        boolean encrypted = false;
        if (this.trailer != null) {
            encrypted = this.trailer.getDictionaryObject(COSName.ENCRYPT) != null;
        }
        return encrypted;
    }

    public COSDictionary getEncryptionDictionary() {
        return (COSDictionary)this.trailer.getDictionaryObject(COSName.ENCRYPT);
    }

    public void setEncryptionDictionary(COSDictionary encDictionary) {
        this.trailer.setItem(COSName.ENCRYPT, (COSBase)encDictionary);
    }

    public COSArray getDocumentID() {
        return (COSArray)this.getTrailer().getItem(COSName.ID);
    }

    public void setDocumentID(COSArray id) {
        this.getTrailer().setItem(COSName.ID, (COSBase)id);
    }

    public COSObject getCatalog() throws IOException {
        COSObject catalog = this.getObjectByType(COSName.CATALOG);
        if (catalog == null) {
            throw new IOException("Catalog cannot be found");
        }
        return catalog;
    }

    public List<COSObject> getObjects() {
        return new ArrayList<COSObject>(this.objectPool.values());
    }

    public COSDictionary getTrailer() {
        return this.trailer;
    }

    public void setTrailer(COSDictionary newTrailer) {
        this.trailer = newTrailer;
    }

    @Override
    public Object accept(ICOSVisitor visitor) throws COSVisitorException {
        return visitor.visitFromDocument(this);
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.scratchFile.close();
            if (this.tmpFile != null) {
                this.tmpFile.delete();
            }
            this.closed = true;
        }
    }

    protected void finalize() throws IOException {
        if (!this.closed) {
            if (this.warnMissingClose) {
                log.warn("Warning: You did not close a PDF Document");
            }
            this.close();
        }
    }

    public void setWarnMissingClose(boolean warn) {
        this.warnMissingClose = warn;
    }

    public String getHeaderString() {
        return this.headerString;
    }

    public void setHeaderString(String header) {
        this.headerString = header;
    }

    public void dereferenceObjectStreams() throws IOException {
        for (COSObject objStream : this.getObjectsByType("ObjStm")) {
            COSStream stream = (COSStream)objStream.getObject();
            PDFObjectStreamParser parser = new PDFObjectStreamParser(stream, this, this.forceParsing);
            parser.parse();
            for (COSObject next : parser.getObjects()) {
                COSObjectKey key = new COSObjectKey(next);
                if (this.objectPool.get(key) != null && this.objectPool.get(key).getObject() != null) continue;
                COSObject obj = this.getObjectFromPool(key);
                obj.setObject(next.getObject());
            }
        }
    }

    public COSObject getObjectFromPool(COSObjectKey key) throws IOException {
        COSObject obj = null;
        if (key != null) {
            obj = this.objectPool.get(key);
        }
        if (obj == null) {
            obj = new COSObject(null);
            if (key != null) {
                obj.setObjectNumber(COSInteger.get(key.getNumber()));
                obj.setGenerationNumber(COSInteger.get(key.getGeneration()));
                this.objectPool.put(key, obj);
            }
        }
        return obj;
    }

    public void setXRef(COSObjectKey objKey, int offset) {
        this.xrefTable.put(objKey, offset);
    }

    public Map<COSObjectKey, Integer> getXrefTable() {
        return this.xrefTable;
    }

    public void parseXrefStreams() throws IOException {
        COSDictionary trailerDict = new COSDictionary();
        for (COSObject xrefStream : this.getObjectsByType("XRef")) {
            COSStream stream = (COSStream)xrefStream.getObject();
            trailerDict.addAll(stream);
            PDFXrefStreamParser parser = new PDFXrefStreamParser(stream, this, this.forceParsing);
            parser.parse();
        }
        this.setTrailer(trailerDict);
    }
}

