/*
 * Decompiled with CFR 0.152.
 */
package pdfimport;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import pdfimport.PdfPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelSegmentsFinder {
    public double angle;
    public double angleSum;
    public int refCount;
    public List<PdfPath> paths = new ArrayList<PdfPath>();

    public void addPath(PdfPath path, double angle2) {
        this.angleSum += angle2;
        this.paths.add(path);
        this.angle = this.angleSum / (double)this.paths.size();
    }

    public List<ParallelSegmentsFinder> splitByDistance(double maxDistance) {
        ParallelSegmentsFinder finder;
        AffineTransform tr = new AffineTransform();
        tr.rotate(-this.angle);
        final HashMap<PdfPath, Point2D.Double> positions = new HashMap<PdfPath, Point2D.Double>();
        Point2D.Double src = new Point2D.Double();
        for (PdfPath path : this.paths) {
            ((Point2D)src).setLocation((path.firstPoint().getX() + path.lastPoint().getX()) / 2.0, (path.firstPoint().getY() + path.lastPoint().getY()) / 2.0);
            Point2D.Double dest = new Point2D.Double();
            Point2D.Double destA = new Point2D.Double();
            Point2D.Double destB = new Point2D.Double();
            tr.transform(src, dest);
            tr.transform(path.firstPoint(), destA);
            tr.transform(path.lastPoint(), destB);
            positions.put(path, dest);
        }
        Collections.sort(this.paths, new Comparator<PdfPath>(){

            @Override
            public int compare(PdfPath o1, PdfPath o2) {
                double y2;
                double y1 = ((Point2D)positions.get(o1)).getY();
                return y1 > (y2 = ((Point2D)positions.get(o2)).getY()) ? 1 : (y1 < y2 ? -1 : 0);
            }
        });
        ArrayList<ParallelSegmentsFinder> result = new ArrayList<ParallelSegmentsFinder>();
        HashMap<PdfPath, ParallelSegmentsFinder> sweepLine = new HashMap<PdfPath, ParallelSegmentsFinder>();
        HashSet adjacentClustersSet = new HashSet();
        ArrayList adjacentClusters = new ArrayList();
        ArrayList<PdfPath> pathsToRemove = new ArrayList<PdfPath>();
        for (PdfPath path : this.paths) {
            adjacentClusters.clear();
            adjacentClustersSet.clear();
            pathsToRemove.clear();
            for (PdfPath p : sweepLine.keySet()) {
                Point2D pathPos = (Point2D)positions.get(path);
                Point2D pPos = (Point2D)positions.get(p);
                if (pathPos.getY() - pPos.getY() > maxDistance) {
                    pathsToRemove.add(p);
                    continue;
                }
                double distance = this.distanceLineLine(path, p);
                if (!(distance <= maxDistance) || !adjacentClustersSet.add(sweepLine.get(p))) continue;
                adjacentClusters.add(sweepLine.get(p));
            }
            for (PdfPath p : pathsToRemove) {
                ParallelSegmentsFinder finder2 = (ParallelSegmentsFinder)sweepLine.remove(p);
                --finder2.refCount;
                if (finder2.refCount != 0) continue;
                result.add(finder2);
            }
            if (adjacentClusters.size() > 0) {
                finder = (ParallelSegmentsFinder)adjacentClusters.remove(0);
                finder.paths.add(path);
                sweepLine.put(path, finder);
                ++finder.refCount;
                for (ParallelSegmentsFinder finder1 : adjacentClusters) {
                    for (PdfPath path1 : finder1.paths) {
                        finder.paths.add(path1);
                        sweepLine.put(path1, finder);
                        ++finder.refCount;
                    }
                }
                continue;
            }
            finder = new ParallelSegmentsFinder();
            finder.addPath(path, this.angle);
            sweepLine.put(path, finder);
            finder.refCount = 1;
        }
        for (PdfPath p : sweepLine.keySet()) {
            finder = (ParallelSegmentsFinder)sweepLine.get(p);
            --finder.refCount;
            if (finder.refCount != 0) continue;
            result.add(finder);
        }
        return result;
    }

    private double distanceLineLine(PdfPath p1, PdfPath p2) {
        return this.distanceLineLine(p1.firstPoint(), p1.lastPoint(), p2.firstPoint(), p2.lastPoint());
    }

    private double distanceLineLine(Point2D p1, Point2D p2, Point2D p3, Point2D p4) {
        double dist1 = ParallelSegmentsFinder.closestPointToSegment(p1, p2, p3).distance(p3);
        double dist2 = ParallelSegmentsFinder.closestPointToSegment(p1, p2, p4).distance(p4);
        double dist3 = ParallelSegmentsFinder.closestPointToSegment(p3, p4, p1).distance(p1);
        double dist4 = ParallelSegmentsFinder.closestPointToSegment(p3, p4, p2).distance(p2);
        return Math.min(Math.min(dist1, dist2), Math.min(dist3, dist4));
    }

    public static Point2D closestPointToSegment(Point2D segmentP1, Point2D segmentP2, Point2D point) {
        double pdy;
        double ldx = segmentP2.getX() - segmentP1.getX();
        double ldy = segmentP2.getY() - segmentP1.getY();
        if (ldx == 0.0 && ldy == 0.0) {
            return segmentP1;
        }
        double pdx = point.getX() - segmentP1.getX();
        double offset = (pdx * ldx + (pdy = point.getY() - segmentP1.getY()) * ldy) / (ldx * ldx + ldy * ldy);
        if (offset <= 0.0) {
            return segmentP1;
        }
        if (offset >= 1.0) {
            return segmentP2;
        }
        return new Point2D.Double(segmentP1.getX() + ldx * offset, segmentP1.getY() + ldy * offset);
    }
}

