/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.photo_geotagging;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.Sanselan;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.formats.jpeg.JpegImageMetadata;
import org.apache.sanselan.formats.jpeg.exifRewrite.ExifRewriter;
import org.apache.sanselan.formats.tiff.TiffImageMetadata;
import org.apache.sanselan.formats.tiff.constants.GPSTagConstants;
import org.apache.sanselan.formats.tiff.write.TiffOutputDirectory;
import org.apache.sanselan.formats.tiff.write.TiffOutputField;
import org.apache.sanselan.formats.tiff.write.TiffOutputSet;
import org.openstreetmap.josm.plugins.photo_geotagging.SanselanFixes;
import org.openstreetmap.josm.tools.I18n;

public class ExifGPSTagger {
    public static void setExifGPSTag(File jpegImageFile, File dst, double lat, double lon, long gpsTime) throws IOException {
        try {
            ExifGPSTagger.setExifGPSTagWorker(jpegImageFile, dst, lat, lon, gpsTime);
        }
        catch (ImageReadException ire) {
            throw new IOException(I18n.tr((String)"Read error!", (Object[])new Object[0]));
        }
        catch (ImageWriteException ire2) {
            throw new IOException(I18n.tr((String)"Write error!", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setExifGPSTagWorker(File jpegImageFile, File dst, double lat, double lon, long gpsTime) throws IOException, ImageReadException, ImageWriteException {
        OutputStream os = null;
        try {
            TiffImageMetadata exif;
            TiffOutputSet outputSet = null;
            IImageMetadata metadata = Sanselan.getMetadata(jpegImageFile);
            JpegImageMetadata jpegMetadata = (JpegImageMetadata)metadata;
            if (null != jpegMetadata && null != (exif = jpegMetadata.getExif())) {
                outputSet = exif.getOutputSet();
            }
            if (null == outputSet) {
                outputSet = new TiffOutputSet();
            }
            GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            calendar.setTimeInMillis(gpsTime);
            int year = calendar.get(1);
            int month = calendar.get(2) + 1;
            int day = calendar.get(5);
            int hour = calendar.get(11);
            int minute = calendar.get(12);
            int second = calendar.get(13);
            DecimalFormat yearFormatter = new DecimalFormat("0000");
            DecimalFormat monthFormatter = new DecimalFormat("00");
            DecimalFormat dayFormatter = new DecimalFormat("00");
            String yearStr = yearFormatter.format(year);
            String monthStr = monthFormatter.format(month);
            String dayStr = dayFormatter.format(day);
            String dateStamp = yearStr + ":" + monthStr + ":" + dayStr;
            Number[] timeStamp = new Double[]{new Double(hour), new Double(minute), new Double(second)};
            TiffOutputField gpsTimeStamp = TiffOutputField.create(GPSTagConstants.GPS_TAG_GPS_TIME_STAMP, outputSet.byteOrder, timeStamp);
            TiffOutputDirectory exifDirectory = outputSet.getOrCreateGPSDirectory();
            exifDirectory.removeField(GPSTagConstants.GPS_TAG_GPS_TIME_STAMP);
            exifDirectory.add(gpsTimeStamp);
            TiffOutputField gpsDateStamp = SanselanFixes.create(GPSTagConstants.GPS_TAG_GPS_DATE_STAMP, outputSet.byteOrder, dateStamp);
            exifDirectory.removeField(GPSTagConstants.GPS_TAG_GPS_DATE_STAMP);
            exifDirectory.add(gpsDateStamp);
            SanselanFixes.setGPSInDegrees(outputSet, lon, lat);
            os = new FileOutputStream(dst);
            os = new BufferedOutputStream(os);
            new ExifRewriter().updateExifMetadataLossless(jpegImageFile, os, outputSet);
            os.close();
            os = null;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

