/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import livegps.AppendableGpxTrackSegment;
import livegps.LiveGpsData;
import livegps.SingleSegmentGpxTrack;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.tools.I18n;

public class LiveGpsLayer
extends GpxLayer
implements PropertyChangeListener {
    public static final String LAYER_NAME = I18n.tr((String)"LiveGPS layer", (Object[])new Object[0]);
    public static final String C_LIVEGPS_COLOR_POSITION = "color.livegps.position";
    public static final String C_LIVEGPS_COLOR_POSITION_ESTIMATE = "color.livegps.position_estimate";
    private static final int DEFAULT_REFRESH_INTERVAL = 250;
    private static final int DEFAULT_CENTER_INTERVAL = 5000;
    private static final int DEFAULT_CENTER_FACTOR = 80;
    private static final String oldC_REFRESH_INTERVAL = "livegps.refreshinterval";
    private static final String C_REFRESH_INTERVAL = "livegps.refresh_interval_msec";
    private static final String C_CENTER_INTERVAL = "livegps.center_interval_msec";
    private static final String C_CENTER_FACTOR = "livegps.center_factor";
    private static final String C_CURSOR_H = "livegps.cursor_height";
    private static final String C_CURSOR_W = "livegps.cursor_width";
    private int refreshInterval;
    private int centerInterval;
    private double centerFactor;
    private long lastRedraw = 0L;
    private long lastCenter = 0L;
    LiveGpsData lastData;
    LatLon lastPos;
    WayPoint lastPoint;
    private final AppendableGpxTrackSegment trackSegment;
    boolean autocenter;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");

    public LiveGpsLayer(GpxData data) {
        super(data, LAYER_NAME);
        this.trackSegment = new AppendableGpxTrackSegment();
        HashMap<String, Object> attr = new HashMap<String, Object>();
        attr.put("desc", "josm live gps");
        SingleSegmentGpxTrack trackBeingWritten = new SingleSegmentGpxTrack(this.trackSegment, attr);
        data.tracks.add(trackBeingWritten);
        this.initIntervals();
    }

    void setCurrentPosition(double lat, double lon) {
        LatLon thisPos = new LatLon(lat, lon);
        if (this.lastPos != null && thisPos.equalsEpsilon(this.lastPos)) {
            return;
        }
        this.lastPos = thisPos;
        this.lastPoint = new WayPoint(thisPos);
        this.lastPoint.attr.put("time", this.dateFormat.format(new Date()));
        this.trackSegment.addWaypoint(this.lastPoint);
        if (this.autocenter) {
            this.conditionalCenter(thisPos);
        }
    }

    public void center() {
        if (this.lastPoint != null) {
            Main.map.mapView.zoomTo(this.lastPoint.getCoor());
        }
    }

    public void conditionalCenter(LatLon Pos) {
        Point2D P = Main.map.mapView.getPoint2D(Pos);
        Rectangle rv = Main.map.mapView.getBounds(null);
        Date date = new Date();
        long current = date.getTime();
        rv.grow(-((int)(rv.getHeight() * this.centerFactor)), -((int)(rv.getWidth() * this.centerFactor)));
        if (!rv.contains(P) || this.centerInterval > 0 && current - this.lastCenter >= (long)this.centerInterval) {
            Main.map.mapView.zoomTo(Pos);
            this.lastCenter = current;
        }
    }

    public void setAutoCenter(boolean ac) {
        this.autocenter = ac;
    }

    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        super.paint(g, mv, bounds);
        if (this.lastPoint == null) {
            return;
        }
        Point screen = mv.getPoint(this.lastPoint.getCoor());
        g.setColor(Main.pref.getColor(C_LIVEGPS_COLOR_POSITION, Color.RED));
        int TriaHeight = Main.pref.getInteger(C_CURSOR_H, 20);
        int TriaWidth = Main.pref.getInteger(C_CURSOR_W, 10);
        int[] x = new int[4];
        int[] y = new int[4];
        float course = this.lastData.getCourse();
        x[0] = screen.x + Math.round((float)TriaHeight * (float)Math.sin(Math.toRadians(course)));
        y[0] = screen.y - Math.round((float)TriaHeight * (float)Math.cos(Math.toRadians(course)));
        x[1] = screen.x + Math.round((float)TriaWidth * (float)Math.sin(Math.toRadians(course + 120.0f)));
        y[1] = screen.y - Math.round((float)TriaWidth * (float)Math.cos(Math.toRadians(course + 120.0f)));
        x[2] = screen.x;
        y[2] = screen.y;
        x[3] = screen.x + Math.round((float)TriaWidth * (float)Math.sin(Math.toRadians(course + 240.0f)));
        y[3] = screen.y - Math.round((float)TriaWidth * (float)Math.cos(Math.toRadians(course + 240.0f)));
        g.drawPolygon(x, y, 4);
        g.setColor(Main.pref.getColor(C_LIVEGPS_COLOR_POSITION_ESTIMATE, Color.CYAN));
        double ppm = 100.0 / mv.getDist100Pixel();
        int w = (int)Math.round((double)this.lastData.getEpx() * ppm);
        int h = (int)Math.round((double)this.lastData.getEpy() * ppm);
        if (w > TriaWidth || h > TriaWidth) {
            int yo = screen.y - Math.round(h / 2);
            int xo = screen.x - Math.round(w / 2);
            g.drawOval(xo, yo, w, h);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.isVisible()) {
            return;
        }
        if ("gpsdata".equals(evt.getPropertyName())) {
            this.lastData = (LiveGpsData)evt.getNewValue();
            if (this.lastData.isFix()) {
                this.setCurrentPosition(this.lastData.getLatitude(), this.lastData.getLongitude());
                if (this.allowRedraw()) {
                    Main.map.repaint();
                }
            }
        }
    }

    private boolean allowRedraw() {
        Date date = new Date();
        long current = date.getTime();
        if (current - this.lastRedraw >= (long)this.refreshInterval) {
            this.lastRedraw = current;
            return true;
        }
        return false;
    }

    private void initIntervals() {
        this.refreshInterval = Main.pref.getInteger(oldC_REFRESH_INTERVAL, 0);
        if (this.refreshInterval != 0) {
            this.refreshInterval *= 1000;
            Main.pref.put(oldC_REFRESH_INTERVAL, null);
        } else {
            this.refreshInterval = Main.pref.getInteger(C_REFRESH_INTERVAL, 250);
        }
        this.centerInterval = Main.pref.getInteger(C_CENTER_INTERVAL, 5000);
        this.centerFactor = Main.pref.getInteger(C_CENTER_FACTOR, 80);
        if (this.centerFactor <= 1.0 || this.centerFactor >= 99.0) {
            this.centerFactor = 80.0;
        }
        Main.pref.putInteger(C_REFRESH_INTERVAL, Integer.valueOf(this.refreshInterval));
        Main.pref.putInteger(C_CENTER_INTERVAL, Integer.valueOf(this.centerInterval));
        Main.pref.putInteger(C_CENTER_FACTOR, Integer.valueOf((int)this.centerFactor));
        this.centerFactor = (100.0 - this.centerFactor) / 2.0 / 100.0;
    }
}

