/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.iwa;

import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.iwa.IWATargetWayHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IWAMode
extends MapMode
implements MapViewPaintable,
SelectionChangedListener,
AWTEventListener {
    private State state;
    private MapView mv;
    private static final long serialVersionUID = 42L;
    private Way targetWay;
    private Node candidateNode = null;
    private WaySegment candidateSegment = null;
    private Point mousePos = null;
    private boolean dragging = false;
    private final Cursor cursorSelect = ImageProvider.getCursor((String)"normal", (String)"mode");
    private final Cursor cursorSelectHover = ImageProvider.getCursor((String)"hand", (String)"mode");
    private final Cursor cursorImprove = ImageProvider.getCursor((String)"crosshair", null);
    private final Cursor cursorImproveAdd = ImageProvider.getCursor((String)"crosshair", (String)"add_node");
    private final Cursor cursorImproveAddLock = ImageProvider.getCursor((String)"crosshair", (String)"add_node_lock");
    private final Cursor cursorImproveLock = ImageProvider.getCursor((String)"crosshair", (String)"lock");
    private boolean shift = false;
    private boolean ctrl = false;
    private boolean oldShift = false;
    private boolean oldCtrl = false;
    private final Color guideColor = PaintColors.HIGHLIGHT.get();
    private final BasicStroke selectTargetWayStroke = new BasicStroke(2.0f, 1, 1);
    private final BasicStroke moveNodeStroke;
    private final BasicStroke addNodeStroke;
    private boolean selectionChangedBlocked = false;
    protected String oldModeHelpText;

    public IWAMode(MapFrame mapFrame) {
        super(I18n.tr((String)"ImproveWayAccuracy", (Object[])new Object[0]), "button.png", I18n.tr((String)"Improve Way Accuracy mode", (Object[])new Object[0]), Shortcut.registerShortcut((String)"mapmode:ImproveWayAccuracy", (String)I18n.tr((String)"Mode: {0}", (Object[])new Object[]{I18n.tr((String)"Improve Way Accuracy", (Object[])new Object[0])}), (int)75, (int)3), mapFrame, Cursor.getPredefinedCursor(0));
        float[] dash1 = new float[]{4.0f};
        this.moveNodeStroke = new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f);
        this.addNodeStroke = new BasicStroke(1.0f, 0, 0);
    }

    public void enterMode() {
        if (!this.isEnabled()) {
            return;
        }
        super.enterMode();
        this.mv = Main.map.mapView;
        this.mousePos = null;
        this.oldModeHelpText = "";
        if (IWAMode.getCurrentDataSet() == null) {
            return;
        }
        this.updateStateByCurrentSelection();
        Main.map.mapView.addMouseListener((MouseListener)((Object)this));
        Main.map.mapView.addMouseMotionListener((MouseMotionListener)((Object)this));
        Main.map.mapView.addTemporaryLayer((MapViewPaintable)this);
        DataSet.addSelectionListener((SelectionChangedListener)this);
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)((Object)this));
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)((Object)this));
        Main.map.mapView.removeTemporaryLayer((MapViewPaintable)this);
        DataSet.removeSelectionListener((SelectionChangedListener)this);
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        Main.map.mapView.repaint();
    }

    protected void updateStatusLine() {
        String newModeHelpText = this.getModeHelpText();
        if (!newModeHelpText.equals(this.oldModeHelpText)) {
            this.oldModeHelpText = newModeHelpText;
            Main.map.statusLine.setHelpText(newModeHelpText);
            Main.map.statusLine.repaint();
        }
    }

    public String getModeHelpText() {
        if (this.state == State.selecting) {
            if (this.targetWay != null) {
                return I18n.tr((String)"Click on the way to start improving its shape.", (Object[])new Object[0]);
            }
            return I18n.tr((String)"Select a way that you want to make more accurate.", (Object[])new Object[0]);
        }
        if (!this.ctrl) {
            return I18n.tr((String)"Click to move the highlighted node. Hold Ctrl to add new nodes.", (Object[])new Object[0]);
        }
        return I18n.tr((String)"Click to add a new node. Release Ctrl to move existing nodes.", (Object[])new Object[0]);
    }

    public boolean layerIsSupported(Layer l) {
        return l instanceof OsmDataLayer;
    }

    protected void updateEnabledState() {
        this.setEnabled(IWAMode.getEditLayer() != null);
    }

    public void paint(Graphics2D g, MapView mv, Bounds bbox) {
        if (this.mousePos == null) {
            return;
        }
        g.setColor(this.guideColor);
        if (this.state == State.selecting && this.targetWay != null) {
            g.setStroke(this.selectTargetWayStroke);
            List nodes = this.targetWay.getNodes();
            GeneralPath b = new GeneralPath();
            Point p0 = mv.getPoint((Node)nodes.get(0));
            b.moveTo(p0.x, p0.y);
            for (Node n : nodes) {
                Point pn = mv.getPoint(n);
                b.lineTo(pn.x, pn.y);
            }
            if (this.targetWay.isClosed()) {
                b.lineTo(p0.x, p0.y);
            }
            g.draw(b);
        } else if (this.state == State.improving) {
            Point p1 = null;
            Point p2 = null;
            if (this.candidateSegment != null) {
                g.setStroke(this.addNodeStroke);
                p1 = mv.getPoint(this.candidateSegment.getFirstNode());
                p2 = mv.getPoint(this.candidateSegment.getSecondNode());
            } else if (this.candidateNode != null) {
                g.setStroke(this.moveNodeStroke);
                List wpps = this.targetWay.getNodePairs(false);
                for (Pair wpp : wpps) {
                    if (wpp.a == this.candidateNode) {
                        p1 = mv.getPoint((Node)wpp.b);
                    }
                    if (wpp.b == this.candidateNode) {
                        p2 = mv.getPoint((Node)wpp.a);
                    }
                    if (p1 == null || p2 == null) continue;
                    break;
                }
            }
            GeneralPath b = new GeneralPath();
            if (p1 != null) {
                b.moveTo(this.mousePos.x, this.mousePos.y);
                b.lineTo(p1.x, p1.y);
            }
            if (p2 != null) {
                b.moveTo(this.mousePos.x, this.mousePos.y);
                b.lineTo(p2.x, p2.y);
            }
            g.draw(b);
            if (this.candidateNode != null) {
                p1 = mv.getPoint(this.candidateNode);
                g.fillRect(p1.x - 2, p1.y - 2, 6, 6);
            }
        }
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (Main.map == null || Main.map.mapView == null || !Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.updateKeyModifiers((InputEvent)event);
        this.updateCursorDependentObjectsIfNeeded();
        this.updateCursor();
        this.updateStatusLine();
        Main.map.mapView.repaint();
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        if (this.selectionChangedBlocked) {
            return;
        }
        this.updateStateByCurrentSelection();
    }

    public void mouseDragged(MouseEvent e) {
        this.dragging = true;
        this.mouseMoved(e);
    }

    public void mouseMoved(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.mousePos = e.getPoint();
        this.updateKeyModifiers(e);
        this.updateCursorDependentObjectsIfNeeded();
        this.updateCursor();
        this.updateStatusLine();
        Main.map.mapView.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        this.dragging = false;
        if (!this.isEnabled() || e.getButton() != 1) {
            return;
        }
        this.updateKeyModifiers(e);
        this.mousePos = e.getPoint();
        if (this.state == State.selecting) {
            if (this.targetWay != null) {
                IWAMode.getCurrentDataSet().setSelected(new PrimitiveId[]{this.targetWay.getPrimitiveId()});
                this.updateStateByCurrentSelection();
            }
        } else if (this.state == State.improving && this.mousePos != null) {
            if (this.mv.getLatLon(this.mousePos.x, this.mousePos.y).isOutSideWorld()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Cannot place a node outside of the world.", (Object[])new Object[0]), I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
                return;
            }
            if (this.ctrl && this.candidateSegment != null) {
                LinkedList<Object> virtualCmds = new LinkedList<Object>();
                Node virtualNode = new Node(this.mv.getEastNorth(this.mousePos.x, this.mousePos.y));
                virtualCmds.add(new AddCommand((OsmPrimitive)virtualNode));
                List firstNodeWays = OsmPrimitive.getFilteredList((Collection)this.candidateSegment.getFirstNode().getReferrers(), Way.class);
                List secondNodeWays = OsmPrimitive.getFilteredList((Collection)this.candidateSegment.getFirstNode().getReferrers(), Way.class);
                LinkedList<WaySegment> virtualSegments = new LinkedList<WaySegment>();
                for (Way w : firstNodeWays) {
                    List wpps = w.getNodePairs(true);
                    for (Way w2 : secondNodeWays) {
                        if (!w.equals((Object)w2)) continue;
                        int i = -1;
                        for (Pair wpp : wpps) {
                            ++i;
                            if ((!((Node)wpp.a).equals((Object)this.candidateSegment.getFirstNode()) || !((Node)wpp.b).equals((Object)this.candidateSegment.getSecondNode())) && (!((Node)wpp.b).equals((Object)this.candidateSegment.getFirstNode()) || !((Node)wpp.a).equals((Object)this.candidateSegment.getSecondNode()))) continue;
                            virtualSegments.add(new WaySegment(w, i));
                        }
                    }
                }
                for (WaySegment virtualSegment : virtualSegments) {
                    Way w = virtualSegment.way;
                    Way wnew = new Way(w);
                    wnew.addNode(virtualSegment.lowerIndex + 1, virtualNode);
                    virtualCmds.add(new ChangeCommand((OsmPrimitive)w, (OsmPrimitive)wnew));
                }
                String text = I18n.trn((String)"Add and a new node to way", (String)"Add and a new node to {0} ways", (long)virtualSegments.size(), (Object[])new Object[]{virtualSegments.size()});
                Main.main.undoRedo.add((Command)new SequenceCommand(text, virtualCmds));
            } else if (this.candidateNode != null) {
                EastNorth nodeEN = this.candidateNode.getEastNorth();
                EastNorth cursorEN = this.mv.getEastNorth(this.mousePos.x, this.mousePos.y);
                Main.main.undoRedo.add((Command)new MoveCommand((OsmPrimitive)this.candidateNode, cursorEN.east() - nodeEN.east(), cursorEN.north() - nodeEN.north()));
            }
        }
        this.mousePos = null;
        this.updateCursor();
        this.updateStatusLine();
        Main.map.mapView.repaint();
    }

    public void mouseExited(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.dragging) {
            this.mousePos = null;
        }
        Main.map.mapView.repaint();
    }

    protected void updateKeyModifiers(InputEvent e) {
        this.oldCtrl = this.ctrl;
        this.oldShift = this.shift;
        this.ctrl = (e.getModifiers() & 2) != 0;
        this.shift = (e.getModifiers() & 1) != 0;
    }

    private void updateCursor() {
        if (!this.isEnabled()) {
            this.mv.setNewCursor(null, (Object)this);
            return;
        }
        if (this.state == State.selecting) {
            this.mv.setNewCursor(this.targetWay == null ? this.cursorSelect : this.cursorSelectHover, (Object)this);
        } else if (this.state == State.improving) {
            this.mv.setNewCursor(this.ctrl ? (this.shift || this.dragging ? this.cursorImproveAddLock : this.cursorImproveAdd) : (this.shift || this.dragging ? this.cursorImproveLock : this.cursorImprove), (Object)this);
        }
    }

    public void updateCursorDependentObjectsIfNeeded() {
        if (this.state == State.improving && (this.shift || this.dragging) && this.ctrl == this.oldCtrl && (this.candidateNode != null || this.candidateSegment != null)) {
            return;
        }
        if (this.mousePos == null) {
            this.candidateNode = null;
            this.candidateSegment = null;
            return;
        }
        if (this.state == State.selecting) {
            this.targetWay = IWATargetWayHelper.findWay(this.mv, this.mousePos);
        } else if (this.state == State.improving) {
            if (this.ctrl) {
                this.candidateSegment = IWATargetWayHelper.findCandidateSegment(this.mv, this.targetWay, this.mousePos);
                this.candidateNode = null;
            } else {
                this.candidateNode = IWATargetWayHelper.findCandidateNode(this.mv, this.targetWay, this.mousePos);
                this.candidateSegment = null;
            }
        }
    }

    public void startSelecting() {
        this.state = State.selecting;
        this.targetWay = null;
        if (IWAMode.getCurrentDataSet() != null) {
            IWAMode.getCurrentDataSet().clearSelection();
        }
        this.mv.repaint();
        this.updateStatusLine();
    }

    public void startImproving(Way targetWay) {
        this.state = State.improving;
        List currentSelection = (List)IWAMode.getCurrentDataSet().getSelected();
        if (currentSelection.size() != 1 || !((OsmPrimitive)currentSelection.get(0)).equals((Object)targetWay)) {
            this.selectionChangedBlocked = true;
            IWAMode.getCurrentDataSet().clearSelection();
            IWAMode.getCurrentDataSet().setSelected(new PrimitiveId[]{targetWay.getPrimitiveId()});
            this.selectionChangedBlocked = false;
        }
        this.targetWay = targetWay;
        this.candidateNode = null;
        this.candidateSegment = null;
        this.mv.repaint();
        this.updateStatusLine();
    }

    private void updateStateByCurrentSelection() {
        List r;
        ArrayList<Node> nodeList = new ArrayList<Node>();
        ArrayList<Way> wayList = new ArrayList<Way>();
        Collection sel = IWAMode.getCurrentDataSet().getSelected();
        for (OsmPrimitive p : sel) {
            if (p instanceof Way) {
                wayList.add((Way)p);
            }
            if (!(p instanceof Node)) continue;
            nodeList.add((Node)p);
        }
        if (wayList.size() == 1) {
            this.startImproving((Way)wayList.get(0));
            return;
        }
        if (nodeList.size() > 0 && nodeList.size() == 1 && (r = ((Node)nodeList.get(0)).getReferrers()).size() == 1 && r.get(0) instanceof Way) {
            this.startImproving((Way)r.get(0));
            return;
        }
        this.startSelecting();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        selecting,
        improving;

    }
}

