/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.iwa;

import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.tools.Geometry;

public class IWAGeometry {
    public static double getSegmentAngle(EastNorth p1, EastNorth p2) {
        return Math.atan2(p2.north() - p1.north(), p2.east() - p1.east());
    }

    public static double getCornerAngle(EastNorth p1, EastNorth p2, EastNorth p3) {
        Double result = IWAGeometry.getSegmentAngle(p2, p1) - IWAGeometry.getSegmentAngle(p2, p3);
        if (result <= -Math.PI) {
            result = result + Math.PI * 2;
        }
        if (result > Math.PI) {
            result = result - Math.PI * 2;
        }
        return result;
    }

    public static EastNorth getSegmentAltituteIntersection(EastNorth sp1, EastNorth sp2, EastNorth ap) {
        Double segmentLenght = sp1.distance(sp2);
        Double altitudeAngle = IWAGeometry.getSegmentAngle(sp1, sp2) + 1.5707963267948966;
        EastNorth ap2 = new EastNorth(ap.east() + 1000.0 * Math.cos(altitudeAngle), ap.north() + 1000.0 * Math.sin(altitudeAngle));
        EastNorth resultCandidate = Geometry.getLineLineIntersection((EastNorth)sp1, (EastNorth)sp2, (EastNorth)ap, (EastNorth)ap2);
        if (resultCandidate != null && resultCandidate.distance(sp1) * 0.999 < segmentLenght && resultCandidate.distance(sp2) * 0.999 < segmentLenght) {
            return resultCandidate;
        }
        return null;
    }
}

