/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.measurement;

import javax.swing.Action;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.measurement.MeasurementDialog;
import org.openstreetmap.josm.plugins.measurement.MeasurementLayer;
import org.openstreetmap.josm.plugins.measurement.MeasurementMode;
import org.openstreetmap.josm.tools.I18n;

public class MeasurementPlugin
extends Plugin {
    private IconToggleButton btn;
    private MeasurementMode mode = new MeasurementMode(Main.map, "measurement", I18n.tr((String)"measurement mode", (Object[])new Object[0]));
    protected static MeasurementDialog measurementDialog;
    protected static MeasurementLayer currentLayer;

    public MeasurementPlugin(PluginInformation info) {
        super(info);
        this.btn = new IconToggleButton((Action)((Object)this.mode));
        this.btn.setVisible(true);
        measurementDialog = new MeasurementDialog();
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame != null) {
            newFrame.addToggleDialog((ToggleDialog)measurementDialog);
        }
        if (Main.map != null) {
            Main.map.addMapMode(this.btn);
        }
    }

    public static MeasurementLayer getCurrentLayer() {
        if (currentLayer == null) {
            currentLayer = new MeasurementLayer(I18n.tr((String)"Measurements", (Object[])new Object[0]));
            Main.main.addLayer((Layer)currentLayer);
            MapView.addLayerChangeListener((MapView.LayerChangeListener)new MapView.LayerChangeListener(){

                public void activeLayerChange(Layer oldLayer, Layer newLayer) {
                    if (newLayer instanceof MeasurementLayer) {
                        currentLayer = (MeasurementLayer)newLayer;
                    }
                }

                public void layerAdded(Layer newLayer) {
                }

                public void layerRemoved(Layer oldLayer) {
                    if (oldLayer != null && oldLayer == currentLayer) {
                        MapView.removeLayerChangeListener((MapView.LayerChangeListener)this);
                    }
                }
            });
        }
        return currentLayer;
    }
}

