/*
 * Decompiled with CFR 0.152.
 */
package irsrectify;

import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class IRSRectifyPlugin
extends Plugin {
    private static int newLayerNameCounter = 0;
    private static String ONE_LINE_TO_RULE = "Update IRS adjustment layer";
    private MapFrame frame;

    public IRSRectifyPlugin(PluginInformation info) {
        super(info);
        Main.main.menu.toolsMenu.add((Action)((Object)new IRSRectifyAction()));
    }

    public void mapFrameInitialized(MapFrame mf, MapFrame newFrame) {
        this.frame = newFrame;
    }

    public class IRSRectifyAction
    extends JosmAction {
        public IRSRectifyAction() {
            super(I18n.tr((String)ONE_LINE_TO_RULE, (Object[])new Object[0]), "irsrectify.png", I18n.tr((String)ONE_LINE_TO_RULE, (Object[])new Object[0]), Shortcut.registerShortcut((String)"menu:irsrectify", (String)I18n.tr((String)ONE_LINE_TO_RULE, (Object[])new Object[0]), (int)73, (int)4), false);
        }

        public void actionPerformed(ActionEvent e) {
            ImageryLayer l = this.findImageryLayer();
            if (l == null) {
                return;
            }
            double dx = l.getDx();
            double dy = l.getDy();
            if (dx == 0.0 && dy == 0.0) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"This option creates IRS adjustment layer and a little way inside it. You need to adjust WMS layer placement first.\nResulting layer is to be saved as .osm and sent to Komzpa (me@komzpa.net) with [irs rectify] in subject.", (Object[])new Object[0]));
                return;
            }
            Node center = new Node(((IRSRectifyPlugin)IRSRectifyPlugin.this).frame.mapView.getCenter());
            Node offset = new Node(center.getEastNorth().add(dx, dy));
            Way way = new Way();
            way.addNode(center);
            way.addNode(offset);
            way.put("timestamp", new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
            String userName = JosmUserIdentityManager.getInstance().getUserName();
            if (userName != null) {
                way.put("user", userName);
            }
            OsmDataLayer data = this.findOrCreateDataLayer();
            data.data.addPrimitive((OsmPrimitive)center);
            data.data.addPrimitive((OsmPrimitive)offset);
            data.data.addPrimitive((OsmPrimitive)way);
            data.data.setSelected(new PrimitiveId[]{way.getPrimitiveId()});
            ((IRSRectifyPlugin)IRSRectifyPlugin.this).frame.mapView.setActiveLayer((Layer)data);
        }

        private ImageryLayer findImageryLayer() {
            if (IRSRectifyPlugin.this.frame == null || ((IRSRectifyPlugin)IRSRectifyPlugin.this).frame.mapView == null) {
                return null;
            }
            for (Layer l : ((IRSRectifyPlugin)IRSRectifyPlugin.this).frame.mapView.getAllLayers()) {
                if (!(l instanceof ImageryLayer)) continue;
                return (ImageryLayer)l;
            }
            return null;
        }

        private OsmDataLayer findOrCreateDataLayer() {
            if (IRSRectifyPlugin.this.frame == null || ((IRSRectifyPlugin)IRSRectifyPlugin.this).frame.mapView == null) {
                return null;
            }
            OsmDataLayer l = ((IRSRectifyPlugin)IRSRectifyPlugin.this).frame.mapView.getEditLayer();
            if (this.isOffsetLayer(l)) {
                return l;
            }
            for (Layer layer : ((IRSRectifyPlugin)IRSRectifyPlugin.this).frame.mapView.getAllLayers()) {
                if (!(layer instanceof OsmDataLayer) || !this.isOffsetLayer((OsmDataLayer)layer)) continue;
                return (OsmDataLayer)layer;
            }
            String name = I18n.tr((String)"IRS Adjustment Layer", (Object[])new Object[0]);
            if (++newLayerNameCounter > 1) {
                name = name + " " + newLayerNameCounter;
            }
            l = new OsmDataLayer(new DataSet(), name, null);
            Main.main.addLayer((Layer)l);
            return l;
        }

        private boolean isOffsetLayer(OsmDataLayer l) {
            if (l == null || l.data == null) {
                return false;
            }
            for (Way way : l.data.getWays()) {
                if (way.isDeleted() || way.getNodesCount() == 2 && way.hasKey("timestamp") && way.hasKey("user")) continue;
                return false;
            }
            return true;
        }

        protected void updateEnabledState() {
            this.setEnabled(this.findImageryLayer() != null);
        }
    }
}

