/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.TransformableElement;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

public abstract class RenderableElement
extends TransformableElement {
    AffineTransform cachedXform = null;
    Shape cachedClip = null;
    public static final int VECTOR_EFFECT_NONE = 0;
    public static final int VECTOR_EFFECT_NON_SCALING_STROKE = 1;
    int vectorEffect;

    public RenderableElement() {
    }

    public RenderableElement(String id, SVGElement parent) {
        super(id, parent);
    }

    protected void build() throws SVGException {
        super.build();
        StyleAttribute sty = new StyleAttribute();
        this.vectorEffect = this.getPres(sty.setName("vector-effect")) ? ("non-scaling-stroke".equals(sty.getStringValue()) ? 1 : 0) : 0;
    }

    public abstract void render(Graphics2D var1) throws SVGException;

    abstract void pick(Point2D var1, boolean var2, List var3) throws SVGException;

    abstract void pick(Rectangle2D var1, AffineTransform var2, boolean var3, List var4) throws SVGException;

    public abstract Rectangle2D getBoundingBox() throws SVGException;

    protected void beginLayer(Graphics2D g) throws SVGException {
        if (this.xform != null) {
            this.cachedXform = g.getTransform();
            g.transform(this.xform);
        }
        StyleAttribute styleAttrib = new StyleAttribute();
        Object clipPath = null;
    }

    protected void finishLayer(Graphics2D g) {
        if (this.cachedClip != null) {
            g.setClip(this.cachedClip);
        }
        if (this.cachedXform != null) {
            g.setTransform(this.cachedXform);
        }
    }
}

