/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.npm;

import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.npm.InitializationWizard;
import org.openstreetmap.josm.plugins.npm.NPMCredentialsAgentFactory;
import org.openstreetmap.josm.plugins.npm.NPMType;

public class NPMPlugin
extends Plugin {
    public static final String NPMPLUGIN_KEY = "plugins.native-password-manager.";

    public NPMPlugin(PluginInformation info) {
        super(info);
        this.initialize();
    }

    private void initialize() {
        String pref = Main.pref.get("plugins.native-password-manager.agent", null);
        if ("off".equals(pref)) {
            return;
        }
        NPMType sel = NPMType.fromPrefString(pref);
        if (sel != null) {
            CredentialsManager.registerCredentialsAgentFactory((CredentialsManager.CredentialsAgentFactory)new NPMCredentialsAgentFactory(sel));
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    InitializationWizard wizard = new InitializationWizard();
                    wizard.showDialog();
                }
            });
        }
    }

    public static void selectAndSave(NPMType type) {
        CredentialsManager.registerCredentialsAgentFactory((CredentialsManager.CredentialsAgentFactory)new NPMCredentialsAgentFactory(type));
        Main.pref.put("plugins.native-password-manager.agent", type.toPrefString());
    }

    public static void turnOffPermanently() {
        Main.pref.put("plugins.native-password-manager.agent", "off");
    }
}

