/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.keyring.kde;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.spi.keyring.KeyringProvider;

public class KWalletProvider
implements KeyringProvider {
    private static final Logger logger = Logger.getLogger(KWalletProvider.class.getName());
    private char[] handler = "0".toCharArray();
    private boolean timeoutHappened = false;
    private char[] defaultLocalWallet = "kdewallet".toCharArray();

    public boolean enabled() {
        if (Boolean.getBoolean("netbeans.keyring.no.native")) {
            logger.fine("native keyring integration disabled");
            return false;
        }
        CommandResult result = this.runCommand("isEnabled", new char[0][]);
        if (new String(result.retVal).equals("true")) {
            return this.updateHandler();
        }
        return false;
    }

    public char[] read(String key) {
        if (this.updateHandler()) {
            CommandResult result = this.runCommand("readPassword", this.handler, this.getApplicationName(), key.toCharArray(), this.getApplicationName(true));
            if (result.exitCode != 0) {
                this.warning("read action returned not 0 exitCode");
            }
            return result.retVal.length > 0 ? result.retVal : null;
        }
        return null;
    }

    public void save(String key, char[] password, String description) {
        if (this.updateHandler()) {
            CommandResult result = this.runCommand("writePassword", this.handler, this.getApplicationName(), key.toCharArray(), password, this.getApplicationName(true));
            if (result.exitCode != 0 || new String(result.retVal).equals("-1")) {
                this.warning("save action failed");
            }
            return;
        }
    }

    public void delete(String key) {
        if (this.updateHandler()) {
            CommandResult result = this.runCommand("removeEntry", this.handler, this.getApplicationName(), key.toCharArray(), this.getApplicationName(true));
            if (result.exitCode != 0 || new String(result.retVal).equals("-1")) {
                this.warning("delete action failed");
            }
            return;
        }
    }

    private boolean updateHandler() {
        if (this.timeoutHappened) {
            return false;
        }
        this.handler = new String(this.handler).equals("") ? "0".toCharArray() : this.handler;
        CommandResult result = this.runCommand("isOpen", new char[][]{this.handler});
        if (new String(result.retVal).equals("true")) {
            return true;
        }
        char[] localWallet = this.defaultLocalWallet;
        result = this.runCommand("localWallet", new char[0][]);
        if (result.exitCode == 0) {
            localWallet = result.retVal;
        }
        if (new String(localWallet).contains(".service")) {
            return false;
        }
        result = this.runCommand("open", localWallet, "0".toCharArray(), this.getApplicationName(true));
        if (result.exitCode == 2) {
            this.warning("time out happened while accessing KWallet");
            this.timeoutHappened = true;
            return false;
        }
        if (result.exitCode != 0 || new String(result.retVal).equals("-1")) {
            this.warning("failed to access KWallet");
            return false;
        }
        this.handler = result.retVal;
        return true;
    }

    private CommandResult runCommand(String command, char[] ... commandArgs) {
        Object[] argv = new String[commandArgs.length + 4];
        argv[0] = "qdbus";
        argv[1] = "org.kde.kwalletd";
        argv[2] = "/modules/kwalletd";
        argv[3] = "org.kde.KWallet." + command;
        for (int i = 0; i < commandArgs.length; ++i) {
            argv[i + 4] = new String(commandArgs[i]);
        }
        Runtime rt = Runtime.getRuntime();
        String retVal = "";
        String errVal = "";
        int exitCode = 0;
        try {
            String line;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "executing {0}", Arrays.toString(argv));
            }
            Process pr = rt.exec((String[])argv);
            BufferedReader input = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            while ((line = input.readLine()) != null) {
                if (!retVal.equals("")) {
                    retVal = retVal.concat("\n");
                }
                retVal = retVal.concat(line);
            }
            input.close();
            input = new BufferedReader(new InputStreamReader(pr.getErrorStream()));
            while ((line = input.readLine()) != null) {
                if (!errVal.equals("")) {
                    errVal = errVal.concat("\n");
                }
                errVal = errVal.concat(line);
            }
            input.close();
            exitCode = pr.waitFor();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "application exit with code {0} for commandString: {1}; errVal: {2}", new Object[]{exitCode, Arrays.toString(argv), errVal});
            }
        }
        catch (InterruptedException ex) {
            logger.log(Level.FINE, "exception thrown while invoking the command \"" + Arrays.toString(argv) + "\"", ex);
        }
        catch (IOException ex) {
            logger.log(Level.FINE, "exception thrown while invoking the command \"" + Arrays.toString(argv) + "\"", ex);
        }
        return new CommandResult(exitCode, retVal.trim().toCharArray(), errVal.trim());
    }

    private char[] getApplicationName() {
        return this.getApplicationName(false);
    }

    private char[] getApplicationName(boolean version) {
        return "JOSM".toCharArray();
    }

    private void warning(String descr) {
        logger.log(Level.WARNING, "Something went wrong: {0}", descr);
    }

    private class CommandResult {
        private int exitCode;
        private char[] retVal;
        private String errVal;

        public CommandResult(int exitCode, char[] retVal, String errVal) {
            this.exitCode = exitCode;
            this.retVal = retVal;
            this.errVal = errVal;
        }
    }
}

