/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CadastrePlugin;
import cadastre_fr.GeorefImage;
import cadastre_fr.RasterImageModifier;
import cadastre_fr.WMSLayer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.projection.LambertCC9Zones;
import org.openstreetmap.josm.data.projection.UTM_France_DOM;
import org.openstreetmap.josm.tools.I18n;

public class CacheControl
implements Runnable {
    public static final String cLambertCC9Z = "CC";
    public static final String cUTM20N = "UTM";
    public static boolean cacheEnabled = true;
    public static int cacheSize = 500;
    public WMSLayer wmsLayer = null;
    private ArrayList<GeorefImage> imagesToSave = new ArrayList();
    private Lock imagesLock = new ReentrantLock();

    public boolean isCachePipeEmpty() {
        this.imagesLock.lock();
        boolean ret = this.imagesToSave.isEmpty();
        this.imagesLock.unlock();
        return ret;
    }

    public CacheControl(WMSLayer wmsLayer) {
        cacheEnabled = Main.pref.getBoolean("cadastrewms.enableCaching", true);
        this.wmsLayer = wmsLayer;
        try {
            cacheSize = Integer.parseInt(Main.pref.get("cadastrewms.cacheSize", String.valueOf(0)));
        }
        catch (NumberFormatException e) {
            cacheSize = 0;
        }
        File path = new File(CadastrePlugin.cacheDir);
        if (!path.exists()) {
            path.mkdirs();
        } else {
            this.checkDirSize(path);
        }
        new Thread(this).start();
    }

    private void checkDirSize(File path) {
        if (cacheSize != 0) {
            long size = 0L;
            long oldestFileDate = Long.MAX_VALUE;
            int oldestFile = 0;
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                size += files[i].length();
                if (files[i].lastModified() >= oldestFileDate) continue;
                oldestFile = i;
                oldestFileDate = files[i].lastModified();
            }
            if (size > (long)cacheSize * 1024L * 1024L) {
                System.out.println("Delete oldest file  \"" + files[oldestFile].getName() + "\" in cache dir to stay under the limit of " + cacheSize + " MB.");
                files[oldestFile].delete();
                this.checkDirSize(path);
            }
        }
    }

    public boolean loadCacheIfExist() {
        try {
            File file = new File(CadastrePlugin.cacheDir + this.wmsLayer.getName() + "." + this.WMSFileExtension());
            if (file.exists()) {
                JOptionPane pane = new JOptionPane(I18n.tr((String)"Location \"{0}\" found in cache.\nLoad cache first ?\n(No = new cache)", (Object[])new Object[]{this.wmsLayer.getName()}), 3, 0, null);
                JDialog dialog = pane.createDialog(Main.parent, I18n.tr((String)"Select Feuille", (Object[])new Object[0]));
                CadastrePlugin.prepareDialog(dialog);
                dialog.setVisible(true);
                int reply = (Integer)pane.getValue();
                if (reply == 0 && this.loadCache(file, this.wmsLayer.getLambertZone())) {
                    return true;
                }
                this.delete(file);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return false;
    }

    public void deleteCacheFile() {
        try {
            this.delete(new File(CadastrePlugin.cacheDir + this.wmsLayer.getName() + "." + this.WMSFileExtension()));
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    private void delete(File file) {
        System.out.println("Delete file " + file);
        if (file.exists()) {
            file.delete();
        }
        while (file.exists()) {
            CadastrePlugin.safeSleep(500L);
        }
    }

    public boolean loadCache(File file, int currentLambertZone) {
        boolean successfulRead = false;
        try {
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fis);
            successfulRead = this.wmsLayer.read(ois, currentLambertZone);
            ois.close();
            fis.close();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error loading file.\nProbably an old version of the cache file.", (Object[])new Object[0]), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
            return false;
        }
        if (successfulRead && this.wmsLayer.isRaster()) {
            this.wmsLayer.getImage((int)0).image = RasterImageModifier.fixRasterImage(this.wmsLayer.getImage((int)0).image);
        }
        return successfulRead;
    }

    public synchronized void saveCache(GeorefImage image) {
        this.imagesLock.lock();
        this.imagesToSave.add(image);
        this.notify();
        this.imagesLock.unlock();
    }

    public synchronized void run() {
        while (true) {
            this.imagesLock.lock();
            int size = this.imagesToSave.size();
            this.imagesLock.unlock();
            if (size > 0) {
                File file = new File(CadastrePlugin.cacheDir + this.wmsLayer.getName() + "." + this.WMSFileExtension());
                try {
                    int i;
                    ObjectOutputStream oos;
                    if (file.exists()) {
                        oos = new ObjectOutputStreamAppend(new BufferedOutputStream(new FileOutputStream(file, true)));
                        for (i = 0; i < size; ++i) {
                            oos.writeObject(this.imagesToSave.get(i));
                        }
                        oos.close();
                    } else {
                        oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                        this.wmsLayer.write(oos);
                        for (i = 0; i < size; ++i) {
                            oos.writeObject(this.imagesToSave.get(i));
                        }
                        oos.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace(System.out);
                }
                this.imagesLock.lock();
                for (int i = 0; i < size; ++i) {
                    this.imagesToSave.remove(0);
                }
                this.imagesLock.unlock();
            }
            try {
                this.wait();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace(System.out);
                continue;
            }
            break;
        }
    }

    private String WMSFileExtension() {
        String ext = String.valueOf(this.wmsLayer.getLambertZone() + 1);
        if (Main.getProjection() instanceof LambertCC9Zones) {
            ext = cLambertCC9Z + ext;
        } else if (Main.getProjection() instanceof UTM_France_DOM) {
            ext = cUTM20N + ext;
        }
        return ext;
    }

    public class ObjectOutputStreamAppend
    extends ObjectOutputStream {
        public ObjectOutputStreamAppend(OutputStream out) throws IOException {
            super(out);
        }

        protected void writeStreamHeader() throws IOException {
            this.reset();
        }
    }
}

