/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.intelligence;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.AddressElement;
import org.openstreetmap.josm.plugins.czechaddress.intelligence.ReasonerListener;
import org.openstreetmap.josm.plugins.czechaddress.proposal.ProposalContainer;
import org.openstreetmap.josm.plugins.czechaddress.proposal.ProposalDatabase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reasoner {
    public static final int MATCH_OVERWRITE = 4;
    public static final int MATCH_ROCKSOLID = 3;
    public static final int MATCH_PARTIAL = 2;
    public static final int MATCH_CONFLICT = 1;
    public static final int MATCH_NOMATCH = 0;
    private Map<OsmPrimitive, AddressElement> primBestIndex = new HashMap<OsmPrimitive, AddressElement>();
    private Map<AddressElement, OsmPrimitive> elemBestIndex = new HashMap<AddressElement, OsmPrimitive>();
    private Map<OsmPrimitive, Map<AddressElement, Integer>> primMatchIndex = new HashMap<OsmPrimitive, Map<AddressElement, Integer>>();
    private Map<AddressElement, Map<OsmPrimitive, Integer>> elemMatchIndex = new HashMap<AddressElement, Map<OsmPrimitive, Integer>>();
    private Set<OsmPrimitive> primToUpdate = new HashSet<OsmPrimitive>();
    private Set<AddressElement> elemToUpdate = new HashSet<AddressElement>();
    public static Logger logger = Logger.getLogger(Reasoner.class.getName());
    private static Reasoner singleton = null;
    private boolean transactionOpened = false;
    private Set<ReasonerListener> listeners = new HashSet<ReasonerListener>();

    private Reasoner() {
    }

    public static Reasoner getInstance() {
        if (singleton == null) {
            singleton = new Reasoner();
        }
        return singleton;
    }

    public void reset() {
        this.primToUpdate.clear();
        this.elemToUpdate.clear();
        this.primMatchIndex.clear();
        this.elemMatchIndex.clear();
        this.primBestIndex.clear();
        this.primBestIndex.clear();
        this.transactionOpened = false;
        for (ReasonerListener listener : this.listeners) {
            listener.resonerReseted();
        }
    }

    public void openTransaction() {
        assert (this.primToUpdate.size() == 0);
        assert (this.elemToUpdate.size() == 0);
        assert (!this.transactionOpened);
        this.primToUpdate.clear();
        this.elemToUpdate.clear();
        this.transactionOpened = true;
    }

    public void closeTransaction() {
        AddressElement bestMatch;
        assert (this.transactionOpened);
        HashSet<AddressElement> elemChanges = new HashSet<AddressElement>();
        HashSet<OsmPrimitive> primChanges = new HashSet<OsmPrimitive>();
        for (OsmPrimitive prim : this.primToUpdate) {
            bestMatch = this.getStrictlyBest(prim);
            if (this.primBestIndex.get(prim) == bestMatch) continue;
            if (bestMatch == null) {
                logger.log(Level.FINE, "primitive has no longer best match", AddressElement.getName(prim));
                this.primBestIndex.remove(prim);
                continue;
            }
            logger.log(Level.FINE, "primitive has a new best match", "prim=\u201e" + AddressElement.getName(prim) + "\u201c \u2192 " + "elem=\u201e" + bestMatch + "\u201c");
            elemChanges.add(this.primBestIndex.get(prim));
            this.primBestIndex.put(prim, bestMatch);
        }
        for (AddressElement elem : this.elemToUpdate) {
            bestMatch = this.getStrictlyBest(elem);
            if (this.elemBestIndex.get(elem) == bestMatch) continue;
            if (bestMatch == null) {
                logger.log(Level.FINE, "element has no longer best match", elem);
                this.elemBestIndex.remove(elem);
                continue;
            }
            logger.log(Level.FINE, "element has a new best match", "elem=\u201e" + elem + "\u201c \u2192 " + "prim=\u201e" + AddressElement.getName((OsmPrimitive)bestMatch) + "\u201c");
            primChanges.add(this.elemBestIndex.get(elem));
            this.elemBestIndex.put(elem, (OsmPrimitive)bestMatch);
        }
        this.elemToUpdate.addAll(elemChanges);
        this.primToUpdate.addAll(primChanges);
        this.transactionOpened = false;
        for (ReasonerListener listener : this.listeners) {
            for (AddressElement elem : this.elemToUpdate) {
                if (elem == null) continue;
                listener.elementChanged(elem);
            }
            for (OsmPrimitive prim : this.primToUpdate) {
                if (prim == null) continue;
                listener.primitiveChanged(prim);
            }
        }
        this.primToUpdate.clear();
        this.elemToUpdate.clear();
    }

    public void update(OsmPrimitive prim) {
        logger.log(Level.FINER, "considering primitive", AddressElement.getName(prim));
        assert (this.transactionOpened);
        Map<AddressElement, Integer> matches = this.primMatchIndex.get(prim);
        if (matches == null) {
            logger.log(Level.FINE, "new primitive detected", AddressElement.getName(prim));
            matches = new HashMap<AddressElement, Integer>();
            this.primMatchIndex.put(prim, matches);
            this.primToUpdate.add(prim);
        }
        for (AddressElement elem : this.elemMatchIndex.keySet()) {
            this.reconsider(prim, elem);
        }
    }

    public void update(AddressElement elem) {
        logger.log(Level.FINER, "considering element", elem);
        assert (this.transactionOpened);
        Map<OsmPrimitive, Integer> matches = this.elemMatchIndex.get(elem);
        if (matches == null) {
            logger.log(Level.FINE, "new element detected", elem);
            matches = new HashMap<OsmPrimitive, Integer>();
            this.elemMatchIndex.put(elem, matches);
            this.elemToUpdate.add(elem);
        }
        for (OsmPrimitive prim : this.primMatchIndex.keySet()) {
            this.reconsider(prim, elem);
        }
    }

    private void reconsider(OsmPrimitive prim, AddressElement elem) {
        int newQ;
        assert (this.transactionOpened);
        int oldQ = this.getQ(prim, elem);
        if (oldQ != (newQ = this.evalQ(prim, elem, oldQ))) {
            logger.log(Level.FINE, "reconsidering match", "q=" + String.valueOf(oldQ) + "\u2192" + String.valueOf(newQ) + "; " + "elem=\u201e" + elem + "\u201c; " + "prim=\u201e" + AddressElement.getName(prim) + "\u201c");
            this.putQ(prim, elem, newQ);
            this.primToUpdate.add(prim);
            this.elemToUpdate.add(elem);
            this.primToUpdate.addAll(this.elemMatchIndex.get(elem).keySet());
            this.elemToUpdate.addAll(this.primMatchIndex.get(prim).keySet());
        }
    }

    public void doOverwrite(OsmPrimitive prim, AddressElement elem) {
        logger.log(Level.FINER, "overwriting match", "elem=\u201e" + elem + "\u201c; " + "prim=\u201e" + AddressElement.getName(prim) + "\u201c");
        assert (this.transactionOpened);
        this.update(prim);
        this.update(elem);
        this.putQ(prim, elem, 4);
        this.primToUpdate.add(prim);
        this.elemToUpdate.add(elem);
    }

    public void unOverwrite(OsmPrimitive prim, AddressElement elem) {
        logger.log(Level.FINER, "unoverwriting match", "elem=\u201e" + elem + "\u201c; " + "prim=\u201e" + AddressElement.getName(prim) + "\u201c");
        assert (this.transactionOpened);
        this.update(prim);
        this.update(elem);
        this.putQ(prim, elem, this.evalQ(prim, elem, 0));
        this.primToUpdate.add(prim);
        this.elemToUpdate.add(elem);
    }

    private int getQ(OsmPrimitive prim, AddressElement elem) {
        if (this.elemMatchIndex.get(elem) == null) {
            return 0;
        }
        if (this.primMatchIndex.get(prim) == null) {
            return 0;
        }
        assert (this.primMatchIndex.get(prim).get(elem) == this.elemMatchIndex.get(elem).get(prim));
        if (this.primMatchIndex.get(prim).get(elem) == null) {
            return 0;
        }
        return this.primMatchIndex.get(prim).get(elem);
    }

    private void putQ(OsmPrimitive prim, AddressElement elem, int qVal) {
        if (qVal == 0) {
            this.primMatchIndex.get(prim).remove(elem);
            this.elemMatchIndex.get(elem).remove(prim);
        } else {
            this.primMatchIndex.get(prim).put(elem, qVal);
            this.elemMatchIndex.get(elem).put(prim, qVal);
        }
    }

    private int evalQ(OsmPrimitive prim, AddressElement elem, Integer oldQ) {
        if (prim.isDeleted()) {
            return 0;
        }
        if (oldQ == 4) {
            return 4;
        }
        return elem.getQ(prim);
    }

    public AddressElement translate(OsmPrimitive prim) {
        if (prim == null) {
            return null;
        }
        AddressElement elem = this.getStrictlyBest(prim);
        if (this.getStrictlyBest(elem) == prim) {
            return elem;
        }
        return null;
    }

    public OsmPrimitive translate(AddressElement elem) {
        if (elem == null) {
            return null;
        }
        OsmPrimitive prim = this.getStrictlyBest(elem);
        if (this.getStrictlyBest(prim) == elem) {
            return prim;
        }
        return null;
    }

    public boolean inConflict(OsmPrimitive prim) {
        if (this.primMatchIndex.get(prim) == null) {
            return false;
        }
        return this.primMatchIndex.get(prim).size() > 0 && this.translate(this.translate(prim)) != prim;
    }

    public boolean inConflict(AddressElement elem) {
        if (this.elemMatchIndex.get(elem) == null) {
            return false;
        }
        return this.elemMatchIndex.get(elem).size() > 0 && this.translate(this.translate(elem)) != elem;
    }

    public Set<AddressElement> getCandidates(OsmPrimitive prim) {
        int cand;
        HashSet<AddressElement> result = new HashSet<AddressElement>();
        if (this.primMatchIndex.get(prim) == null) {
            return result;
        }
        int best = 0;
        for (AddressElement elem : this.primMatchIndex.get(prim).keySet()) {
            cand = this.primMatchIndex.get(prim).get(elem);
            if (best >= cand) continue;
            best = cand;
        }
        for (AddressElement elem : this.primMatchIndex.get(prim).keySet()) {
            cand = this.primMatchIndex.get(prim).get(elem);
            if (best != cand) continue;
            result.add(elem);
        }
        return result;
    }

    public Set<OsmPrimitive> getCandidates(AddressElement elem) {
        int cand;
        HashSet<OsmPrimitive> result = new HashSet<OsmPrimitive>();
        if (this.elemMatchIndex.get(elem) == null) {
            return result;
        }
        int best = 0;
        for (OsmPrimitive prim : this.elemMatchIndex.get(elem).keySet()) {
            cand = this.elemMatchIndex.get(elem).get(prim);
            if (best >= cand) continue;
            best = cand;
        }
        for (OsmPrimitive prim : this.elemMatchIndex.get(elem).keySet()) {
            cand = this.elemMatchIndex.get(elem).get(prim);
            if (best != cand) continue;
            result.add(prim);
        }
        return result;
    }

    public AddressElement getStrictlyBest(OsmPrimitive prim) {
        AddressElement result = null;
        try {
            if (!this.transactionOpened) {
                return this.primBestIndex.get(prim);
            }
            Map<AddressElement, Integer> matches = this.primMatchIndex.get(prim);
            if (matches == null) {
                return null;
            }
            int bestQ = 0;
            for (AddressElement elem : matches.keySet()) {
                if (matches.get(elem) == bestQ) {
                    result = null;
                }
                if (matches.get(elem) <= bestQ) continue;
                bestQ = matches.get(elem);
                result = elem;
            }
        }
        catch (NullPointerException except) {
            System.err.println("Strange exception occurred. If you find a way to reproduce this situation, please e-mail the author of the CzechAddress plugin.");
            except.printStackTrace();
        }
        return result;
    }

    public OsmPrimitive getStrictlyBest(AddressElement elem) {
        OsmPrimitive result = null;
        try {
            if (!this.transactionOpened) {
                return this.elemBestIndex.get(elem);
            }
            Map<OsmPrimitive, Integer> matches = this.elemMatchIndex.get(elem);
            if (matches == null) {
                return null;
            }
            int bestQ = 0;
            for (OsmPrimitive prim : matches.keySet()) {
                if (matches.get(prim) == bestQ) {
                    result = null;
                }
                if (matches.get(prim) <= bestQ) continue;
                bestQ = matches.get(prim);
                result = prim;
            }
        }
        catch (NullPointerException except) {
            System.err.println("Strange exception occurred. If you find a way to reproduce this situation, please e-mail the author of the CzechAddress plugin.");
            except.printStackTrace();
        }
        return result;
    }

    public Set<AddressElement> getUnassignedElements() {
        HashSet<AddressElement> result = new HashSet<AddressElement>();
        for (AddressElement elem : this.elemMatchIndex.keySet()) {
            if (this.translate(elem) != null) continue;
            result.add(elem);
        }
        return result;
    }

    public Set<OsmPrimitive> getUnassignedPrimitives() {
        HashSet<OsmPrimitive> result = new HashSet<OsmPrimitive>();
        for (OsmPrimitive prim : this.primMatchIndex.keySet()) {
            if (this.translate(prim) != null) continue;
            result.add(prim);
        }
        return result;
    }

    public Set<AddressElement> getAllElements() {
        HashSet<AddressElement> result = new HashSet<AddressElement>();
        result.addAll(this.elemMatchIndex.keySet());
        return result;
    }

    public Set<OsmPrimitive> getAllPrimitives() {
        HashSet<OsmPrimitive> result = new HashSet<OsmPrimitive>();
        result.addAll(this.primMatchIndex.keySet());
        return result;
    }

    public ProposalDatabase getProposals() {
        ProposalDatabase database = new ProposalDatabase();
        for (OsmPrimitive prim : this.primBestIndex.keySet()) {
            AddressElement elem = this.translate(prim);
            if (elem == null) continue;
            ProposalContainer container = new ProposalContainer(prim);
            container.addProposals(elem.getDiff(prim));
            if (container.getProposals().size() <= 0) continue;
            database.addContainer(container);
        }
        Collections.sort(database.getContainers());
        return database;
    }

    public void addListener(ReasonerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ReasonerListener listener) {
        this.listeners.remove(listener);
    }
}

