/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.map.proj;

import com.jhlabs.map.AngleFormat;
import com.jhlabs.map.Unit;
import com.jhlabs.map.Units;
import com.jhlabs.map.proj.Ellipsoid;
import com.jhlabs.map.proj.LambertConformalConicProjection;
import com.jhlabs.map.proj.Projection;
import com.jhlabs.map.proj.ProjectionException;
import com.jhlabs.map.proj.TransverseMercatorProjection;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ProjectionFactory {
    private static final double SIXTH = 0.16666666666666666;
    private static final double RA4 = 0.04722222222222222;
    private static final double RA6 = 0.022156084656084655;
    private static final double RV4 = 0.06944444444444445;
    private static final double RV6 = 0.04243827160493827;
    private static AngleFormat format = new AngleFormat("DdM", true);
    static Hashtable registry;

    public static Projection fromPROJ4Specification(String[] args) {
        Unit unit;
        Projection projection = null;
        Ellipsoid ellipsoid = null;
        double a = 0.0;
        double b = 0.0;
        double es = 0.0;
        Hashtable<String, String> params = new Hashtable<String, String>();
        for (int i = 0; i < args.length; ++i) {
            int index;
            String arg = args[i];
            if (!arg.startsWith("+") || (index = arg.indexOf(61)) == -1) continue;
            String key = arg.substring(1, index);
            String value = arg.substring(index + 1);
            params.put(key, value);
        }
        String s = (String)params.get("proj");
        if (s != null && (projection = ProjectionFactory.getNamedPROJ4Projection(s)) == null) {
            throw new ProjectionException("Unknown projection: " + s);
        }
        s = (String)params.get("init");
        if (s != null) {
            projection = ProjectionFactory.getNamedPROJ4CoordinateSystem(s);
            if (projection == null) {
                throw new ProjectionException("Unknown projection: " + s);
            }
            a = projection.getEquatorRadius();
            es = projection.getEllipsoid().getEccentricitySquared();
        }
        String ellipsoidName = "";
        s = (String)params.get("R");
        if (s != null) {
            a = Double.parseDouble(s);
        } else {
            s = (String)params.get("ellps");
            if (s == null) {
                s = (String)params.get("datum");
            }
            if (s != null) {
                Ellipsoid[] ellipsoids = Ellipsoid.ellipsoids;
                for (int i = 0; i < ellipsoids.length; ++i) {
                    if (!ellipsoids[i].shortName.equals(s)) continue;
                    ellipsoid = ellipsoids[i];
                    break;
                }
                if (ellipsoid == null) {
                    throw new ProjectionException("Unknown ellipsoid: " + s);
                }
                es = ellipsoid.eccentricity2;
                a = ellipsoid.equatorRadius;
                ellipsoidName = s;
            } else {
                s = (String)params.get("a");
                if (s != null) {
                    a = Double.parseDouble(s);
                }
                if ((s = (String)params.get("es")) != null) {
                    es = Double.parseDouble(s);
                } else {
                    s = (String)params.get("rf");
                    if (s != null) {
                        es = Double.parseDouble(s);
                        es *= 2.0 - es;
                    } else {
                        s = (String)params.get("f");
                        if (s != null) {
                            es = Double.parseDouble(s);
                            es = 1.0 / es;
                            es *= 2.0 - es;
                        } else {
                            s = (String)params.get("b");
                            if (s != null) {
                                b = Double.parseDouble(s);
                                es = 1.0 - b * b / (a * a);
                            }
                        }
                    }
                }
                if (b == 0.0) {
                    b = a * Math.sqrt(1.0 - es);
                }
            }
            s = (String)params.get("R_A");
            if (s != null && Boolean.getBoolean(s)) {
                a *= 1.0 - es * (0.16666666666666666 + es * (0.04722222222222222 + es * 0.022156084656084655));
            } else {
                s = (String)params.get("R_V");
                if (s != null && Boolean.getBoolean(s)) {
                    a *= 1.0 - es * (0.16666666666666666 + es * (0.06944444444444445 + es * 0.04243827160493827));
                } else {
                    s = (String)params.get("R_a");
                    if (s != null && Boolean.getBoolean(s)) {
                        a = 0.5 * (a + b);
                    } else {
                        s = (String)params.get("R_g");
                        if (s != null && Boolean.getBoolean(s)) {
                            a = Math.sqrt(a * b);
                        } else {
                            s = (String)params.get("R_h");
                            if (s != null && Boolean.getBoolean(s)) {
                                a = 2.0 * a * b / (a + b);
                                es = 0.0;
                            } else {
                                s = (String)params.get("R_lat_a");
                                if (s != null) {
                                    double tmp = Math.sin(ProjectionFactory.parseAngle(s));
                                    if (Math.abs(tmp) > 1.5707963267948966) {
                                        throw new ProjectionException("-11");
                                    }
                                    tmp = 1.0 - es * tmp * tmp;
                                    a *= 0.5 * (1.0 - es + tmp) / (tmp * Math.sqrt(tmp));
                                    es = 0.0;
                                } else {
                                    s = (String)params.get("R_lat_g");
                                    if (s != null) {
                                        double tmp = Math.sin(ProjectionFactory.parseAngle(s));
                                        if (Math.abs(tmp) > 1.5707963267948966) {
                                            throw new ProjectionException("-11");
                                        }
                                        tmp = 1.0 - es * tmp * tmp;
                                        a *= Math.sqrt(1.0 - es) / tmp;
                                        es = 0.0;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        projection.setEllipsoid(new Ellipsoid(ellipsoidName, a, es, ellipsoidName));
        s = (String)params.get("lat_0");
        if (s != null) {
            projection.setProjectionLatitudeDegrees(ProjectionFactory.parseAngle(s));
        }
        if ((s = (String)params.get("lon_0")) != null) {
            projection.setProjectionLongitudeDegrees(ProjectionFactory.parseAngle(s));
        }
        if ((s = (String)params.get("lat_1")) != null) {
            projection.setProjectionLatitude1Degrees(ProjectionFactory.parseAngle(s));
        }
        if ((s = (String)params.get("lat_2")) != null) {
            projection.setProjectionLatitude2Degrees(ProjectionFactory.parseAngle(s));
        }
        if ((s = (String)params.get("lat_ts")) != null) {
            projection.setTrueScaleLatitudeDegrees(ProjectionFactory.parseAngle(s));
        }
        if ((s = (String)params.get("x_0")) != null) {
            projection.setFalseEasting(Double.parseDouble(s));
        }
        if ((s = (String)params.get("y_0")) != null) {
            projection.setFalseNorthing(Double.parseDouble(s));
        }
        if ((s = (String)params.get("k_0")) == null) {
            s = (String)params.get("k");
        }
        if (s != null) {
            projection.setScaleFactor(Double.parseDouble(s));
        }
        if ((s = (String)params.get("units")) != null && (unit = Units.findUnits(s)) != null) {
            projection.setFromMetres(1.0 / unit.value);
        }
        if ((s = (String)params.get("to_meter")) != null) {
            projection.setFromMetres(1.0 / Double.parseDouble(s));
        }
        if (projection instanceof TransverseMercatorProjection && (s = (String)params.get("zone")) != null) {
            ((TransverseMercatorProjection)projection).setUTMZone(Integer.parseInt(s));
        }
        projection.initialize();
        return projection;
    }

    private static double parseAngle(String s) {
        return format.parse(s, null).doubleValue();
    }

    static void register(String name, Class cls, String description) {
        registry.put(name, cls);
    }

    static Projection getNamedPROJ4Projection(String name) {
        Class cls;
        if (registry == null) {
            ProjectionFactory.initialize();
        }
        if ((cls = (Class)registry.get(name)) != null) {
            try {
                Projection projection = (Projection)cls.newInstance();
                if (projection != null) {
                    projection.setName(name);
                }
                return projection;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    static void initialize() {
        registry = new Hashtable();
        ProjectionFactory.register("lcc", LambertConformalConicProjection.class, "Lambert Conformal Conic");
    }

    public static Projection readProjectionFile(String file, String name) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(ProjectionFactory.class.getResourceAsStream("/nad/" + file)));
        StreamTokenizer t = new StreamTokenizer(reader);
        t.commentChar(35);
        t.ordinaryChars(48, 57);
        t.ordinaryChars(46, 46);
        t.ordinaryChars(45, 45);
        t.ordinaryChars(43, 43);
        t.wordChars(48, 57);
        t.wordChars(39, 39);
        t.wordChars(34, 34);
        t.wordChars(95, 95);
        t.wordChars(46, 46);
        t.wordChars(45, 45);
        t.wordChars(43, 43);
        t.wordChars(44, 44);
        t.nextToken();
        while (t.ttype == 60) {
            t.nextToken();
            if (t.ttype != -3) {
                throw new IOException(t.lineno() + ": Word expected after '<'");
            }
            String cname = t.sval;
            t.nextToken();
            if (t.ttype != 62) {
                throw new IOException(t.lineno() + ": '>' expected");
            }
            t.nextToken();
            Vector<String> v = new Vector<String>();
            String values = "";
            while (t.ttype != 60) {
                if (t.ttype == 43) {
                    t.nextToken();
                }
                if (t.ttype != -3) {
                    throw new IOException(t.lineno() + ": Word expected after '+'");
                }
                String key = t.sval;
                t.nextToken();
                if (t.ttype != 61) continue;
                t.nextToken();
                String value = t.sval;
                t.nextToken();
                if (key.startsWith("+")) {
                    v.add(key + "=" + value);
                    continue;
                }
                v.add("+" + key + "=" + value);
            }
            t.nextToken();
            if (t.ttype != 62) {
                throw new IOException(t.lineno() + ": '<>' expected");
            }
            t.nextToken();
            if (!cname.equals(name)) continue;
            Object[] args = new String[v.size()];
            v.copyInto(args);
            reader.close();
            return ProjectionFactory.fromPROJ4Specification((String[])args);
        }
        reader.close();
        return null;
    }

    public static Projection getNamedPROJ4CoordinateSystem(String name) {
        String[] files = new String[]{"world", "nad83", "nad27", "esri", "epsg"};
        try {
            int p = name.indexOf(58);
            if (p >= 0) {
                return ProjectionFactory.readProjectionFile(name.substring(0, p), name.substring(p + 1));
            }
            for (int i = 0; i < files.length; ++i) {
                Projection projection = ProjectionFactory.readProjectionFile(files[i], name);
                if (projection == null) continue;
                return projection;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void main(String[] args) {
        Projection projection = ProjectionFactory.fromPROJ4Specification(args);
        if (projection != null) {
            System.out.println(projection.getPROJ4Description());
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.startsWith("+") || arg.startsWith("-")) continue;
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new FileReader(new File(args[i])));
                    Point2D.Double p = new Point2D.Double();
                    while ((line = reader.readLine()) != null) {
                        StringTokenizer t = new StringTokenizer(line, " ");
                        String slon = t.nextToken();
                        String slat = t.nextToken();
                        p.x = format.parse(slon, null).doubleValue();
                        p.y = format.parse(slat, null).doubleValue();
                        projection.transform(p, p);
                        System.out.println(p.x + " " + p.y);
                    }
                    continue;
                }
                catch (IOException e) {
                    System.out.println("IOException: " + args[i] + ": " + e.getMessage());
                }
            }
        } else {
            System.out.println("Can't find projection " + args[0]);
        }
    }
}

