/*
 * Decompiled with CFR 0.152.
 */
package public_transport;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.tools.I18n;
import public_transport.GTFSImporterAction;
import public_transport.GTFSStopTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GTFSJoinCommand
extends Command {
    private Vector<Integer> workingLines = null;
    private Node undoMapNode = null;
    private Node undoTableNode = null;
    private GTFSStopTableModel gtfsStopTM = null;
    private String type = null;

    public GTFSJoinCommand(GTFSImporterAction controller) {
        this.gtfsStopTM = controller.getGTFSStopTableModel();
        this.workingLines = new Vector();
        int[] selectedLines = controller.getDialog().getGTFSStopTable().getSelectedRows();
        if (selectedLines.length != 1) {
            return;
        }
        this.workingLines.add(selectedLines[0]);
    }

    public boolean executeCommand() {
        Node node;
        if (this.workingLines.size() != 1) {
            return false;
        }
        Node dest = null;
        Iterator iter = Main.main.getCurrentDataSet().getSelectedNodes().iterator();
        int j = this.workingLines.elementAt(0);
        while (iter.hasNext()) {
            Node n = (Node)iter.next();
            if (n != null && n.equals((Object)this.gtfsStopTM.nodes.elementAt(j))) continue;
            if (dest != null) {
                return false;
            }
            dest = n;
        }
        if (dest == null) {
            return false;
        }
        this.undoMapNode = new Node(dest);
        this.undoTableNode = node = this.gtfsStopTM.nodes.elementAt(j);
        if (node != null) {
            Main.main.getCurrentDataSet().removePrimitive((PrimitiveId)node);
            node.setDeleted(true);
        }
        dest.put("highway", "bus_stop");
        dest.put("stop_id", (String)this.gtfsStopTM.getValueAt(j, 0));
        if (dest.get("name") == null) {
            dest.put("name", (String)this.gtfsStopTM.getValueAt(j, 1));
        }
        this.gtfsStopTM.nodes.set(j, dest);
        this.type = (String)this.gtfsStopTM.getValueAt(j, 2);
        this.gtfsStopTM.setValueAt(I18n.tr((String)"moved"), j, 2);
        return true;
    }

    public void undoCommand() {
        if (this.workingLines.size() != 1) {
            return;
        }
        int j = this.workingLines.elementAt(0);
        Node node = this.gtfsStopTM.nodes.elementAt(j);
        if (node != null) {
            Main.main.getCurrentDataSet().removePrimitive((PrimitiveId)node);
            node.setDeleted(true);
        }
        if (this.undoMapNode != null) {
            this.undoMapNode.setDeleted(false);
            Main.main.getCurrentDataSet().addPrimitive((OsmPrimitive)this.undoMapNode);
        }
        if (this.undoTableNode != null) {
            this.undoTableNode.setDeleted(false);
            Main.main.getCurrentDataSet().addPrimitive((OsmPrimitive)this.undoTableNode);
        }
        this.gtfsStopTM.nodes.set(j, this.undoTableNode);
        this.gtfsStopTM.setValueAt(this.type, j, 2);
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    public JLabel getDescription() {
        return new JLabel(I18n.tr((String)"Public Transport: Join GTFS stops"));
    }
}

